/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import org.lsst.ccs.drivers.ascii.AsciiIO;
import org.lsst.ccs.drivers.ascii.AsciiIOFtdi;
import org.lsst.ccs.drivers.ascii.AsciiIONet;
import org.lsst.ccs.drivers.ascii.AsciiIOSerial;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class Ascii {
    public static final int CONN_TYPE_NETWORK = 0;
    public static final int CONN_TYPE_FTDI = 1;
    public static final int CONN_TYPE_SERIAL = 2;
    static final int PARITY_NONE = 0;
    static final int PARITY_ODD = 1;
    static final int PARITY_EVEN = 2;
    static final int PARITY_MARK = 3;
    static final int PARITY_SPACE = 4;
    static final int DBITS_EIGHT = 0;
    static final int DBITS_SEVEN = 1;
    static final int SBITS_ONE = 0;
    static final int SBITS_TWO = 1;
    static final int FLOW_NONE = 0;
    static final int FLOW_RTS_CTS = 1;
    static final int FLOW_DTR_DSR = 2;
    static final int FLOW_XON_XOFF = 4;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final byte[] buff = new byte[65536];
    private AsciiIO io;
    private String terminator = "\r\n";
    private int timeout = 1000;
    private int buffIn;
    private int buffOut;

    public void open(int type, String ident, int parm) throws DriverException {
        this.open(type, ident, parm, 0);
    }

    public synchronized void open(int type, String ident, int parm1, int parm2) throws DriverException {
        AsciiIO newIo;
        if (this.io != null) {
            throw new DriverException("Device already connected");
        }
        switch (type) {
            case 0: {
                newIo = new AsciiIONet();
                break;
            }
            case 1: {
                newIo = new AsciiIOFtdi();
                break;
            }
            case 2: {
                newIo = new AsciiIOSerial();
                break;
            }
            default: {
                throw new DriverException("Invalid connection type: " + type);
            }
        }
        newIo.open(ident, parm1, parm2);
        this.io = newIo;
        this.io.setTimeout(this.timeout);
    }

    public int makeDataCharacteristics(DataBits dataBits, StopBits stopBits, Parity parity, FlowCtrl flowCtrl) {
        return dataBits.getValue() << 24 | stopBits.getValue() << 16 | parity.getValue() << 8 | flowCtrl.getValue();
    }

    public synchronized void close() throws DriverException {
        this.checkOpen();
        try {
            this.io.close();
        }
        finally {
            this.io = null;
            this.buffOut = 0;
            this.buffIn = 0;
        }
    }

    public boolean closeSilent() {
        try {
            this.close();
            return true;
        }
        catch (DriverException driverException) {
            return false;
        }
    }

    public synchronized void write(String command) throws DriverException {
        this.checkOpen();
        this.io.write((String.valueOf(command) + this.terminator).getBytes());
    }

    public synchronized String read() throws DriverException {
        this.checkOpen();
        try {
            int start = this.buffOut;
            int end = this.buffIn;
            int term = -1;
            while (true) {
                int j = start;
                while (j < end) {
                    if (this.buff[j] == 13 || this.buff[j] == 10) {
                        if (j == this.buffOut) {
                            ++this.buffOut;
                        } else {
                            term = j;
                            break;
                        }
                    }
                    ++j;
                }
                if (term >= 0) {
                    String resp = new String(this.buff, this.buffOut, term - this.buffOut);
                    this.buffOut = term + 1;
                    return resp;
                }
                if (this.buffOut > 0) {
                    System.arraycopy(this.buff, this.buffOut, this.buff, 0, this.buffIn - this.buffOut);
                    this.buffIn -= this.buffOut;
                    this.buffOut = 0;
                }
                if (this.buffIn >= this.buff.length) {
                    throw new DriverException("Input buffer overflow");
                }
                start = this.buffIn;
                this.buffIn += this.io.read(this.buff, this.buffIn);
                end = this.buffIn;
            }
        }
        catch (DriverTimeoutException re) {
            throw re;
        }
        catch (DriverException re) {
            this.closeSilent();
            throw re;
        }
    }

    public synchronized String read(String command) throws DriverException {
        this.flush();
        this.write(command);
        return this.read();
    }

    public synchronized void flush() throws DriverException {
        this.checkOpen();
        this.buffIn = this.buffOut;
        this.io.flush();
    }

    public void setTerminator(String term) {
        this.terminator = term;
    }

    public synchronized void setTimeout(double time) throws DriverException {
        this.timeout = (int)(1000.0 * time);
        if (this.io != null) {
            this.io.setTimeout(this.timeout);
        }
    }

    private void checkOpen() throws DriverException {
        if (this.io == null) {
            throw new DriverException("Device not connected");
        }
    }

    public static enum DataBits {
        SEVEN(1),
        EIGHT(0);

        int value;

        private DataBits(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum FlowCtrl {
        NONE(0),
        RTS(1),
        DTR(2),
        XON(4),
        RTS_DTR(3),
        RTS_XON(5),
        DTR_XON(6),
        RTS_DTR_XON(7);

        int value;

        private FlowCtrl(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Parity {
        NONE(0),
        ODD(1),
        EVEN(2),
        MARK(3),
        SPACE(4);

        int value;

        private Parity(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum StopBits {
        ONE(0),
        TWO(1);

        int value;

        private StopBits(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

