/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import java.util.Arrays;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class E3631
extends Ascii {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final String terminator = "\r\n";
    private int timeout = 1000;
    private String saddr;
    private final Boolean verbose = true;
    private final Boolean fakeout = true;

    public void open(String serialname, int port) throws DriverException {
        this.open(2, serialname, port);
        this.init();
    }

    public void openftdi(String serialname, int port) throws DriverException {
        System.out.println("opening connection to the Agilent E3631 Power Supply");
        this.open(1, serialname, port);
    }

    public void init() throws DriverException {
    }

    public void close() throws DriverException {
    }

    public void selectOutput(String outname) throws DriverException {
        if (!Arrays.asList("P6V", "P25V", "N25V").contains(outname)) {
            String errstr = "E3631 selectOutput: Invalid output specified:" + outname;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            this.sendCommand("INST:SEL " + outname);
        }
        catch (DriverException e) {
            String errstr = "E3631 selectOutput: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getOutput(String outname) throws DriverException {
        if (!Arrays.asList("P6V", "P25V", "N25V").contains(outname)) {
            String errstr = "E3631 getOutput: Invalid output specified:" + outname;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            String outstr = this.getReply("INST:SEL?");
            return outstr;
        }
        catch (DriverException e) {
            String errstr = "E3631 gettOutput:" + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void outputOn(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            this.sendCommand("OUTPUT:STATE ON ");
        }
        catch (DriverException e) {
            String errstr = "E3631 outputOn: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void outputOff(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            this.sendCommand("OUTPUT:STATE OFF ");
        }
        catch (DriverException e) {
            String errstr = "E3631 outputOn: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public double getVoltage(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            String voltstr = this.getReply("MEAS:VOLT:DC? " + outname);
            return Double.valueOf(voltstr);
        }
        catch (DriverException e) {
            String errstr = "E3631 getVoltage: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public double getCurrent(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            String ampstr = this.getReply("MEAS:CURR:DC? " + outname);
            return Double.valueOf(ampstr);
        }
        catch (DriverException e) {
            String errstr = "E3631 getCurrent: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setVoltage(String outname, double volts) throws DriverException {
        if (this.fakeout.booleanValue()) {
            System.out.println("E3631 setVoltage: outname = " + outname);
            System.out.println("E3631 setVoltage: volts   = " + volts);
            return;
        }
        Boolean voltageError = false;
        switch (outname) {
            case "P5V": {
                if (!(volts < 0.0) && !(volts > 6.0)) break;
                voltageError = true;
                break;
            }
            case "P25V": {
                if (!(volts < 0.0) && !(volts > 25.0)) break;
                voltageError = true;
                break;
            }
            case "N25V": {
                if (!(volts > 0.0) && !(volts < -25.0)) break;
                voltageError = true;
                break;
            }
            default: {
                String errstr = "E3631 setVoltage: output name error";
                System.out.println(errstr);
                throw new DriverException(errstr);
            }
        }
        if (voltageError.booleanValue()) {
            String errstr = "E3631 setVoltage: voltage error";
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            this.selectOutput(outname);
            this.sendCommand("VOLT:DC " + volts);
        }
        catch (DriverException e) {
            String errstr = "E3631 setVoltage: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setCurrent(String outname, double amps) throws DriverException {
        if (this.fakeout.booleanValue()) {
            System.out.println("E3631 setCurrent: outname = " + outname + "amps =" + amps);
            return;
        }
        Boolean currentError = false;
        switch (outname) {
            case "P5V": {
                if (!(amps < 0.0) && !(amps > 6.0)) break;
                currentError = true;
                break;
            }
            case "P25V": {
                if (!(amps < 0.0) && !(amps > 1.0)) break;
                currentError = true;
                break;
            }
            case "N25V": {
                if (!(amps < 0.0) && !(amps > 1.0)) break;
                currentError = true;
                break;
            }
            default: {
                String errstr = "E3631 setCurrent: output name error";
                System.out.println(errstr);
                throw new DriverException(errstr);
            }
        }
        if (!currentError.booleanValue()) {
            String errstr = "E3631 setCurrent: current error";
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            this.selectOutput(outname);
            this.sendCommand("CURR:DC " + amps);
        }
        catch (DriverException e) {
            String errstr = "E3631 setCurrent: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getID() throws DriverException {
        try {
            String idString = this.getReply("*IDN?");
            if (this.verbose.booleanValue()) {
                System.out.println("E3631 ID: " + idString);
            }
            return idString;
        }
        catch (DriverException e) {
            String errstr = "E3631 getID: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getError() throws DriverException {
        try {
            String errString = this.getReply("ERR");
            if (this.verbose.booleanValue()) {
                System.out.println("E3631 ID: " + errString);
            }
            return errString;
        }
        catch (DriverException e) {
            String errstr = "E3631 getError: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void sendCommand(String command) throws DriverException {
        if (this.verbose.booleanValue()) {
            System.out.println("E3631Command: " + command);
        }
        this.writeE3631(command);
    }

    public String getReply(String command) throws DriverException {
        if (this.verbose.booleanValue()) {
            System.out.println("E3631 getReply: " + command);
        }
        this.writeE3631(command);
        String reply = this.readE3631();
        return reply;
    }

    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    public synchronized void writeE3631(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readE3631() throws DriverException {
        return this.read();
    }

    public synchronized String readE3631(String command) throws DriverException {
        this.writeE3631(command);
        return this.readE3631();
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

