/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bootstrap;

import java.util.ArrayList;
import java.util.List;

public class BootstrapClassLoader
extends ClassLoader {
    static List<ClassLoader> classLoders = new ArrayList<ClassLoader>();

    public BootstrapClassLoader(ClassLoader cl) {
        super(cl);
        BootstrapClassLoader.addClassLoader(cl);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (ClassLoader cl : classLoders) {
            try {
                clazz = cl.loadClass(name);
                break;
            }
            catch (Exception exception) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Could not load class " + name);
        }
        return clazz;
    }

    static void addClassLoader(ClassLoader cl) {
        classLoders.add(cl);
    }

    List<ClassLoader> getClassLoaders() {
        return classLoders;
    }
}

