package org.lsst.ccs.drivers.agilent;

import java.util.Random;
import org.lsst.ccs.drivers.agilent.PowerSupply;
import java.util.Arrays;
/**
 **************************************************************************
 **
 **  Enables access to a device
 **
 **  @author Your Name
 **
 ***************************************************************************
 */

public class Device {

  /** The First of our devices */
  public final static int MYDEV0_DID = 0;

  /** The number of known device identifiers */
  private final static int N_DIDS     = 1;
  
  private final static int[] pids = new int[N_DIDS];
  private final static int MY_PID = 0x0666;
  private final static int MAX_CHANNELS = 4;
 
  static {
    pids[MYDEV0_DID] = MYDEV0_DID;
  }

  private int devId = -1;
  private channelList[] channels = null;

  public Device() throws Exception {
    channels = new channelList[MAX_CHANNELS];
  }

  public void init(String hostname, int channelNumber, 
                   int powerOnOrder, double voltage, double currLimit) 
              throws Exception {
      if (hostname.length() <= 0)
          throw new Exception("Null hostname");            
      if (channelNumber < 0 || channelNumber > MAX_CHANNELS)
          throw new Exception("Invalid channel number");
      // if ((channels.length - 1) > channelNumber)
      //     throw new Exception("Channel number out of bounds");
      // if (channels[channelNumber] != null)
      //     throw new Exception("Channel already init");

      channels[channelNumber] = new channelList(hostname, channelNumber,
                                                powerOnOrder);
      channels[channelNumber].voltage = voltage;
      channels[channelNumber].currentLimit = currLimit;
  }

  public PowerSupply getChannel(int channelNumber) throws Exception {
      return channels[channelNumber].power;
  }

  public double chanVoltage(int channelNumber) throws Exception {
      return channels[channelNumber].power.getVoltage();
  }

  public void powerOn() {
    Arrays.sort(channels);

    for (int idx = 0; idx < channels.length; idx++) {
        channelList chan = channels[idx];
        PowerSupply pwr  = chan.power;

        pwr.mode(PowerSupply.VOLTAGE_MODE);
        pwr.currentLimit(chan.currentLimit);
        pwr.setVoltage(chan.voltage);
        pwr.on();
    }
  }
 
  public void powerOff() {
    Arrays.sort(channels);

    for (int idx = channels.length - 1; idx >= 0; idx--) {
        channelList chan = channels[idx];
        PowerSupply pwr  = chan.power;

        pwr.off();
    }
  }

  private class channelList implements Comparable<channelList> {
      public double voltage      = 0.0;
      public double currentLimit = 0.0;
      public int powerOnOrder    = 0;
      public PowerSupply power   = null;

      public channelList(String hostname, int channelNumber, int powerOnOrder){
          this.powerOnOrder = powerOnOrder;
          this.power        = new PowerSupply(hostname, channelNumber + 1);
      }

      @Override
      public int compareTo(channelList other) {
          return this.powerOnOrder - other.powerOnOrder;
      }
  }
}
