/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.InputConversionEngine;
import org.lsst.ccs.command.MethodBasedCommandDictionary;
import org.lsst.ccs.command.MethodBasedDictionaryCommand;
import org.lsst.ccs.command.RawCommand;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.command.annotations.Command;

public class CommandSetBuilder {
    private InputConversionEngine engine = new InputConversionEngine();

    public CommandSet buildCommandSet(Object object) {
        Class<?> targetClass = object.getClass();
        MethodBasedCommandDictionary dict = new MethodBasedCommandDictionary();
        CommandSetImplementation commandSet = new CommandSetImplementation(dict, object);
        Method[] methodArray = targetClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Command annotation = method.getAnnotation(Command.class);
            if (annotation != null) {
                MethodBasedDictionaryCommand dc = new MethodBasedDictionaryCommand(method, annotation);
                dict.add(dc);
                commandSet.add(dc, method);
            }
            ++n2;
        }
        return commandSet;
    }

    private class CommandSetImplementation
    implements CommandSet {
        private final Dictionary dict;
        private final Object target;
        private final Map<DictionaryCommand, Method> methods = new HashMap<DictionaryCommand, Method>();

        private CommandSetImplementation(Dictionary dict, Object target) {
            this.dict = dict;
            this.target = target;
        }

        @Override
        public Dictionary getCommandDictionary() {
            return this.dict;
        }

        @Override
        public Object invoke(BasicCommand command) throws CommandInvocationException {
            DictionaryCommand dc = this.dict.findCommand(command);
            if (dc == null) {
                throw new CommandInvocationException("Error: No handler found for command %s with %d arguments", command.getCommand(), command.getArgumentCount());
            }
            return this.invoke(this.target, this.methods.get(dc), command);
        }

        private void add(DictionaryCommand dc, Method method) {
            this.methods.put(dc, method);
        }

        private Object invoke(Object target, Method method, BasicCommand command) throws CommandInvocationException {
            try {
                RawCommand rawCommand;
                if (command instanceof RawCommand) {
                    rawCommand = (RawCommand)command;
                } else if (command instanceof TokenizedCommand) {
                    rawCommand = this.convertToRaw((TokenizedCommand)command, method);
                } else {
                    throw new CommandInvocationException("Error: Unknown type of command " + command.getClass().getName(), new Object[0]);
                }
                return method.invoke(target, rawCommand.getArguments());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new CommandInvocationException("Error: Can't invoke command", ex);
            }
            catch (InvocationTargetException ex) {
                throw new CommandInvocationException(ex);
            }
        }

        private RawCommand convertToRaw(TokenizedCommand tokenizedCommand, Method method) throws CommandInvocationException {
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<Object> args = new ArrayList<Object>(parameterTypes.length);
            boolean varArgs = method.isVarArgs();
            int i = 0;
            while (i < parameterTypes.length) {
                if (varArgs && i == parameterTypes.length - 1) {
                    Class<?> varClass = parameterTypes[i];
                    Class<?> elemClass = varClass.getComponentType();
                    Object theArray = Array.newInstance(elemClass, tokenizedCommand.getArgumentCount() - parameterTypes.length + 1);
                    int j = 0;
                    while (j < Array.getLength(theArray)) {
                        Array.set(theArray, j, CommandSetBuilder.this.engine.convertArgToType(tokenizedCommand.getArgument(i + j), elemClass));
                        ++j;
                    }
                    args.add(theArray);
                } else {
                    args.add(CommandSetBuilder.this.engine.convertArgToType(tokenizedCommand.getArgument(i), parameterTypes[i]));
                }
                ++i;
            }
            return new RawCommand(tokenizedCommand.getCommand(), args);
        }
    }
}

