/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.aerotech;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class AerotechPro165
extends Ascii {
    public static double timeout = 30000.0;
    public static final int DEFAULT_PORT = 8000;
    public static final int DEFAULT_BAUD = 9600;
    public static final String DEFAULT_DEV = "/dev/ttyS1";
    private static final char RESP_SUCCESS = '%';
    private static final char RESP_INVALID = '!';
    private static final char RESP_FAULT = '#';
    private static final char RESP_TIMEOUT = '$';
    private double speed = 10.0;

    public AerotechPro165() {
        this.setOptions(Ascii.Option.KEEP_ALIVE);
    }

    @Override
    public synchronized void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(type, ident, parm1 == 0 ? (type == DriverConstants.ConnType.NET ? 8000 : 9600) : parm1, 0);
        this.setTimeout(timeout);
        this.setTerminator(Ascii.Terminator.LF);
    }

    public String getVersion() throws DriverException {
        return this.readAP("VERSION");
    }

    public String getError() throws DriverException {
        return "x:" + this.readAP("AXISFAULT X") + "\n y:" + this.readAP("AXISFAULT Y") + "\n z:" + this.readAP("AXISFAULT Z");
    }

    public void reset() throws DriverException {
        this.writeAP("ACKNOWLEDGEALL");
    }

    public void fullreset() throws DriverException {
        this.write("reset");
    }

    public void abort() throws DriverException {
        this.writeAP("ABORT X Y Z");
    }

    public double getPosX() throws DriverException {
        return this.readDoubleAP("PFBK X");
    }

    @Deprecated
    public double getPos_x() throws DriverException {
        return this.getPosX();
    }

    public double getPosY() throws DriverException {
        return this.readDoubleAP("PFBK Y");
    }

    @Deprecated
    public double getPos_y() throws DriverException {
        return this.getPosY();
    }

    public double getPosZ() throws DriverException {
        return this.readDoubleAP("PFBK Z");
    }

    @Deprecated
    public double getPos_z() throws DriverException {
        return this.getPosZ();
    }

    public double[] getPosXYZ() throws DriverException {
        double[] p = new double[]{Double.NaN, Double.NaN, Double.NaN};
        p[0] = this.getPosX();
        p[1] = this.getPosY();
        p[2] = this.getPosZ();
        return p;
    }

    @Deprecated
    public double[] getPos_xyz() throws DriverException {
        return this.getPosXYZ();
    }

    public void enableAxis(char axis) throws DriverException {
        this.writeAP("ENABLE " + axis);
    }

    public void disableAxis(char axis) throws DriverException {
        this.writeAP("DISABLE " + axis);
    }

    public void goHome() throws DriverException {
        this.writeAP("HOME X Y Z");
    }

    public synchronized void setupHome(int mode) throws DriverException {
        this.writeAP("setparm x, hometype, " + mode);
        this.writeAP("setparm y, hometype, " + mode);
        this.writeAP("setparm z, hometype, " + mode);
        this.writeAP("setparm z, homesetup, 0x00000001");
        this.writeAP("commitparameters");
        this.fullreset();
    }

    public void setSpeed(double speed) throws DriverException {
        this.speed = speed;
    }

    public void rampRate(double rate) throws DriverException {
        this.writeAP("RAMP RATE " + rate);
    }

    public void rampMode(String mode) throws DriverException {
        this.writeAP("RAMP MODE " + mode);
    }

    public void softLowLim(String axis, int param) throws DriverException {
        this.writeAP(axis + ", SoftwareLimitLow, " + param);
    }

    public void softHighLim(String axis, int param) throws DriverException {
        this.writeAP(axis + ", SoftwareLimitHigh, " + param);
    }

    public void moveAbsX(double dx) throws DriverException {
        this.writeAP("MOVEABS X " + dx + " F " + this.speed);
    }

    @Deprecated
    public void moveAbs_x(double dx) throws DriverException {
        this.moveAbsX(dx);
    }

    public void moveAbsY(double dy) throws DriverException {
        this.writeAP("MOVEABS Y " + dy + " F " + this.speed);
    }

    @Deprecated
    public void moveAbs_y(double dy) throws DriverException {
        this.moveAbsY(dy);
    }

    public void moveAbsZ(double dz) throws DriverException {
        this.writeAP("MOVEABS Z " + dz + " F " + this.speed);
    }

    @Deprecated
    public void moveAbs_z(double dz) throws DriverException {
        this.moveAbsZ(dz);
    }

    public void moveAbs(double dx, double dy) throws DriverException {
        this.writeAP("MOVEABS X " + dx + " Y " + dy + " F " + this.speed);
    }

    public void moveAbs(double dx, double dy, double dz) throws DriverException {
        this.writeAP("MOVEABS X " + dx + " Y " + dy + " Z " + dz);
    }

    public void moveIncX(double dx) throws DriverException {
        this.writeAP("MOVEINC X " + dx + " F " + this.speed);
    }

    @Deprecated
    public void moveInc_x(double dx) throws DriverException {
        this.moveIncX(dx);
    }

    public void moveIncY(double dy) throws DriverException {
        this.writeAP("MOVEINC Y " + dy + " F " + this.speed);
    }

    @Deprecated
    public void moveInc_y(double dy) throws DriverException {
        this.moveIncY(dy);
    }

    public void moveIncZ(double dz) throws DriverException {
        this.writeAP("MOVEINC Z " + dz + " F " + this.speed);
    }

    @Deprecated
    public void moveInc_z(double dz) throws DriverException {
        this.moveIncZ(dz);
    }

    public void moveInc(double dx, double dy) throws DriverException {
        this.writeAP("MOVEINC X " + dx + " Y " + dy + " F " + this.speed);
    }

    public void moveInc(double dx, double dy, double dz) throws DriverException {
        this.writeAP("MOVEINC X " + dx + " Y " + dy + " Z " + dz + " F " + this.speed);
    }

    public void writeAP(String command) throws DriverException {
        this.checkResponse(this.read(command));
    }

    public String readAP(String command) throws DriverException {
        String resp = this.read(command);
        this.checkResponse(resp);
        return resp.substring(1);
    }

    public double readDoubleAP(String command) throws DriverException {
        String resp = this.readAP(command);
        try {
            return Double.parseDouble(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid floating point response: " + resp);
        }
    }

    private void checkResponse(String resp) throws DriverException {
        Object errMsg;
        if (resp.length() > 0) {
            char respChar = resp.charAt(0);
            if (respChar == '%') {
                return;
            }
            errMsg = respChar == '!' ? "Invalid command" : (respChar == '#' ? "Command fault" : (respChar == '$' ? "Command timeout" : "Invalid response: " + resp));
        } else {
            errMsg = "Empty response";
        }
        throw new DriverException((String)errMsg);
    }

    @Deprecated
    public synchronized void writeAerotechPro165(String command) throws DriverException {
        this.write(command);
    }

    @Deprecated
    public synchronized String readAerotechPro165() throws DriverException {
        return this.read();
    }

    @Deprecated
    public synchronized String readAerotechPro165(String command) throws DriverException {
        return this.read(command);
    }
}

