package org.lsst.ccs.drivers.aerotech;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Program to test the AerotechPro165 device driver
 *
 * @author Homer
 */
public class TestAerotechPro165 extends TestAscii {

    final protected AerotechPro165 mydev;

    public TestAerotechPro165() {
        super(new AerotechPro165());
        mydev = (AerotechPro165)dev;
    }

    @Command(name = "version", description = "get the version")
    public String version() throws DriverException {
        return mydev.getVersion();
    }

    @Command(name = "enable", description = "enable")
    public void enable() throws DriverException {
        mydev.enableAxis('X');
        mydev.enableAxis('Y');
        mydev.enableAxis('Z');
    }

    @Command(name = "getpos", description = "get position")
    public String getpos() throws DriverException {
        return "x: " + mydev.getPosX() + ", y: " + mydev.getPosY() + ", z: " + mydev.getPosZ();
    }

    @Command(name = "moveinc", description = "step position by dx, dy, dz")
    public void moveinc(
            @Argument(name = "dx", description = "X step") double dx,
            @Argument(name = "dy", description = "Y step") double dy,
            @Argument(name = "dz", description = "Z step") double dz
            ) throws DriverException {
        mydev.moveInc(dx,dy,dz);
    }

    @Command(name = "moveabs", description = "move to position x, y, z")
    public void moveabs(
            @Argument(name = "dx", description = "X step") double dx,
            @Argument(name = "dy", description = "Y step") double dy,
            @Argument(name = "dz", description = "Z step") double dz
            ) throws DriverException {
        mydev.moveAbs(dx,dy,dz);
    }

    @Command(name = "getpos_xyz", description = "get position x, y, z")
    public double[] getposXYZ() throws DriverException {
        return mydev.getPosXYZ();
    }

    @Command(name = "readap", description = "execute comand and read response")
    public String readAP(@Argument(description="Command to execute") String command) throws DriverException {
        return mydev.readAP(command);
    }

    @Command(name = "writeap", description = "execute command")
    public void writeAP(@Argument(description="Command to execute") String command) throws DriverException {
        mydev.writeAP(command);
    }

}
