package org.lsst.ccs.drivers.aerotech;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;


/**
 ***************************************************************************
 **
 ** Program to test the AerotechPro165 device driver * * @author Homer *
 **************************************************************************
 */
public class TestAerotechPro165 {

    protected AerotechPro165 mydev;


    @Command(name = "open", description = "Open a network connection to the Aerotech using default addr")
    public void open() throws DriverException {
        mydev = new AerotechPro165();
        mydev.opennet("130.199.47.180",8000);
    }

    @Command(name = "openserial", description = "Open a serial connection to the Aerotech")
    public void openserial(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
    ) throws DriverException {

        mydev = new AerotechPro165();
        mydev.openserial(MyDevId, 9600);
    }

    @Command(name = "opennet", description = "Open a network connection to the Aerotech")
    public void opennet(
            @Argument(name = "netaddr", description = "The netaddr of the device to open - 130.199.47.172") String MyNetAddr,
            @Argument(name = "port", description = "port - 23") int port
    ) throws DriverException {

        mydev = new AerotechPro165();
        mydev.opennet(MyNetAddr, port);
        mydev.setTimeout(60);
    }

    @Command(name = "close", description = "Close the device")
    public void close() throws Exception {
        mydev.close();
    }

    @Command(name = "version", description = "get the version")
    public String version() throws Exception {
        return(mydev.getVersion());
    }

    @Command(name = "enable", description = "enable")
    public void enable() throws Exception {
        mydev.enableAxis('X');
        mydev.enableAxis('Y');
        mydev.enableAxis('Z');
    }

    @Command(name = "getpos", description = "get position")
    public String getpos() throws Exception {
        return("x: " + mydev.getPos_x() + "y: " + mydev.getPos_y() + "z: " + mydev.getPos_z());
    }

    @Command(name = "moveinc", description = "step position by dx, dy, dz")
    public void moveinc(
            @Argument(name = "dx", description = "X step") double dx,
            @Argument(name = "dy", description = "Y step") double dy,
            @Argument(name = "dz", description = "Z step") double dz
            ) throws Exception {
        mydev.moveInc(dx,dy,dz);
    }

    @Command(name = "moveabs", description = "move to position x, y, z")
    public void moveabs(
            @Argument(name = "dx", description = "X step") double dx,
            @Argument(name = "dy", description = "Y step") double dy,
            @Argument(name = "dz", description = "Z step") double dz
            ) throws Exception {
        mydev.moveAbs(dx,dy,dz);
    }

    @Command(name = "getpos_xyz", description = "get position x, y, z")
    public double[] getpos_xyz() throws Exception {
        return mydev.getPos_xyz();
    }

}
