/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.lsst.ccs.drivers.ads.wrapper.ADSLibrary;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationAttrib;
import org.lsst.ccs.drivers.ads.wrapper.AdsVersion;
import org.lsst.ccs.drivers.ads.wrapper.AmsAddr;
import org.lsst.ccs.drivers.ads.wrapper.AmsNetId;
import org.lsst.ccs.drivers.ads.wrapper.LogCallback;
import org.lsst.ccs.drivers.ads.wrapper.PAdsNotificationFuncEx;

public class MockADSLibrary
implements ADSLibrary {
    public static final String LOCAL_AMS_NETID = "1.2.3.4.1.1";
    public static final String REMOTE_AMS_NETID = "5.6.7.8.1.1";
    public static final String REMOTE_IP_ADDRESS = "10.9.8.7";
    public static final String VAR_NAME = "foo";
    public static final boolean VAR_CHANGES_ONLY = true;
    public static final int VAR_MAX_DELAY = 20;
    public static final int VAR_CYCLE_TIME = 256;
    private static final AmsNetId LOCAL_NETID_STRUCT = new AmsNetId(1, 2, 3, 4, 1, 1);
    private static final long LOCAL_PORT_NUMBER = 1L;
    private static final AmsNetId REMOTE_NETID_STRUCT = new AmsNetId(5, 6, 7, 8, 1, 1);
    private final AmsAddr REMOTE_AMSADDR_STRUCT = new AmsAddr(REMOTE_NETID_STRUCT, 851);
    public static final int VAR_LENGTH = 4;
    public static final int VAR_VALUE = 123;
    private static final String FULL_VAR_NAME = "MAIN.foo";
    private static final int VAR_TRANSFER_MODE = 4;
    private static final AdsNotificationAttrib VAR_NOTIFICATION_ATTRIB = new AdsNotificationAttrib(4, 4, 200000, 2560000);
    private int currentVariableHandle = 0;
    private int currentNotificationHandle = 0;
    private PAdsNotificationFuncEx currentCallback = null;
    private int error = 0;
    private LogCallback log;

    public void setError(int code) {
        this.error = code;
    }

    public PAdsNotificationFuncEx getCurrentCallback() {
        return this.currentCallback;
    }

    private void checkRoute(AmsNetId ams, String ip) {
        Assertions.assertAll((String)"Remote address check.", (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)REMOTE_NETID_STRUCT, (Object)ams, (String)"Bad AMS route."), () -> Assertions.assertEquals((Object)REMOTE_IP_ADDRESS, (Object)ip, (String)"Bad IP address.")});
    }

    public void checkAddress(long localPort, AmsAddr remoteAms) {
        Assertions.assertAll((String)"Address check", (Executable[])new Executable[]{() -> Assertions.assertEquals((long)1L, (long)localPort, (String)"Bad local port number."), () -> Assertions.assertEquals((Object)this.REMOTE_AMSADDR_STRUCT, (Object)remoteAms, (String)"Bad remote AMS address.")});
    }

    public void setExternalLogger(LogCallback logger) {
        this.log = logger;
    }

    public long AdsAddRoute(AmsNetId ams, String ip) {
        this.log.log(1, "Setting route to IP = " + ip);
        if (this.error != 0) {
            return this.error;
        }
        this.checkRoute(ams, ip);
        return 0L;
    }

    public void AdsDelRoute(AmsNetId ams) {
        this.checkRoute(ams, REMOTE_IP_ADDRESS);
    }

    public long AdsPortCloseEx(long port) {
        Assertions.assertEquals((long)1L, (long)port, (String)"Bad local port number.");
        return 0L;
    }

    public long AdsPortOpenEx() {
        if (this.error != 0) {
            return 0L;
        }
        return 1L;
    }

    public long AdsGetLocalAddressEx(long port, AmsAddr pAddr) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void AdsSetLocalAddress(AmsNetId ams) {
        Assertions.assertEquals((Object)LOCAL_NETID_STRUCT, (Object)ams, (String)"Bad local AMS address.");
    }

    public long AdsSyncReadReqEx2(long port, AmsAddr pAddr, int indexGroup, int indexOffset, int readLength, byte[] readData, int[] bytesRead) {
        if (this.error != 0) {
            return this.error;
        }
        Assertions.assertAll((String)"Argument checks for AdsSyncReadReqEx2().", (Executable[])new Executable[]{() -> this.checkAddress(port, pAddr), () -> Assertions.assertEquals((int)61445, (int)indexGroup, (String)"Bad index group."), () -> Assertions.assertEquals((int)this.currentVariableHandle, (int)indexOffset, (String)"Wrong variable handle."), () -> Assertions.assertEquals((int)4, (int)readLength, (String)"Wrong variable size."), () -> {
            Assertions.assertNotNull((Object)readData, (String)"Read buffer is null.");
            Assertions.assertTrue((readLength <= readData.length ? 1 : 0) != 0, (String)"Read buffer is too small.");
        }});
        ByteBuffer rbuf = ByteBuffer.wrap(readData);
        rbuf.order(ByteOrder.LITTLE_ENDIAN);
        rbuf.putInt(123);
        return 0L;
    }

    public long AdsSyncReadDeviceInfoReqEx(long port, AmsAddr pAddr, String devName, AdsVersion version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long AdsSyncReadStateReqEx(long port, AmsAddr pAddr, short[] adsState, short[] devState) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long AdsSyncReadWriteReqEx2(long port, AmsAddr pAddr, int indexGroup, int indexOffset, int readLength, byte[] readData, int writeLength, byte[] writeData, int[] bytesRead) {
        if (this.error != 0) {
            return this.error;
        }
        Assertions.assertAll((String)"Argument checks for AdsSyncReadWriteReqEx2().", (Executable[])new Executable[]{() -> this.checkAddress(port, pAddr), () -> {
            Assertions.assertNotNull((Object)readData, (String)"readData is null.");
            int minSize = indexGroup == 61443 ? 4 : 12;
            Assertions.assertTrue((readLength >= minSize && readLength <= readData.length ? 1 : 0) != 0, (String)"readLength too small or too large.");
        }, () -> {
            Assertions.assertNotNull((Object)writeData, (String)"writeData is null.");
            Assertions.assertTrue((writeLength > 0 && writeLength <= writeData.length ? 1 : 0) != 0, (String)"writeLength <= 0 or too large.");
            String vname = new String(writeData, 0, writeLength, StandardCharsets.US_ASCII);
            Assertions.assertEquals((Object)FULL_VAR_NAME, (Object)vname, (String)"Bad variable name.");
        }});
        ByteBuffer rbuf = ByteBuffer.wrap(readData);
        rbuf.order(ByteOrder.LITTLE_ENDIAN);
        switch (indexGroup) {
            case 61443: {
                rbuf.putInt(++this.currentVariableHandle);
                break;
            }
            case 61447: {
                rbuf.putInt(16416);
                rbuf.putInt(0);
                rbuf.putInt(4);
                break;
            }
            default: {
                Assertions.fail((String)"Invalid group index for mock AdsSyncReadWriteReqEx2().");
            }
        }
        return 0L;
    }

    public long AdsSyncWriteReqEx(long port, AmsAddr pAddr, int indexGroup, int indexOffset, int bufferLength, byte[] buffer) {
        if (this.error != 0) {
            return this.error;
        }
        Assertions.assertAll((String)"Argument checks for AdsSyncWriteReqEx().", (Executable[])new Executable[]{() -> this.checkAddress(port, pAddr), () -> {
            Assertions.assertNotNull((Object)buffer, (String)"Data buffer is null.");
            Assertions.assertTrue((bufferLength >= 0 && bufferLength <= buffer.length ? 1 : 0) != 0, (String)"bufferLength arg is too small or too large.");
        }});
        ByteBuffer wbuf = ByteBuffer.wrap(buffer);
        wbuf.order(ByteOrder.LITTLE_ENDIAN);
        switch (indexGroup) {
            case 61445: {
                int handle = indexOffset;
                int val = wbuf.getInt();
                Assertions.assertEquals((int)123, (int)val, (String)"Writing wrong value to variable.");
                if (handle == this.currentVariableHandle) {
                    return 0L;
                }
                return 1821L;
            }
            case 61446: {
                int handle = wbuf.getInt();
                if (handle == this.currentVariableHandle) {
                    ++this.currentVariableHandle;
                    return 0L;
                }
                return 1821L;
            }
        }
        Assertions.fail((String)"Invalid group index for mock AdsSyncWriteReqEx().");
        return 0L;
    }

    public long AdsSyncWriteControlReqEx(long port, AmsAddr pAddr, short adsState, short devState, int bufferLength, byte[] buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long AdsSyncAddDeviceNotificationReqEx(long port, AmsAddr pAddr, int indexGroup, int indexOffset, AdsNotificationAttrib pAttrib, PAdsNotificationFuncEx pFunc, int hUser, int[] pNotification) {
        if (this.error != 0) {
            return this.error;
        }
        Assertions.assertAll((String)"Argument checks for AdsSyncAddDeviceNotificationReqEx().", (Executable[])new Executable[]{() -> this.checkAddress(port, pAddr), () -> Assertions.assertEquals((int)61445, (int)indexGroup, (String)"Unsupported index group."), () -> Assertions.assertNotNull((Object)pAttrib, (String)"Null notification attributes."), () -> {
            Assertions.assertNotNull((Object)pNotification, (String)"Notification output array is null.");
            Assertions.assertTrue((pNotification.length > 0 ? 1 : 0) != 0, (String)"Zero-sized notification handle output array.");
        }, () -> Assertions.assertNotNull((Object)pFunc), () -> Assertions.assertEquals((Object)VAR_NOTIFICATION_ATTRIB, (Object)pAttrib)});
        if (indexOffset == this.currentVariableHandle) {
            pNotification[0] = ++this.currentNotificationHandle;
            this.currentCallback = pFunc;
            return 0L;
        }
        return 1821L;
    }

    public long AdsSyncDelDeviceNotificationReqEx(long port, AmsAddr pAddr, int hNotification) {
        if (this.error != 0) {
            return this.error;
        }
        Assertions.assertAll((String)"Argument checks for AdsSyncDelDeviceNotificationReqEx().", (Executable[])new Executable[]{() -> this.checkAddress(port, pAddr), () -> Assertions.assertTrue((hNotification > 0 ? 1 : 0) != 0, (String)"Notification handle is not positive.")});
        if (hNotification == this.currentNotificationHandle) {
            ++this.currentNotificationHandle;
            this.currentCallback = null;
            return 0L;
        }
        return 1812L;
    }

    public long AdsSyncGetTimeoutEx(long port, int[] timeout) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long AdsSyncSetTimeoutEx(long port, int timeout) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

