/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.lsst.ccs.drivers.ads.VariableHandle;

public class VariableHandleTest {
    private static final int TEST_HANDLE = 1234;
    private static final String TEST_VARNAME = "foo";
    private static final int TEST_SIZE = 321;
    private static VariableHandle varHandle;

    @BeforeAll
    private static void setup() {
        varHandle = new VariableHandle(1234, TEST_VARNAME, 321);
    }

    @Test
    @DisplayName(value="Getting the variable handle value.")
    public void testGetHandleValue() {
        int expResult = 1234;
        int result = varHandle.getHandleValue();
        Assertions.assertEquals((int)expResult, (int)result, (String)"Wrong handle value.");
    }

    @Test
    @DisplayName(value="Getting the variable name.")
    public void testGetName() {
        String expResult = TEST_VARNAME;
        String result = varHandle.getName();
        Assertions.assertEquals((Object)expResult, (Object)result, (String)"Wrong variable name.");
    }

    @Test
    @DisplayName(value="Getting the variable size.")
    public void testGetVarSize() {
        int expResult = 321;
        int result = varHandle.getVarSize();
        Assertions.assertEquals((int)expResult, (int)result);
    }

    @Test
    @DisplayName(value="Creating a ByteBuffer for I/O operations.")
    public void testCreateBuffer() {
        ByteBuffer buf = varHandle.createBuffer();
        Assertions.assertNotNull((Object)buf);
        Assertions.assertAll((String)"Check of ByteBuffer properties.", (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)buf.order(), (String)"Wrong byte order."), () -> Assertions.assertEquals((int)321, (int)buf.capacity(), (String)"Wrong capacity."), () -> Assertions.assertEquals((int)321, (int)buf.limit(), (String)"Wrong limit."), () -> Assertions.assertEquals((int)0, (int)buf.position(), (String)"Wrong position.")});
    }
}

