/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

/**
 * The structure contains the version number, revision number and build number.
 */
public class AdsVersion extends Structure implements Structure.ByReference {
    /** Version number. */
    public byte version;
    
    /** Revision number. */
    public byte revision;
    
    /** Build number */
    public short build;

    public AdsVersion(byte version, byte revision, short build, int alignType) {
        super(ALIGN_NONE); // pack(1) pragma was used in AdsDef.h
        this.version = version;
        this.revision = revision;
        this.build = build;
    }

    /** For use by JNA. */
    public AdsVersion() {
        super(ALIGN_NONE);
        this.version = (byte)0;
        this.revision = (byte)0;
        this.build = (short)0;
    }
    
    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("version", "revision", "build");
    }
}
