package org.lsst.ccs.drivers.ads;

import java.nio.ByteBuffer;

/**
 * Contains information from a notification message received from the
 * remote ADS server. Instances are created by the ADS driver.
 * @author tether
 */
public class Notification {
    
    private final int notificationHandle;
    
    private final VariableHandle varHandle;
    
    private final ByteBuffer data;

    Notification(final int notificationHandle, final VariableHandle varHandle, final ByteBuffer data) {
        this.notificationHandle = notificationHandle;
        this.varHandle = varHandle;
        this.data = data;
    }

    /**
     * Gets the 32-bit handle assigned by the remote ADS server when the
     * request for notifications was made.
     * @return The handle.
     */
    public int getNotificationHandle() {
        return notificationHandle;
    }

    /**
     * Gets the VariableHandle instance pass to
     * {@link ADSDriver#requestNotifications(org.lsst.ccs.drivers.ads.VariableHandle, java.time.Duration, java.time.Duration, boolean)}.
     * @return The VariableHandle.
     */
    public VariableHandle getVariableHandle() {
        return varHandle;
    }

    /**
     * Gets a read-only ByteBuffer containing the variable value sent by the
     * remote server. The buffer has the correct byte order, has position=0
     * with the capacity and limit both set to the variable size.
     * @return The buffer.
     */
    public ByteBuffer getData() {
        return data;
    }
}
