/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationHeader;
import org.lsst.ccs.drivers.ads.wrapper.AmsAddr;

public class Example2 {
    private static final Logger LOG = Logger.getLogger(Example2.class.getPackage().getName());
    static final SimpleCb CBLIB = (SimpleCb)Native.loadLibrary((String)"simplecb", SimpleCb.class);

    private Example2() {
    }

    private static void fn1() {
        LOG.info("Called fn1().");
    }

    private static void fn2(int arg) {
        LOG.info("Called fn2() with " + arg);
    }

    private static void fn3(AmsAddr addr, AdsNotificationHeader header, int data) {
        LOG.info(String.format("Called fn3() with address = %s.", new Object[]{addr}));
        LOG.info(String.format("    Time, handle, bytes = %d  %d  %d.%n", header.nTimeStamp, header.hNotification, header.cbSampleSize));
        LOG.info(String.format("    Extra data = %d.%n", data));
    }

    public static void main(String[] args) {
        CBLIB.callVoid(Example2::fn1);
        CBLIB.callInt(Example2::fn2);
        CBLIB.callStruct(Example2::fn3);
    }

    public static class ArgStruct
    extends Structure {
        public int num = 0;

        protected List<String> getFieldOrder() {
            return Arrays.asList("num");
        }
    }

    private static interface SimpleCb
    extends Library {
        public void callVoid(CbVoid var1);

        public void callInt(CbInt var1);

        public void callStruct(CbStruct var1);
    }

    private static interface CbStruct
    extends Callback {
        public void apply(AmsAddr var1, AdsNotificationHeader var2, int var3);
    }

    private static interface CbInt
    extends Callback {
        public void apply(int var1);
    }

    private static interface CbVoid
    extends Callback {
        public void apply();
    }
}

