/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.lsst.ccs.drivers.ads.wrapper.ADSLibrary;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationAttrib;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationHeader;
import org.lsst.ccs.drivers.ads.wrapper.AmsAddr;
import org.lsst.ccs.drivers.ads.wrapper.AmsNetId;
import org.lsst.ccs.drivers.ads.wrapper.PAdsNotificationFuncEx;
import org.lsst.ccs.utilities.logging.Logger;

public class Example1 {
    private static final Logger LOG = Logger.getLogger((String)Example1.class.getPackage().getName());
    private static final ADSLibrary ADS = (ADSLibrary)Native.loadLibrary((String)"AdsJNA", ADSLibrary.class);

    private Example1() {
    }

    public static void main(String[] args) {
        AmsNetId remoteNetId = new AmsNetId(5, 56, 86, 54, 1, 1);
        String remoteIpV4 = "192.168.10.40";
        AmsNetId localId = new AmsNetId(134, 79, 86, 183, 1, 1);
        int remoteADSport = 851;
        LOG.log(Level.INFO, "The local AMS NetId will be set to {0}.", (Object)localId);
        LOG.log(Level.INFO, "The remote AMS NetId is {0}.", (Object)remoteNetId);
        LOG.log(Level.INFO, "That remote NetId will be routed to IP address {0}.", (Object)"192.168.10.40");
        LOG.log(Level.INFO, "The remote ADS port is {0}.", (Object)851);
        ADS.AdsSetLocalAddress(localId);
        if (0L != ADS.AdsAddRoute(remoteNetId, "192.168.10.40")) {
            LOG.severe((Object)"Adding the new ADS route failed, did you specify a valid IP address?");
            return;
        }
        LOG.info((Object)"The new ADS route has been added.");
        long port = ADS.AdsPortOpenEx();
        if (port == 0L) {
            LOG.severe((Object)"Failed to create a new local ADS port.");
            return;
        }
        LOG.info((Object)"The local ADS port has been created.");
        AmsAddr remote = new AmsAddr(remoteNetId, 851);
        Example1.readState(port, remote);
        Example1.getSymbolInfo(port, remote);
        Example1.writeByAddress(port, remote);
        Example1.readByAddress(port, remote);
        Example1.readByHandle(port, remote);
        try {
            Example1.notifyByAddress(port, remote);
            Example1.notifyByName(port, remote);
        }
        catch (IOException exc) {
            LOG.log(Level.SEVERE, "I/O problem!", (Throwable)exc);
        }
    }

    private static void readState(long port, AmsAddr server) {
        LOG.info((Object)"---------- Read state example ----------");
        short[] adsState = new short[1];
        short[] devState = new short[1];
        long status = ADS.AdsSyncReadStateReqEx(port, server, adsState, devState);
        if (status != 0L) {
            LOG.severe((Object)("Reading the state failed with code " + status));
            return;
        }
        LOG.log(Level.INFO, "The ADS state is {0}, the device state is {1}.", new Object[]{adsState[0], devState[0]});
    }

    private static void getSymbolInfo(long port, AmsAddr server) {
        LOG.info((Object)"---------- Symbol info test ----------");
        ByteBuffer rbuf = Example1.makeByteBuffer(12);
        ByteBuffer wbuf = Example1.makeByteBuffer("MAIN.byByte");
        long status = ADS.AdsSyncReadWriteReqEx2(port, server, 61447, 0, rbuf.capacity(), rbuf.array(), wbuf.capacity(), wbuf.array(), null);
        if (status != 0L) {
            LOG.log(Level.SEVERE, "Reading of symbol info failed with code {0}.", (Object)status);
        }
        int igroup = rbuf.getInt();
        int ioff = rbuf.getInt();
        int size = rbuf.getInt();
        LOG.info((Object)String.format("Symbol MAIN.byByte: group 0x%04x, offset %d, size %d.%n", igroup, ioff, size));
    }

    private static void readByAddress(long port, AmsAddr server) {
        LOG.info((Object)"---------- Read by address ----------");
        ByteBuffer rbuf = Example1.makeByteBuffer(1);
        int[] bytesRead = new int[]{0};
        for (int i = 0; i < 8; ++i) {
            long status = ADS.AdsSyncReadReqEx2(port, server, 16416, i, rbuf.capacity(), rbuf.array(), bytesRead);
            if (status != 0L) {
                LOG.severe((Object)("The ADS read failed with code " + status));
                continue;
            }
            LOG.log(Level.INFO, "ADS read %d bytes at address {0}, value {1}.", new Object[]{bytesRead[0], i, rbuf.get(0)});
        }
    }

    private static void readByHandle(long port, AmsAddr server) {
        LOG.info((Object)"---------- Read by handle ----------");
        String varName = "MAIN.byByte[4]";
        LOG.info((Object)"The name of the variable to be read is MAIN.byByte[4]");
        int[] bytesRead = new int[]{0};
        ByteBuffer rbuf = Example1.makeByteBuffer(1);
        int handle = Example1.getNameHandle(port, server, "MAIN.byByte[4]");
        for (int i = 0; i < 8; ++i) {
            long status = ADS.AdsSyncReadReqEx2(port, server, 61445, handle, rbuf.capacity(), rbuf.array(), bytesRead);
            if (status != 0L) {
                LOG.severe((Object)("The ADS read failed with code " + status));
                continue;
            }
            LOG.log(Level.INFO, "ADS read {0} bytes, value = {1}.", new Object[]{bytesRead[0], rbuf.get(0)});
        }
        Example1.releaseNameHandle(port, server, handle);
    }

    private static int getNameHandle(long port, AmsAddr server, String varName) {
        ByteBuffer rbuf = Example1.makeByteBuffer(4);
        ByteBuffer wbuf = Example1.makeByteBuffer(varName);
        long handleStatus = ADS.AdsSyncReadWriteReqEx2(port, server, 61443, 0, rbuf.capacity(), rbuf.array(), wbuf.capacity(), wbuf.array(), null);
        if (handleStatus != 0L) {
            LOG.severe((Object)("Creating the name handle failed with code " + handleStatus));
        }
        return rbuf.getInt();
    }

    private static void releaseNameHandle(long port, AmsAddr server, int handle) {
        ByteBuffer wbuf = Example1.makeByteBuffer(4);
        wbuf.putInt(handle);
        long status = ADS.AdsSyncWriteReqEx(port, server, 61446, 0, wbuf.capacity(), wbuf.array());
        if (status != 0L) {
            LOG.severe((Object)("Releasing the name handle failed with code " + status));
        }
    }

    private static void writeByAddress(long port, AmsAddr server) {
        LOG.info((Object)"---------- Write by address ----------");
        LOG.info((Object)"Writing to address 3 (MAIN.byByte[3]).");
        ByteBuffer wbuf = Example1.makeByteBuffer(1);
        wbuf.put((byte)(System.currentTimeMillis() % 128L + 1L));
        long status = ADS.AdsSyncWriteReqEx(port, server, 16416, 3, wbuf.capacity(), wbuf.array());
        if (status != 0L) {
            LOG.severe((Object)("The ADS write failed with code " + status));
        } else {
            LOG.log(Level.INFO, "ADS wrote {0} to address 3.", (Object)wbuf.get(0));
        }
    }

    private static void notifyByAddress(long port, AmsAddr server) throws IOException {
        LOG.info((Object)"---------- Notification by address ----------");
        LOG.info((Object)"Will ask for a notice when MAIN.byBytes[4] changes.");
        LOG.info((Object)"The remote PLC will check for changes every four seconds.");
        AdsNotificationAttrib attrib = new AdsNotificationAttrib(1, 4, 0, 40000000);
        int[] hNotify = new int[]{0};
        boolean hUser = false;
        PAdsNotificationFuncEx callback = Example1::notificationHandler;
        long addStatus = ADS.AdsSyncAddDeviceNotificationReqEx(port, server, 16416, 4, attrib, callback, 0, hNotify);
        if (addStatus != 0L) {
            LOG.log(Level.SEVERE, "The request for notification failed with code {0}.", (Object)addStatus);
            return;
        }
        LOG.info((Object)"Type any chanracter to stop notifications.");
        System.in.read();
        long delStatus = ADS.AdsSyncDelDeviceNotificationReqEx(port, server, hNotify[0]);
        if (delStatus != 0L) {
            LOG.log(Level.SEVERE, "Deleting the device notification failed with code {0}.", (Object)delStatus);
        }
    }

    private static void notifyByName(long port, AmsAddr server) throws IOException {
        LOG.info((Object)"---------- Notification by name ----------");
        LOG.info((Object)"Will ask for a notice when MAIN.byBytes[4] changes.");
        LOG.info((Object)"The remote PLC will check for changes every four seconds.");
        AdsNotificationAttrib attrib = new AdsNotificationAttrib(1, 4, 0, 40000000);
        int[] hNotify = new int[]{0};
        boolean hUser = false;
        PAdsNotificationFuncEx callback = Example1::notificationHandler;
        int handle = Example1.getNameHandle(port, server, "MAIN.byByte[4]");
        long addStatus = ADS.AdsSyncAddDeviceNotificationReqEx(port, server, 61445, handle, attrib, callback, 0, hNotify);
        if (addStatus != 0L) {
            LOG.log(Level.SEVERE, "The request for notification failed with code {0}.", (Object)addStatus);
            return;
        }
        LOG.info((Object)"Type any chanracter to stop notifications.");
        System.in.read();
        long delStatus = ADS.AdsSyncDelDeviceNotificationReqEx(port, server, hNotify[0]);
        if (delStatus != 0L) {
            LOG.log(Level.SEVERE, "Deleting the device notification failed with code {0}.", (Object)delStatus);
        }
    }

    private static void notificationHandler(AmsAddr addr, AdsNotificationHeader header, int hUser) {
        Pointer hdrptr = header.getPointer();
        LOG.log(Level.INFO, "Notice with handle {0} from {1} at time {2} with callback data {3} and {4} data bytes. Data =", new Object[]{header.hNotification, addr, header.nTimeStamp, hUser, header.cbSampleSize});
        byte[] data = hdrptr.getByteArray((long)header.headerSize(), header.cbSampleSize);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            buf.append(String.format(" %d", data[i]));
        }
        LOG.info((Object)buf.toString());
    }

    private static ByteBuffer makeByteBuffer(int size) {
        return Example1.makeByteBuffer(new byte[size]);
    }

    private static ByteBuffer makeByteBuffer(byte[] array) {
        return ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static ByteBuffer makeByteBuffer(String name) {
        return Example1.makeByteBuffer(name.getBytes(StandardCharsets.US_ASCII));
    }
}

