package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;


/**
 * This structure is one of the arguments passed to
 * a notification callback function.
 */
public class AdsNotificationHeader extends Structure implements Structure.ByReference {
    /** Contains a 64-bit value representing the number of 100-nanosecond intervals since January 1, 1601 (UTC). */
    public long nTimeStamp;
    
    /** Handle for the notification. Is specified when the notification is defined. */
    public int hNotification;
    
    /** Number of bytes transferred. */
    public int cbSampleSize;

    public AdsNotificationHeader(long nTimeStamp, int hNotification, int cbSampleSize) {
        super(ALIGN_NONE);  // pack(1) pragma was used in AdsDef.h
        this.nTimeStamp = nTimeStamp;
        this.hNotification = hNotification;
        this.cbSampleSize = cbSampleSize;
    }
    
    public static int headerSize() {return Long.BYTES + 2*Integer.BYTES;}

    /** For use by JNA. */
    public AdsNotificationHeader() {
        super(ALIGN_NONE);
        this.nTimeStamp = 0;
        this.hNotification = 0;
        this.cbSampleSize = 0;
    }
    
    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("nTimeStamp", "hNotification", "cbSampleSize");
    }
}
