/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.lsst.ccs.drivers.ads.ADSDriver;
import org.lsst.ccs.drivers.ads.MockADSLibrary;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.lsst.ccs.drivers.ads.wrapper.ADSLibrary;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationAttrib;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationHeader;
import org.lsst.ccs.drivers.ads.wrapper.AmsAddr;
import org.lsst.ccs.drivers.ads.wrapper.AmsNetId;
import org.lsst.ccs.drivers.ads.wrapper.PAdsNotificationFuncEx;
import org.lsst.ccs.drivers.commons.DriverException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ADSDriverTest {
    private static final String LOCAL_AMS_NETID = "1.2.3.4.1.1";
    private static final String REMOTE_AMS_NETID = "5.6.7.8.1.1";
    private static final String REMOTE_IP_ADDRESS = "10.9.8.7";
    private MockADSLibrary ADS;
    private ADSDriver driver;

    @BeforeEach
    private void setup() throws Exception {
        this.ADS = (MockADSLibrary)Mockito.spy((Object)new MockADSLibrary());
        this.driver = new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS);
        this.driver.open(REMOTE_AMS_NETID, REMOTE_IP_ADDRESS);
    }

    @Test
    public void testConstructorNetId() throws Exception {
        Assertions.assertThrows(DriverException.class, () -> new ADSDriver("bogus", (ADSLibrary)this.ADS), (String)"Accepted bad NetId.");
    }

    @Test
    public void testConstructorPort() throws Exception {
        this.ADS.setError(1);
        Assertions.assertThrows(ADSDriver.InitializationException.class, () -> new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS), (String)"Didn't check value retruned by AdsPortOpenEx().");
    }

    @Test
    public void testOpenNetId() throws Exception {
        this.driver.close();
        Assertions.assertThrows(DriverException.class, () -> this.driver.open("bogus", REMOTE_IP_ADDRESS), (String)"Accepted bad NetId.");
    }

    @Test
    public void testOpenNormal() throws Exception {
        Assertions.assertAll((String)"Normal open() call.", (Executable[])new Executable[]{() -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsPortOpenEx(), () -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsSetLocalAddress((AmsNetId)Mockito.any()), () -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsAddRoute((AmsNetId)Mockito.any(), (String)Mockito.any())});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ADS});
    }

    @Test
    public void testOpenNoRoute() {
        this.driver.close();
        this.ADS.setError(1);
        Assertions.assertThrows(ADSDriver.OpenException.class, () -> this.driver.open(REMOTE_AMS_NETID, REMOTE_IP_ADDRESS), (String)"Didn't check status code from AdsAddRoute().");
    }

    @Test
    public void testOpenLostContact() {
        this.driver.close();
        this.ADS.setError(6);
        Assertions.assertThrows(ADSDriver.LostContactException.class, () -> this.driver.open(REMOTE_AMS_NETID, REMOTE_IP_ADDRESS), (String)"Didn't check for loss of contact.");
    }

    @Test
    public void testDoubleOpen() throws Exception {
        this.driver.open(REMOTE_AMS_NETID, REMOTE_IP_ADDRESS);
        Assertions.assertAll((String)"Double open doesn't close first connection.", (Executable[])new Executable[]{() -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsPortOpenEx(), () -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsSetLocalAddress((AmsNetId)Mockito.any()), () -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)2))).AdsAddRoute((AmsNetId)Mockito.any(), (String)Mockito.any()), () -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsDelRoute((AmsNetId)Mockito.any())});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ADS});
    }

    @Test
    public void testDoubleClose() throws Exception {
        this.testOpenNormal();
        this.driver.close();
        this.driver.close();
        ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsDelRoute((AmsNetId)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ADS});
    }

    @Test
    public void testNotOpen() throws Exception {
        this.driver.close();
        VariableHandle dummyVar = (VariableHandle)Mockito.mock(VariableHandle.class);
        Assertions.assertAll((String)"Didn't check for driver not open.", (Executable[])new Executable[]{() -> {
            ADSDriver drv = new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS);
            Assertions.assertThrows(ADSDriver.NotOpenException.class, () -> drv.cancelNotifications(dummyVar), (String)"cancelNotifications");
        }, () -> {
            ADSDriver drv = new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS);
            Assertions.assertThrows(ADSDriver.NotOpenException.class, () -> drv.releaseVariableHandle(dummyVar), (String)"releaseVariableHandle");
        }, () -> {
            ADSDriver drv = new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS);
            Assertions.assertThrows(ADSDriver.NotOpenException.class, () -> drv.readVariable(dummyVar), (String)"readVariable");
        }, () -> {
            ADSDriver drv = new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS);
            Assertions.assertThrows(ADSDriver.NotOpenException.class, () -> drv.writeVariable(dummyVar, ByteBuffer.allocate(1)), (String)"writeVariable");
        }, () -> {
            ADSDriver drv = new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS);
            Assertions.assertThrows(ADSDriver.NotOpenException.class, () -> drv.getVariableHandle(""), (String)"getVariableHandle");
        }, () -> {
            ADSDriver drv = new ADSDriver(LOCAL_AMS_NETID, (ADSLibrary)this.ADS);
            Assertions.assertThrows(ADSDriver.NotOpenException.class, () -> drv.requestNotifications(dummyVar, Duration.ZERO, Duration.ZERO, true), (String)"requestNotifications");
        }});
    }

    @Test
    public void testGetVariableHandle() throws Exception {
        VariableHandle varHandle = this.driver.getVariableHandle("foo");
        Assertions.assertNotNull((Object)varHandle, (String)"Got a null VariableHandle.");
        Assertions.assertAll((String)"Variable handle contents.", (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"foo", (Object)varHandle.getName()), () -> Assertions.assertEquals((int)4, (int)varHandle.getVarSize()), () -> Assertions.assertTrue((varHandle.getHandleValue() > 0 ? 1 : 0) != 0, (String)"Non-positive variable handle.")});
        this.driver.releaseVariableHandle(varHandle);
        Assertions.assertThrows(ADSDriver.BadVarHandleException.class, () -> this.driver.releaseVariableHandle(varHandle));
    }

    @Test
    public void testDoubleVarHandle() throws Exception {
        VariableHandle vh2;
        VariableHandle vh1 = this.driver.getVariableHandle("foo");
        Assertions.assertTrue((vh1 == (vh2 = this.driver.getVariableHandle("foo")) ? 1 : 0) != 0, (String)"Different VariableHandles returned for the same variable.");
    }

    @Test
    public void testBogusVarHandle() throws Exception {
        this.testOpenNormal();
        VariableHandle invalid = (VariableHandle)Mockito.mock(VariableHandle.class);
        Assertions.assertAll((String)"Detecting invalid VariableHandles.", (Executable[])new Executable[]{() -> {
            ADSDriver.BadVarHandleException cfr_ignored_0 = (ADSDriver.BadVarHandleException)Assertions.assertThrows(ADSDriver.BadVarHandleException.class, () -> this.driver.releaseVariableHandle(invalid), (String)"release variable handle.");
        }, () -> {
            ADSDriver.BadVarHandleException cfr_ignored_0 = (ADSDriver.BadVarHandleException)Assertions.assertThrows(ADSDriver.BadVarHandleException.class, () -> this.driver.readVariable(invalid), (String)"read variable.");
        }, () -> {
            ADSDriver.BadVarHandleException cfr_ignored_0 = (ADSDriver.BadVarHandleException)Assertions.assertThrows(ADSDriver.BadVarHandleException.class, () -> this.driver.writeVariable(invalid, null), (String)"write variable.");
        }, () -> {
            ADSDriver.BadVarHandleException cfr_ignored_0 = (ADSDriver.BadVarHandleException)Assertions.assertThrows(ADSDriver.BadVarHandleException.class, () -> this.driver.requestNotifications(invalid, Duration.ZERO, Duration.ZERO, false), (String)"notification request.");
        }, () -> {
            ADSDriver.BadVarHandleException cfr_ignored_0 = (ADSDriver.BadVarHandleException)Assertions.assertThrows(ADSDriver.BadVarHandleException.class, () -> this.driver.cancelNotifications(invalid), (String)"notification cancellation.");
        }});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.ADS});
    }

    @Test
    public void testADSError0() throws Exception {
        this.ADS.setError(1802);
        Assertions.assertThrows(ADSDriver.LookupException.class, () -> this.driver.getVariableHandle("foo"), (String)"getVariableHandle() didn't check ADS status code.");
    }

    @Test
    public void testADSError1() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        this.ADS.setError(1802);
        Assertions.assertThrows(ADSDriver.BadVarHandleException.class, () -> this.driver.releaseVariableHandle(vh), (String)"releaseVariableHandle() didn't check ADS status code.");
    }

    @Test
    public void testADSError2() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        this.ADS.setError(1802);
        Assertions.assertThrows(ADSDriver.ReadWriteException.class, () -> this.driver.readVariable(vh), (String)"readVariable() didn't check ADS status code.");
    }

    @Test
    public void testADSError3() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        this.ADS.setError(1802);
        Assertions.assertThrows(ADSDriver.ReadWriteException.class, () -> this.driver.writeVariable(vh, ByteBuffer.allocate(4)), (String)"writeVariable() didn't check ADS status code.");
    }

    @Test
    public void testADSError4() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        this.ADS.setError(1802);
        Assertions.assertThrows(ADSDriver.NotificationException.class, () -> this.driver.requestNotifications(vh, Duration.ZERO, Duration.ZERO, false), (String)"requestNotifications() didn't check ADS status code.");
    }

    @Test
    public void testADSError5() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        this.driver.requestNotifications(vh, Duration.ofMillis(20L), Duration.ofMillis(256L), true);
        this.ADS.setError(1802);
        Assertions.assertThrows(ADSDriver.NotificationException.class, () -> this.driver.cancelNotifications(vh), (String)"cancelNotifications() didn't check ADS status code.");
    }

    @Test
    public void testRequestNotifications() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        int nh1 = this.driver.requestNotifications(vh, Duration.ofMillis(20L), Duration.ofMillis(256L), true);
        int nh2 = this.driver.requestNotifications(vh, Duration.ofMillis(20L), Duration.ofMillis(256L), true);
        Assertions.assertAll((String)"Duplicate notification requests.", (Executable[])new Executable[]{() -> Assertions.assertEquals((int)nh1, (int)nh2, (String)"Redundant notification requests returned different handles."), () -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsSyncAddDeviceNotificationReqEx(Mockito.anyLong(), (AmsAddr)Mockito.any(), Mockito.anyInt(), Mockito.anyInt(), (AdsNotificationAttrib)Mockito.any(), (PAdsNotificationFuncEx)Mockito.any(), Mockito.anyInt(), (int[])Mockito.any())});
    }

    @Test
    public void testNotificationQueueing() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        int nh = this.driver.requestNotifications(vh, Duration.ofMillis(20L), Duration.ofMillis(256L), true);
        PAdsNotificationFuncEx callback = this.ADS.getCurrentCallback();
        MockNotification mnotice = new MockNotification(4321L, nh);
        callback.apply((AmsAddr)Mockito.mock(AmsAddr.class), (AdsNotificationHeader)mnotice, 0);
        BlockingQueue queue = this.driver.getNotificationQueue();
        Assertions.assertEquals((int)1, (int)queue.size(), (String)"Wrong queue size.");
        Notification notice = (Notification)queue.take();
        Assertions.assertNotNull((Object)notice, (String)"Null notice returned from queue.");
        ByteBuffer buf = notice.getData();
        Assertions.assertNotNull((Object)buf, (String)"Null data buffer returned from notification.");
        Assertions.assertAll((String)"Notification checks.", (Executable[])new Executable[]{() -> Assertions.assertSame((Object)vh, (Object)notice.getVariableHandle(), (String)"Wrong variable handle."), () -> Assertions.assertEquals((int)nh, (int)notice.getNotificationHandle(), (String)"Wrong notification handle."), () -> Assertions.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)buf.order(), (String)"Wrong byte order."), () -> Assertions.assertEquals((int)4, (int)buf.capacity(), (String)"Wrong data buffer capacity."), () -> Assertions.assertEquals((int)4, (int)buf.limit(), (String)"Wrong data buffer limit."), () -> Assertions.assertEquals((int)0, (int)buf.position(), (String)"Wrong data buffer position.")});
        buf.order(ByteOrder.nativeOrder());
        Assertions.assertEquals((int)mnotice.data, (int)buf.getInt(), (String)"Wrong data value.");
    }

    @Test
    public void testCancelNotifications() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        int result = this.driver.requestNotifications(vh, Duration.ofMillis(20L), Duration.ofMillis(256L), true);
        this.driver.cancelNotifications(vh);
        this.driver.cancelNotifications(vh);
        ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsSyncDelDeviceNotificationReqEx(Mockito.anyLong(), (AmsAddr)Mockito.any(), Mockito.anyInt());
    }

    @Test
    public void testReadVariable() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        ByteBuffer rbuf = this.driver.readVariable(vh);
        Assertions.assertNotNull((Object)rbuf, (String)"Returned a null ByteBuffer.");
        Assertions.assertAll((String)"Value returned by readVariable().", (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)rbuf.order(), (String)"Wrong byte order for ByteBuffer."), () -> Assertions.assertEquals((int)123, (int)rbuf.getInt(), (String)"Wrong value in ByteBuffer."), () -> ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsSyncReadReqEx2(Mockito.anyLong(), (AmsAddr)Mockito.any(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (byte[])Mockito.any(), (int[])Mockito.any())});
    }

    @Test
    public void testWriteVariable() throws Exception {
        VariableHandle vh = this.driver.getVariableHandle("foo");
        ByteBuffer wbuf = vh.createBuffer();
        wbuf.putInt(123);
        this.driver.writeVariable(vh, wbuf);
        ((MockADSLibrary)Mockito.verify((Object)this.ADS, (VerificationMode)Mockito.times((int)1))).AdsSyncWriteReqEx(Mockito.anyLong(), (AmsAddr)Mockito.any(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (byte[])Mockito.any());
    }

    @Test
    public void testGetNotificationQueue() {
        Assertions.assertNotNull((Object)this.driver.getNotificationQueue(), (String)"Notification queue is null.");
    }

    public static class MockNotification
    extends AdsNotificationHeader {
        public int data = 1234;

        public MockNotification(long nTimeStamp, int hNotification) {
            super(nTimeStamp, hNotification, 4);
            this.write();
        }

        protected List<String> getFieldOrder() {
            ArrayList<String> fields = new ArrayList<String>(super.getFieldOrder());
            fields.add("data");
            return fields;
        }
    }
}

