/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads;

import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.lsst.ccs.drivers.ads.ADSDriver;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;

@Tag(value="org.lsst.ccs.test.categories.ManualTest")
public class ADSDriverManualTest {
    private static final String LOCAL_AMS_NETID = "134.79.86.183.1.1";
    private static final String REMOTE_AMS_NETID = "5.56.86.54.1.1";
    private static final String REMOTE_IP_ADDRESS = "192.168.10.40";

    @Test
    public void testAPI() throws Exception {
        int i;
        ADSDriver driver = new ADSDriver(LOCAL_AMS_NETID);
        driver.open(REMOTE_AMS_NETID, REMOTE_IP_ADDRESS);
        VariableHandle varHandle = driver.getVariableHandle("byByte");
        ByteBuffer value = varHandle.createBuffer();
        if (value.order() != ByteOrder.LITTLE_ENDIAN) {
            System.out.println("Wrong byte order on ByteBuffer returned by createBuffer().");
        }
        if (value.capacity() != 1028) {
            System.out.println("Wrong size of ByteBuffer returned by createBuffer().");
        }
        if ((value = driver.readVariable(varHandle)).order() != ByteOrder.LITTLE_ENDIAN) {
            System.out.println("Wrong byte order on ByteBuffer returned by readVariable().");
        }
        System.out.format("Read %d bytes from variable 'byByte'.%n   ", value.capacity());
        for (i = 0; i < 8; ++i) {
            System.out.format(" %d", value.get(i));
        }
        System.out.println(" ...");
        value.position(0);
        value.put((byte)10).put((byte)9).put((byte)8).put((byte)7);
        driver.writeVariable(varHandle, value);
        value = driver.readVariable(varHandle);
        System.out.format("Re-read %d bytes from variable 'byByte' after writing.%n   ", value.capacity());
        for (i = 0; i < 8; ++i) {
            System.out.format(" %d", value.get(i));
        }
        System.out.println(" ...");
        System.out.println();
        driver.requestNotifications(varHandle, Duration.ZERO, Duration.ofSeconds(2L), true);
        for (int j = 0; j < 5; ++j) {
            Notification notice = (Notification)driver.getNotificationQueue().take();
            value = notice.getData();
            if (value.order() != ByteOrder.LITTLE_ENDIAN && j == 0) {
                System.out.println("Wrong byte order in ByteBuffer containing notice data.");
            }
            System.out.format("Notif handle %d, variable %s, ", notice.getNotificationHandle(), notice.getVariableHandle().getName());
            System.out.format("%d bytes:", value.capacity());
            for (int i2 = 0; i2 < 8; ++i2) {
                System.out.format(" %d", value.get(i2));
            }
            System.out.println(" ...");
        }
        driver.cancelNotifications(varHandle);
        System.out.println();
        driver.releaseVariableHandle(varHandle);
        try {
            driver.releaseVariableHandle(varHandle);
            System.out.println("Double-freeing the var handle passed unnoticed.");
        }
        catch (ADSDriver.BadVarHandleException exc) {
            System.out.println("Double-freeing the var handle caused the right kind of exception.");
        }
        catch (DriverException exc) {
            System.out.println("Double-freeing the var handle caused the WRONG kind of exception.");
        }
        driver.close();
    }

    @Test
    public void testCommandHandshake() throws Exception {
        ADSDriver ADS = new ADSDriver(LOCAL_AMS_NETID);
        ADS.open(REMOTE_AMS_NETID, REMOTE_IP_ADDRESS);
        UUID uuid = UUID.randomUUID();
        int sequence = 0;
        VariableHandle plcenable = ADS.getVariableHandle("inChangeAxisEnable");
        VariableHandle plcack = ADS.getVariableHandle("ackChangeAxisEnable");
        int notifEnable = ADS.requestNotifications(plcack, Duration.ZERO, Duration.ZERO, true);
        Thread.sleep(2000L);
        BlockingQueue queue = ADS.getNotificationQueue();
        queue.clear();
        ChangeAxisEnable jenable = new ChangeAxisEnable("+X", true);
        long serialID = ObjectStreamClass.lookup(ChangeAxisEnable.class).getSerialVersionUID();
        ByteBuffer outdata = plcenable.createBuffer();
        boolean outAckCode = false;
        int outDtime = (int)Instant.now().toEpochMilli();
        int outSeq = sequence++;
        int axisIndex = jenable.getAxisName().equals("+X") ? 1 : 2;
        byte enable = jenable.isEnabled() ? (byte)1 : 0;
        outdata.putLong(uuid.getLeastSignificantBits());
        outdata.putLong(uuid.getMostSignificantBits());
        outdata.putInt(outDtime);
        outdata.putInt(outSeq);
        outdata.putLong(serialID);
        outdata.putInt(0);
        outdata.putInt(axisIndex);
        outdata.put(enable);
        ADS.writeVariable(plcenable, outdata);
        Notification notice = (Notification)queue.poll(10L, TimeUnit.SECONDS);
        if (notice == null) {
            Assertions.fail((String)"No response from the PLC controller.");
        }
        Assertions.assertEquals((int)notifEnable, (int)notice.getNotificationHandle(), (String)"Wrong notification handle in reply.");
        ByteBuffer ackData = notice.getData();
        long ackUULow = ackData.getLong();
        long ackUUHigh = ackData.getLong();
        UUID ackUUID = new UUID(ackUUHigh, ackUULow);
        int ackDtime = ackData.getInt();
        int ackSeq = ackData.getInt();
        long ackVersion = ackData.getLong();
        int ackAckCode = ackData.getInt();
        Assertions.assertAll((String)"Check of acknowledgement message.", (Executable[])new Executable[]{() -> Assertions.assertEquals((Object)uuid, (Object)ackUUID, (String)"Wrong UUID."), () -> Assertions.assertEquals((int)outDtime, (int)ackDtime, (String)"Wrong dtime."), () -> Assertions.assertEquals((int)outSeq, (int)ackSeq, (String)"Wrong sequence number."), () -> Assertions.assertEquals((long)serialID, (long)ackVersion, (String)"Wrong class version."), () -> Assertions.assertEquals((int)0, (int)ackAckCode, (String)"Wrong ack code.")});
        ADS.close();
    }
}

