package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Native;
import java.io.IOException;
import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

/**
 * Does the same things as the C++ example program in
 * Beckhoff/ADS/examples on GitHub.
 * @author tether
 */
public class Example2 {
    
    private static interface CbVoid extends Callback {
        void apply();
    }
    
    private static interface CbInt extends Callback {
        void apply(int arg);
    }
    
    private static interface CbStruct extends Callback {
        void apply(AmsAddr addr, AdsNotificationHeader header, int data);
    }
    
    private static interface SimpleCb extends Library {
        
        void callVoid(CbVoid fn);
        
        void callInt(CbInt fn);
        
        void callStruct(CbStruct fn);
        
    }
    
    private static void fn1() {System.out.println("Called fn1().");}
    
    private static void fn2(int arg) {System.out.println("Called fn2() with " + arg);}
    
    private static void fn3(AmsAddr addr, AdsNotificationHeader header, int data) {
        System.out.format("Called fn3() with address = %s.%n", addr);
        System.out.format("    Time, handle, bytes = %d  %d  %d.%n", header.nTimeStamp, header.hNotification, header.cbSampleSize);
        System.out.format("    Extra data = %d.%n", data);
    }
    
    final static SimpleCb CBLIB;
    
    static {
        CBLIB = (SimpleCb)
            Native.loadLibrary("simplecb", SimpleCb.class);
    }

    public static class ArgStruct extends Structure {
        public int num;
        public ArgStruct() {super(); num = 0;}
        @Override protected List<String> getFieldOrder() {return Arrays.asList("num");}
    }
    
    public static void main(String[] args) throws IOException {
        CBLIB.callVoid(Example2::fn1);
        CBLIB.callInt(Example2::fn2);
        CBLIB.callStruct(Example2::fn3);
    }
}
