/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads.test;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import org.junit.Ignore;
import org.junit.Test;
import org.lsst.ccs.drivers.ads.ADSDriver;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.lsst.ccs.drivers.commons.DriverException;

public class ADSDriverTest {
    @Ignore(value="Run by hand only.")
    @Test
    public void testAll() throws Exception {
        int i;
        ADSDriver driver = new ADSDriver("134.79.86.183.1.1");
        driver.open("5.56.86.54.1.1", "192.168.10.40");
        VariableHandle varHandle = driver.getVariableHandle("byByte");
        ByteBuffer value = varHandle.createBuffer();
        if (value.order() != ByteOrder.LITTLE_ENDIAN) {
            System.out.println("Wrong byte order on ByteBuffer returned by createBuffer().");
        }
        if (value.capacity() != 1028) {
            System.out.println("Wrong size of ByteBuffer returned by createBuffer().");
        }
        if ((value = driver.readVariable(varHandle)).order() != ByteOrder.LITTLE_ENDIAN) {
            System.out.println("Wrong byte order on ByteBuffer returned by readVariable().");
        }
        System.out.format("Read %d bytes from variable 'byByte'.%n   ", value.capacity());
        for (i = 0; i < 8; ++i) {
            System.out.format(" %d", value.get(i));
        }
        System.out.println(" ...");
        value.position(0);
        value.put((byte)10).put((byte)9).put((byte)8).put((byte)7);
        driver.writeVariable(varHandle, value);
        value = driver.readVariable(varHandle);
        System.out.format("Re-read %d bytes from variable 'byByte' after writing.%n   ", value.capacity());
        for (i = 0; i < 8; ++i) {
            System.out.format(" %d", value.get(i));
        }
        System.out.println(" ...");
        System.out.println();
        driver.requestNotifications(varHandle, Duration.ZERO, Duration.ofSeconds(2L), true);
        for (int j = 0; j < 5; ++j) {
            Notification notice = (Notification)driver.getNotificationQueue().take();
            value = notice.getData();
            if (value.order() != ByteOrder.LITTLE_ENDIAN && j == 0) {
                System.out.println("Wrong byte order in ByteBuffer containing notice data.");
            }
            System.out.format("Notif handle %d, variable %s, ", notice.getNotificationHandle(), notice.getVariableHandle().getName());
            System.out.format("%d bytes:", value.capacity());
            for (int i2 = 0; i2 < 8; ++i2) {
                System.out.format(" %d", value.get(i2));
            }
            System.out.println(" ...");
        }
        driver.cancelNotifications(varHandle);
        System.out.println();
        driver.releaseVariableHandle(varHandle);
        try {
            driver.releaseVariableHandle(varHandle);
            System.out.println("Double-freeing the var handle passed unnoticed.");
        }
        catch (ADSDriver.BadVarHandleException exc) {
            System.out.println("Double-freeing the var handle caused the right kind of exception.");
        }
        catch (DriverException exc) {
            System.out.println("Double-freeing the var handle caused the WRONG kind of exception.");
        }
        driver.close();
    }
}

