package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Structure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * The NetId of an ADS device can be represented in this structure.
 */
public class AmsNetId extends Structure implements Structure.ByValue {
    /** NetId, consisting of 6 digits. */
    public byte[] idBytes;

    public AmsNetId(int b1, int b2, int b3, int b4, int b5, int b6) {
        super(ALIGN_NONE); // pack(1) pragma used in AdsDef.h
        idBytes = new byte[]{(byte)b1, (byte)b2, (byte)b3,
            (byte)b4, (byte)b5, (byte)b6};
    }
    
    /** For Use by JNA. */
    public AmsNetId() {
        super(ALIGN_NONE);
        // JNA needs to know how long the array should be.
        this.idBytes = new byte[]{0, 0, 0, 0, 0, 0};
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("idBytes");
    }
    
    @Override
    public String toString() {
        final List<String> id = new ArrayList<>(idBytes.length);
        for (int i = 0; i < idBytes.length; ++i) {
            final Integer octet = ((int)idBytes[i]) & 0xff;
            id.add(octet.toString());
        }
        return String.join(".", id);
    }
}
