package org.lsst.ccs.drivers.ads.wrapper;

import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

/**
 * The complete address, net ID and port, of an ADS device can be stored
 * in this structure. Note that an AMS port is not a TCP port.
 */
public class AmsAddr extends Structure {
    /** AMS Net Id */
    public AmsNetId netId;
    
    /** AMS Port number */
    public short port;

    public AmsAddr(AmsNetId netId, short port) {
        super(ALIGN_NONE);  // pack(1) pragma was used in AdsDef.h
        this.netId = netId;
        this.port = port;
    }
    
    /** For use by JNA. */
    public AmsAddr() {
        super(ALIGN_NONE);
        this.netId = new AmsNetId();
        this.port = 0;
    }
    
    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("netId", "port");
    }
    
    @Override
    public String toString() {
        return netId.toString() + ":" + port;
    }

}
