/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import org.lsst.ccs.drivers.ad.Cypress;
import org.lsst.ccs.drivers.commons.DriverException;

public abstract class SpiBus
extends Cypress {
    private static final int READ_TIMEOUT = 1000;
    private static final int RQST_SPI = 218;
    private static final String STD_LOAD_FILE = "/Icv_spi.hex";
    private int rdyTimeout = 0;

    void initialize() throws DriverException {
        this.load(false);
    }

    public abstract int commReg(int var1, boolean var2);

    public void setRdyTimeout(int period) {
        this.rdyTimeout = period;
    }

    public int getRdyTimeout() {
        return this.rdyTimeout;
    }

    public int readRegister(int regnum, int size) throws DriverException {
        byte[] data = new byte[size + 1];
        this.usb.controlRead(192, 218, this.commReg(regnum, true), this.rdyTimeout, data, 0, data.length, 1000);
        int value = 0;
        for (int j = 1; j <= size; ++j) {
            value = value << 8 | data[j] & 0xFF;
        }
        return value;
    }

    public void writeRegister(int regnum, int size, int value) throws DriverException {
        byte[] data = new byte[size + 1];
        data[0] = (byte)this.commReg(regnum, false);
        for (int j = 0; j < size; ++j) {
            data[size - j] = (byte)value;
            value >>= 8;
        }
        this.usb.controlWrite(64, 218, 0, this.rdyTimeout, data, 0, data.length, 0);
    }

    public void updateRegister(int regnum, int size, int mask, int value) throws DriverException {
        int data = this.readRegister(regnum, size);
        this.writeRegister(regnum, size, data & ~mask | value & mask);
    }

    public void load(boolean force) throws DriverException {
        this.load(STD_LOAD_FILE, force);
    }
}

