/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import org.lsst.ccs.drivers.ad.Cypress;
import org.lsst.ccs.drivers.commons.DriverException;

public class I2cBus
extends Cypress {
    private static final int READ_TIMEOUT = 1000;
    private static final int RQST_I2C = 221;
    private static final int ADDR_I2C_READ = 145;
    private static final int ADDR_I2C_WRITE = 144;
    private static final String STD_LOAD_FILE = "/Icv_usb.hex";

    void initialize() throws DriverException {
        this.load(false);
    }

    public int readRegister2(int regnum) throws DriverException {
        byte[] data = new byte[2];
        this.readRegister(regnum, data);
        return data[1] & 0xFF | (data[0] & 0xFF) << 8;
    }

    public int readRegister3(int regnum) throws DriverException {
        byte[] data = new byte[3];
        this.readRegister(regnum, data);
        return data[2] & 0xFF | (data[1] & 0xFF) << 8 | (data[0] & 0xFF) << 16;
    }

    public int readRegister(int regnum, byte[] data) throws DriverException {
        return this.usb.controlRead(192, 221, 145, regnum, data, 0, data.length, 1000);
    }

    public int readRegister(int regnum) throws DriverException {
        byte[] data = new byte[1];
        this.readRegister(regnum, data);
        return data[0] & 0xFF;
    }

    public int writeRegister(int regnum, byte[] data) throws DriverException {
        return this.usb.controlWrite(64, 221, 144, regnum, data, 0, data.length, 0);
    }

    public void writeRegister(int regnum, int value) throws DriverException {
        this.writeRegister(regnum, new byte[]{(byte)value});
    }

    public void updateRegister(int regnum, int mask, int value) throws DriverException {
        int data = this.readRegister(regnum);
        this.writeRegister(regnum, data & ~mask | value & mask);
    }

    public void load(boolean force) throws DriverException {
        this.load(STD_LOAD_FILE, force);
    }
}

