/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import org.lsst.ccs.drivers.ad.I2cBus;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbDevice;
import org.lsst.ccs.drivers.usb.UsbLib;

public class Ad7747Eval
extends I2cBus {
    public static final int STATUS_REG = 0;
    public static final int CAP_DATA_REG = 1;
    public static final int VT_DATA_REG = 4;
    public static final int CAP_SETUP_REG = 7;
    public static final int VT_SETUP_REG = 8;
    public static final int EXC_SETUP_REG = 9;
    public static final int CONFIG_REG = 10;
    public static final int CAP_DAC_A_REG = 11;
    public static final int CAP_DAC_B_REG = 12;
    public static final int CAP_OFFSET_REG = 13;
    public static final int CAP_GAIN_REG = 15;
    public static final int VOLT_GAIN_REG = 17;
    public static final int STS_READY = 4;
    public static final int STS_RDYVT = 2;
    public static final int STS_RDYCAP = 1;
    public static final int CPSU_CAPEN = 128;
    public static final int CPSU_CAPDIFF = 32;
    public static final int CPSU_STANDARD = 32;
    public static final int VTSU_VTEN = 128;
    public static final int VTSU_VTMODE_M = 96;
    public static final int VTSU_VTMODE_V = 5;
    public static final int VTMD_INT_TEMP = 0;
    public static final int VTMD_EXT_TEMP = 1;
    public static final int VTMD_VDD_MON = 2;
    public static final int VTMD_EXT_VOLT = 3;
    public static final int VTSU_EXTREF = 16;
    public static final int VTSU_VTSHORT = 2;
    public static final int VTSU_VTCHOP = 1;
    public static final int VTSU_STANDARD = 1;
    public static final int EXSU_EXCDAC = 8;
    public static final int EXSU_EXCEN = 4;
    public static final int EXSU_EXCLVL_M = 3;
    public static final int EXSU_EXCLVL_V = 0;
    public static final int EXCLVL_1_8 = 0;
    public static final int EXCLVL_1_4 = 1;
    public static final int EXCLVL_3_8 = 2;
    public static final int EXCLVL_1_2 = 3;
    public static final int EXSU_STANDARD = 14;
    public static final int CFG_VTFS_M = 192;
    public static final int CFG_VTFS_V = 6;
    public static final int VTFS_RATE_50 = 0;
    public static final int VTFS_RATE_31 = 1;
    public static final int VTFS_RATE_16 = 2;
    public static final int VTFS_RATE_8 = 3;
    public static final int VTFS_TIME_20 = 0;
    public static final int VTFS_TIME_32 = 1;
    public static final int VTFS_TIME_62 = 2;
    public static final int VTFS_TIME_122 = 3;
    public static final int CFG_CAPFS_M = 56;
    public static final int CFG_CAPFS_V = 3;
    public static final int CAPFS_RATE_45 = 0;
    public static final int CAPFS_RATE_42 = 1;
    public static final int CAPFS_RATE_25 = 2;
    public static final int CAPFS_RATE_13 = 3;
    public static final int CAPFS_RATE_8 = 4;
    public static final int CAPFS_RATE_7 = 5;
    public static final int CAPFS_RATE_6 = 6;
    public static final int CAPFS_RATE_5 = 7;
    public static final int CAPFS_TIME_22 = 0;
    public static final int CAPFS_TIME_24 = 1;
    public static final int CAPFS_TIME_40 = 2;
    public static final int CAPFS_TIME_76 = 3;
    public static final int CAPFS_TIME_124 = 4;
    public static final int CAPFS_TIME_154 = 5;
    public static final int CAPFS_TIME_184 = 6;
    public static final int CAPFS_TIME_219 = 7;
    public static final int CFG_MODE_M = 7;
    public static final int CFG_MODE_V = 0;
    public static final int MODE_IDLE = 0;
    public static final int MODE_CONT = 1;
    public static final int MODE_SINGLE = 2;
    public static final int MODE_POWERDOWN = 3;
    public static final int MODE_OFFS_CAL = 5;
    public static final int MODE_GAIN_CAL = 6;
    public static final int DACA_ENABLE = 128;
    public static final int DACA_VALUE_M = 63;
    public static final int DACB_ENABLE = 128;
    public static final int DACB_VALUE_M = 63;
    public static final int RDO_CONFIG = 1;
    public static final int RDO_EXTERN = 2;
    public static final int RDO_SINGLE = 4;
    public static final int RDO_IMMED = 8;
    public static final float HALF_RANGE3 = 8388608.0f;
    public static final float REF_VOLTAGE = 1.17f;
    public static final float CAP_FULL_SCALE = 8.192f;
    public static final float TEMP_FULL_SCALE = 4096.0f;
    public static final float INT_VOLT_SCALE = 6.0f;
    private static final int AD_VID = 1110;
    private static final int AD_7747_PID = 46209;

    public void connect(int index) throws DriverException {
        UsbDevice devc = UsbLib.getDevice(1110, 46209, null, index);
        if (devc == null) {
            throw new DriverException("No matching AD7747 board found");
        }
        this.setUsbDevice(devc);
        this.initialize();
    }

    public void setupStandard() throws DriverException {
        this.writeRegister(7, 32);
        this.writeRegister(9, 14);
        this.writeRegister(8, 1);
        this.writeRegister(10, 0);
    }

    public int getStatus() throws DriverException {
        return this.readRegister(0);
    }

    public void setCapEnabled(boolean set) throws DriverException {
        this.updateRegister(7, 128, set ? 128 : 0);
    }

    public boolean isCapEnabled() throws DriverException {
        return (this.readRegister(7) & 0x80) != 0;
    }

    public void setExcEnabled(boolean set) throws DriverException {
        this.updateRegister(9, 4, set ? 4 : 0);
    }

    public boolean isExcEnabled() throws DriverException {
        return (this.readRegister(9) & 4) != 0;
    }

    public void setVtEnabled(boolean set) throws DriverException {
        this.updateRegister(8, 128, set ? 128 : 0);
    }

    public boolean isVtEnabled() throws DriverException {
        return (this.readRegister(8) & 0x80) != 0;
    }

    public void setVtMode(int mode) throws DriverException {
        this.updateRegister(8, 96, mode << 5);
    }

    public int getVtMode() throws DriverException {
        return (this.readRegister(8) & 0x60) >> 5;
    }

    public void setVtShorted(boolean set) throws DriverException {
        this.updateRegister(8, 2, set ? 2 : 0);
    }

    public boolean isVtShorted() throws DriverException {
        return (this.readRegister(8) & 2) != 0;
    }

    public void setExternalRef(boolean set) throws DriverException {
        this.updateRegister(8, 16, set ? 16 : 0);
    }

    public boolean isExternalRef() throws DriverException {
        return (this.readRegister(8) & 0x10) != 0;
    }

    public void setVtConvRate(int rate) throws DriverException {
        this.updateRegister(10, 192, rate << 6);
    }

    public int getVtConvRate() throws DriverException {
        return (this.readRegister(10) & 0xC0) >> 6;
    }

    public void setCapConvRate(int rate) throws DriverException {
        this.updateRegister(10, 56, rate << 3);
    }

    public int getCapConvRate() throws DriverException {
        return (this.readRegister(10) & 0x38) >> 3;
    }

    public void setConvMode(int mode) throws DriverException {
        this.updateRegister(10, 7, mode);
    }

    public int getConvMode() throws DriverException {
        return this.readRegister(10) & 7;
    }

    public void setDacAEnabled(boolean set) throws DriverException {
        this.updateRegister(11, 128, set ? 128 : 0);
    }

    public boolean isDacAEnabled() throws DriverException {
        return (this.readRegister(11) & 0x80) != 0;
    }

    public void setDacAValue(int value) throws DriverException {
        this.updateRegister(11, 63, value);
    }

    public int getDacAValue() throws DriverException {
        return this.readRegister(11) & 0x3F;
    }

    public void setDacBEnabled(boolean set) throws DriverException {
        this.updateRegister(12, 128, set ? 128 : 0);
    }

    public boolean isDacBEnabled() throws DriverException {
        return (this.readRegister(12) & 0x80) != 0;
    }

    public void setDacBValue(int value) throws DriverException {
        this.updateRegister(12, 63, value);
    }

    public int getDacBValue() throws DriverException {
        return this.readRegister(12) & 0x3F;
    }

    public float readCapacitance(int optns) throws DriverException {
        if ((optns & 4) != 0) {
            this.updateRegister(10, 7, 2);
        }
        if ((optns & 8) == 0) {
            this.waitReady(1);
        }
        return ((float)this.readRegister3(1) / 8388608.0f - 1.0f) * 8.192f;
    }

    public float readTemperature(int optns) throws DriverException {
        if ((optns & 1) != 0) {
            this.updateRegister(8, 96, ((optns & 2) != 0 ? 1 : 0) << 5);
        }
        if ((optns & 4) != 0) {
            this.updateRegister(10, 7, 2);
        }
        if ((optns & 8) == 0) {
            this.waitReady(2);
        }
        return ((float)this.readRegister3(4) / 8388608.0f - 1.0f) * 4096.0f;
    }

    public float readVoltage(int optns) throws DriverException {
        boolean ext;
        boolean bl = ext = (optns & 2) != 0;
        if ((optns & 1) != 0) {
            this.updateRegister(8, 96, (ext ? 3 : 2) << 5);
        }
        if ((optns & 4) != 0) {
            this.updateRegister(10, 7, 2);
        }
        if ((optns & 8) == 0) {
            this.waitReady(2);
        }
        float volts = ((float)this.readRegister3(4) / 8388608.0f - 1.0f) * 1.17f;
        if (!ext) {
            volts *= 6.0f;
        }
        return volts;
    }

    private void waitReady(int mask) throws DriverException {
        long start = System.currentTimeMillis();
        boolean ready = false;
        while (!(ready = (this.getStatus() & mask) == 0) && System.currentTimeMillis() - start <= 5000L) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!ready) {
            throw new DriverException("Conversion timed out");
        }
    }
}

