/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import java.io.FileNotFoundException;
import java.io.InputStream;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.usb.UsbDevice;

public class Cypress {
    static final int RTYP_VENDOR_READ = 192;
    static final int RTYP_VENDOR_WRITE = 64;
    static final int RQST_CYPRESS = 160;
    static final int RESET_ADDR = 58880;
    static final int CACHE_SIZE = 4096;
    static final int PACKET_SIZE = 256;
    static final byte BOL_MARKER = 58;
    UsbDevice usb;
    private String loadFile;
    private final int[] loadMap = new int[129];
    private final byte[] loadImage = new byte[4097];

    public void setUsbDevice(UsbDevice usb) {
        this.usb = usb;
    }

    public void setReset(boolean on) throws DriverException {
        byte[] data = new byte[]{(byte)(on ? 1 : 0)};
        this.usb.controlWrite(64, 160, 58880, 0, data, 0, data.length, 0);
    }

    public int readMemory(int addr, byte[] data, int timeout) throws DriverException {
        return this.usb.controlRead(192, 160, addr, 0, data, 0, data.length, timeout);
    }

    public int readMemory(int addr, byte[] data, int offs, int leng, int timeout) throws DriverException {
        return this.usb.controlRead(192, 160, addr, 0, data, offs, leng, timeout);
    }

    public int writeMemory(int addr, byte[] data) throws DriverException {
        return this.usb.controlWrite(64, 160, addr, 0, data, 0, data.length, 0);
    }

    public int writeMemory(int addr, byte[] data, int offs, int leng) throws DriverException {
        return this.usb.controlWrite(64, 160, addr, 0, data, offs, leng, 0);
    }

    public void load(String name, boolean force) throws DriverException {
        if (!name.equals(this.loadFile)) {
            this.cacheFile(name);
        }
        if (force || !this.checkCache()) {
            this.loadCache();
        }
    }

    private void cacheFile(String name) throws DriverException {
        int nRead;
        byte[] data;
        InputStream file;
        int fileSize = 0;
        try {
            file = Cypress.class.getResourceAsStream(name);
            if (file == null) {
                throw new FileNotFoundException(name);
            }
            data = new byte[1024];
            while ((nRead = file.read(data)) >= 0) {
                fileSize += nRead;
            }
            file.close();
        }
        catch (Exception e) {
            throw new DriverException("Error reading file: " + e);
        }
        try {
            file = Cypress.class.getResourceAsStream(name);
            if (file == null) {
                throw new FileNotFoundException(name);
            }
            data = new byte[fileSize];
            nRead = file.read(data);
            file.close();
        }
        catch (Exception e) {
            throw new DriverException("Error reading file: " + e);
        }
        if (nRead != fileSize) {
            throw new DriverException("Inconsistent data amount read");
        }
        this.loadFile = null;
        for (int j = 0; j < this.loadMap.length; ++j) {
            this.loadMap[j] = 0;
        }
        int posn = 0;
        while (posn >= 0 && posn < fileSize) {
            posn = this.processLine(data, posn);
        }
        if (posn >= 0) {
            throw new DriverException("EOF record missing");
        }
        if (-posn < fileSize) {
            throw new DriverException("EOF record not last in file");
        }
        this.loadFile = name;
    }

    private int processLine(byte[] data, int posn) throws DriverException {
        if (posn + 11 > data.length) {
            throw new DriverException("Record too short");
        }
        if (data[posn] != 58) {
            throw new DriverException("Beginning-of-line marker not found");
        }
        int leng = this.decodeHex(data, posn + 1);
        if (posn + 11 + 2 * leng > data.length) {
            throw new DriverException("Record too short");
        }
        posn += 3;
        int checkSum = leng;
        int addr = 0;
        int type = 0;
        int j = 0;
        while (j < leng + 4) {
            int value = this.decodeHex(data, posn);
            if (j == 0) {
                addr = value << 8;
            } else if (j == 1) {
                addr |= value;
            } else if (j == 2) {
                type = value;
                if (type != 0 && type != 1) {
                    throw new DriverException("Invalid record type");
                }
            } else if (j < leng + 3) {
                int ad = addr + j - 3;
                if (ad >= 4096) {
                    throw new DriverException("Address too large");
                }
                this.loadImage[ad] = (byte)value;
                int n = ad >> 5;
                this.loadMap[n] = this.loadMap[n] | 1 << (ad & 0x1F);
            }
            checkSum += value;
            ++j;
            posn += 2;
        }
        if ((checkSum & 0xFF) != 0) {
            throw new DriverException("Checksum failed");
        }
        if (!(data[posn] != 13 && data[posn] != 10 || data[++posn] != 13 && data[posn] != 10)) {
            ++posn;
        }
        return type == 0 ? posn : -posn;
    }

    private int decodeHex(byte[] data, int offs) throws DriverException {
        try {
            return Integer.parseInt(new String(data, offs, 2), 16);
        }
        catch (Exception e) {
            throw new DriverException("Invalid hexadecimal number");
        }
    }

    private void loadCache() throws DriverException {
        this.setReset(true);
        int start = 0;
        boolean skip = true;
        for (int j = 0; j < this.loadImage.length; ++j) {
            boolean set;
            boolean bl = set = (this.loadMap[j >> 5] & 1 << (j & 0x1F)) != 0;
            if (skip ^ set) continue;
            if (skip) {
                start = j;
            } else {
                int leng = j - start;
                while (leng > 0) {
                    int wLeng = leng > 256 ? 256 : leng;
                    this.writeMemory(start, this.loadImage, start, wLeng);
                    leng -= wLeng;
                    start += wLeng;
                }
            }
            skip = !skip;
        }
        this.setReset(false);
    }

    private boolean checkCache() throws DriverException {
        this.setReset(true);
        boolean match = true;
        boolean skip = true;
        int start = 0;
        for (int j = 0; j < this.loadImage.length; ++j) {
            boolean set;
            boolean bl = set = (this.loadMap[j >> 5] & 1 << (j & 0x1F)) != 0;
            if (skip ^ set) continue;
            if (!skip) {
                int leng = j - start;
                if (leng > 256) {
                    leng = 256;
                }
                byte[] data = new byte[leng];
                this.readMemory(start, data, 1000);
                for (int k = 0; k < leng; ++k) {
                    if (data[k] == this.loadImage[start + k]) continue;
                    match = false;
                }
                break;
            }
            start = j;
            skip = !skip;
        }
        this.setReset(false);
        return match;
    }
}

