/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import java.util.ArrayList;
import javax.usb.UsbException;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ad.Ad7794Eval;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestAd7794
implements CmndProcess.Dispatch {
    private static final int CMD_READMEM = 0;
    private static final int CMD_WRITEMEM = 1;
    private static final int CMD_LOAD = 2;
    private static final int CMD_RESET = 3;
    private static final int CMD_READREG = 4;
    private static final int CMD_WRITEREG = 5;
    private static final int CMD_READADC = 6;
    private static final int CMD_READTEMP = 7;
    private static final int CMD_READVDD = 8;
    private static final int CMD_INIT = 9;
    private static final int CMD_SHOWREGS = 10;
    private static final int CMD_SETCONV = 11;
    private static final int CMD_SHOWCONV = 12;
    private static final int CMD_SETRATE = 13;
    private static final int CMD_SHOWRATE = 14;
    private static final int CMD_SETCLOCK = 15;
    private static final int CMD_SHOWCLOCK = 16;
    private static final int CMD_SETGAIN = 17;
    private static final int CMD_SHOWGAIN = 18;
    private static final int CMD_SETREFSEL = 19;
    private static final int CMD_SHOWREFSEL = 20;
    private static final int CMD_SETREFDET = 21;
    private static final int CMD_SHOWREFDET = 22;
    private static final int CMD_SETBUFF = 23;
    private static final int CMD_SHOWBUFF = 24;
    private static final int CMD_SETUNIPOL = 25;
    private static final int CMD_SHOWUNIPOL = 26;
    private static final int CMD_SETSWITCH = 27;
    private static final int CMD_SHOWSWITCH = 28;
    private static final int CMD_SHOWSTATUS = 29;
    private static final int CMD_READTHERM = 30;
    private static final int NUM_CMDS = 31;
    private static final String[] helpInit = new String[]{"Initializes setup registers to standard values", "init"};
    private static final String[] helpShowstatus = new String[]{"Display status register contents", "showstatus"};
    private static final String[] helpSetconv = new String[]{"Set conversion mode", "setconv <value>", "value  The encoded conversion mode (0 - 7)"};
    private static final String[] helpShowconv = new String[]{"Display conversion mode", "showconv"};
    private static final String[] helpSetrate = new String[]{"Set conversion rate", "setrate <value>", "value  The encoded conversion rate (0 - 15)"};
    private static final String[] helpShowrate = new String[]{"Display conversion rate", "showrate"};
    private static final String[] helpSetclock = new String[]{"Set clock source", "setclock <value>", "value  The encoded clock source value (0 - 3)"};
    private static final String[] helpShowclock = new String[]{"Display clock source", "showclock"};
    private static final String[] helpSetgain = new String[]{"Set the gain", "setgain <value>", "value  The gain value (0 - 7)"};
    private static final String[] helpShowgain = new String[]{"Display the gain", "showgain"};
    private static final String[] helpSetrefsel = new String[]{"Set the reference source", "setrefsel <value>", "value  The encoded reference source (0 - 3)"};
    private static final String[] helpShowrefsel = new String[]{"Display reference source", "showrefsel"};
    private static final String[] helpSetrefdet = new String[]{"Set reference detection on or off", "setrefdet {on | off}"};
    private static final String[] helpShowrefdet = new String[]{"Display reference detection", "showrefdet"};
    private static final String[] helpSetbuff = new String[]{"Set buffered mode on or off", "setbuff {on | off}"};
    private static final String[] helpShowbuff = new String[]{"Display conversion mode", "showbuff"};
    private static final String[] helpSetunipol = new String[]{"Set unipolar mode on or off", "setunipol {on | off}"};
    private static final String[] helpShowunipol = new String[]{"Display unipolar mode", "showunipol"};
    private static final String[] helpSetswitch = new String[]{"Set power switch on or off", "setswitch {on | off}"};
    private static final String[] helpShowswitch = new String[]{"Display power switch state", "showswitch"};
    private static final String[] helpReadadc = new String[]{"Read an ADC channel and display the raw value", "readadc <chan> [<config>] [<single>] [<immed>] [<count>]", "chan    The ADC channel name or number (0 - 7)", "config  If present and non-zero, configure conversion mode", "single  If present and non-zero, single conversion, not continuous", "immed   If present and non-zero, don't wait for conversion", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadtemp = new String[]{"Read the internal temperature sensor and display the value", "readtemp [<config>] [<single>] [<immed>] [<count>]", "config  If present and non-zero, configure conversion mode", "single  If present and non-zero, single conversion, not continuous", "immed   If present and non-zero, don't wait for conversion", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadvdd = new String[]{"Read the internal voltage and display the value", "readvdd [<config>] [<single>] [<immed>] [<count>]", "config  If present and non-zero, configure conversion mode", "single  If present and non-zero, single conversion, not continuous", "immed   If present and non-zero, don't wait for conversion", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadtherm = new String[]{"Read the on-board thermistor and display the value", "readtherm [<config>] [<single>] [<immed>] [<count>]", "config  If present and non-zero, configure conversion mode", "single  If present and non-zero, single conversion, not continuous", "immed   If present and non-zero, don't wait for conversion", "count   The number of reads to average (default 1)"};
    private static final String[] helpShowregs = new String[]{"Show formatted display of all registers", "showregs"};
    private static final String[] helpReadreg = new String[]{"Read register and display the contents", "readreg <regnum>", "regnum   The number of the register to read"};
    private static final String[] helpWritereg = new String[]{"Write to register", "writereg <regnum> <value>", "regnum  The number of the register to write", "value   The value to write"};
    private static final String[] helpReadmem = new String[]{"Read data from memory and display it", "readmem <addr> <leng> [<timwout>]", "addr     The address to read from", "leng     The number of bytes to read", "timeout  The timeout value (secs, default 1.0)"};
    private static final String[] helpWritemem = new String[]{"Write data to memory", "writemem <addr> [<data1>]... [<data8>]", "addr   The address to write to", "datan  String of (an even number of) hexadecimal digits to write"};
    private static final String[] helpReset = new String[]{"Set or clear the RESET state", "reset  <opern>", "opern  If non-zero, RESET is set; if zero, RESET is cleared"};
    private static final String[] helpLoad = new String[]{"Load memory from a file", "load  [<file>] [<force>]", "file   The name of the .hex file to load (default: standard)", "force  If present and non-zero, do the load even if unnecessary"};
    private static final CmndProcess.Lookup chanNames = new CmndProcess.Lookup(8);
    private static final CmndProcess.Lookup cnvModeNames;
    private static final CmndProcess.Lookup rateNames;
    private static final CmndProcess.Lookup clockNames;
    private static final CmndProcess.Lookup gainNames;
    private static final CmndProcess.Lookup refsNames;
    private static final CmndProcess.Lookup onOffNames;
    private static final CmndProcess.Command cmnd;
    private static final Output out;
    private final CmndProcess proc = new CmndProcess();
    private final boolean debug;
    private Ad7794Eval ad;
    private static final String[] regName;
    private static final String[] regDesc0;
    private static final String[] regDesc1;

    static {
        chanNames.add("ain1", 0);
        chanNames.add("ain2", 1);
        chanNames.add("ain3", 2);
        chanNames.add("ain4", 3);
        chanNames.add("ain5", 4);
        chanNames.add("ain6", 5);
        chanNames.add("temperature", 6);
        chanNames.add("vdd", 7);
        cnvModeNames = new CmndProcess.Lookup(8);
        cnvModeNames.add("continuous", 0);
        cnvModeNames.add("single", 1);
        cnvModeNames.add("idle", 2);
        cnvModeNames.add("powerdown", 3);
        cnvModeNames.add("intoffcal", 4);
        cnvModeNames.add("intgaincal", 5);
        cnvModeNames.add("extoffcal", 6);
        cnvModeNames.add("extgaincal", 7);
        rateNames = new CmndProcess.Lookup(15);
        rateNames.add("470Hz", 1);
        rateNames.add("242Hz", 2);
        rateNames.add("123Hz", 3);
        rateNames.add("62Hz", 4);
        rateNames.add("50Hz", 5);
        rateNames.add("39Hz", 6);
        rateNames.add("33Hz", 7);
        rateNames.add("19Hz", 8);
        rateNames.add("17Hz", 9);
        rateNames.add("16Hz", 10);
        rateNames.add("12Hz", 11);
        rateNames.add("10Hz", 12);
        rateNames.add("8Hz", 13);
        rateNames.add("6Hz", 14);
        rateNames.add("4Hz", 15);
        clockNames = new CmndProcess.Lookup(4);
        clockNames.add("internal", 0);
        clockNames.add("intavail", 1);
        clockNames.add("external", 2);
        clockNames.add("exthalf", 3);
        gainNames = new CmndProcess.Lookup(8);
        gainNames.add("1X", 0);
        gainNames.add("2X", 1);
        gainNames.add("4X", 2);
        gainNames.add("8X", 3);
        gainNames.add("16X", 4);
        gainNames.add("32X", 5);
        gainNames.add("64X", 6);
        gainNames.add("128X", 7);
        refsNames = new CmndProcess.Lookup(3);
        refsNames.add("ext1", 0);
        refsNames.add("ext2", 1);
        refsNames.add("internal", 2);
        onOffNames = new CmndProcess.Lookup(2);
        onOffNames.add("on", 1);
        onOffNames.add("off", 0);
        cmnd = new CmndProcess.Command(31);
        cmnd.add("init", 9, helpInit, "", new CmndProcess.Lookup[0]);
        cmnd.add("readadc", 6, helpReadadc, "jiiii", new CmndProcess.Lookup[]{chanNames});
        cmnd.add("readtemp", 7, helpReadtemp, "iiii", new CmndProcess.Lookup[0]);
        cmnd.add("readvdd", 8, helpReadvdd, "iiii", new CmndProcess.Lookup[0]);
        cmnd.add("readtherm", 30, helpReadtherm, "iiii", new CmndProcess.Lookup[0]);
        cmnd.add("showregs", 10, helpShowregs, "", new CmndProcess.Lookup[0]);
        cmnd.add("readreg", 4, helpReadreg, "I", new CmndProcess.Lookup[0]);
        cmnd.add("writereg", 5, helpWritereg, "II", new CmndProcess.Lookup[0]);
        cmnd.add("showstatus", 29, helpShowstatus, "", new CmndProcess.Lookup[0]);
        cmnd.add("setconv", 11, helpSetconv, "j", new CmndProcess.Lookup[]{cnvModeNames});
        cmnd.add("showconv", 12, helpShowconv, "", new CmndProcess.Lookup[0]);
        cmnd.add("setrate", 13, helpSetrate, "j", new CmndProcess.Lookup[]{rateNames});
        cmnd.add("showrate", 14, helpShowrate, "", new CmndProcess.Lookup[0]);
        cmnd.add("setclock", 15, helpSetclock, "j", new CmndProcess.Lookup[]{clockNames});
        cmnd.add("showclock", 16, helpShowclock, "", new CmndProcess.Lookup[0]);
        cmnd.add("setgain", 17, helpSetgain, "j", new CmndProcess.Lookup[]{gainNames});
        cmnd.add("showgain", 18, helpShowgain, "", new CmndProcess.Lookup[0]);
        cmnd.add("setrefsel", 19, helpSetrefsel, "j", new CmndProcess.Lookup[]{refsNames});
        cmnd.add("showrefsel", 20, helpShowrefsel, "", new CmndProcess.Lookup[0]);
        cmnd.add("setrefdet", 21, helpSetrefdet, "K", new CmndProcess.Lookup[]{onOffNames});
        cmnd.add("showrefdet", 22, helpShowrefdet, "", new CmndProcess.Lookup[0]);
        cmnd.add("setbuff", 23, helpSetbuff, "K", new CmndProcess.Lookup[]{onOffNames});
        cmnd.add("showbuff", 24, helpShowbuff, "", new CmndProcess.Lookup[0]);
        cmnd.add("setunipol", 25, helpSetunipol, "K", new CmndProcess.Lookup[]{onOffNames});
        cmnd.add("showunipol", 26, helpShowunipol, "", new CmndProcess.Lookup[0]);
        cmnd.add("setswitch", 27, helpSetswitch, "K", new CmndProcess.Lookup[]{onOffNames});
        cmnd.add("showswitch", 28, helpShowswitch, "", new CmndProcess.Lookup[0]);
        cmnd.add("readmem", 0, helpReadmem, "IIf", new CmndProcess.Lookup[0]);
        cmnd.add("writemem", 1, helpWritemem, "Issssssss", new CmndProcess.Lookup[0]);
        cmnd.add("reset", 3, helpReset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("load", 2, helpLoad, "si", new CmndProcess.Lookup[0]);
        out = new ConsOut();
        regName = new String[]{"STAT", "MODE", "CONF", "DATA", " ID ", " IO ", "OFFS", "FSCL"};
        regDesc0 = new String[]{"| ~RDY |  ERR |NOXREF|  --  | 7794 | CHAN2| CHAN1| CHAN0|", "| MOD2 | MOD1 | MOD0 |  PSW |  --  |  --  |AMPCOM|  --  |", "|VBIAS1|VBIAS0|BRNOUT|UNIPOL| BOOST| GAIN2| GAIN1| GAIN0|", "", "", "|  --  |DIOENA|IODAT2|IODAT1|CSDIR1|CSDIR0|CSENA1|CSENA0|", "", ""};
        regDesc1 = new String[]{"", "| CLK1 | CLK0 |  --  |CHPDIS| FRS3 | FRS2 | FRS1 | FRS0 |", "|RFSEL1|RFSEL0|REFDET|BUFFRD| CHAN3| CHAN2| CHAN1| CHAN0|", "", "", "", "", ""};
    }

    public TestAd7794(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) {
        int index = args.length >= 1 ? Integer.decode(args[0]) : 0;
        new TestAd7794(args.length >= 2).run(index);
    }

    public void run(int index) {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            this.ad = new Ad7794Eval(index);
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 9: {
                    this.procInit(found, args);
                    break;
                }
                case 29: {
                    this.procShowStatus(found, args);
                    break;
                }
                case 11: {
                    this.procSetConv(found, args);
                    break;
                }
                case 12: {
                    this.procShowConv(found, args);
                    break;
                }
                case 13: {
                    this.procSetRate(found, args);
                    break;
                }
                case 14: {
                    this.procShowRate(found, args);
                    break;
                }
                case 15: {
                    this.procSetClock(found, args);
                    break;
                }
                case 16: {
                    this.procShowClock(found, args);
                    break;
                }
                case 17: {
                    this.procSetGain(found, args);
                    break;
                }
                case 18: {
                    this.procShowGain(found, args);
                    break;
                }
                case 19: {
                    this.procSetRefsel(found, args);
                    break;
                }
                case 20: {
                    this.procShowRefsel(found, args);
                    break;
                }
                case 21: {
                    this.procSetRefdet(found, args);
                    break;
                }
                case 22: {
                    this.procShowRefdet(found, args);
                    break;
                }
                case 23: {
                    this.procSetBuff(found, args);
                    break;
                }
                case 24: {
                    this.procShowBuff(found, args);
                    break;
                }
                case 25: {
                    this.procSetUnipol(found, args);
                    break;
                }
                case 26: {
                    this.procShowUnipol(found, args);
                    break;
                }
                case 27: {
                    this.procSetSwitch(found, args);
                    break;
                }
                case 28: {
                    this.procShowSwitch(found, args);
                    break;
                }
                case 6: {
                    this.procReadAdc(found, args);
                    break;
                }
                case 7: {
                    this.procReadTemp(found, args);
                    break;
                }
                case 8: {
                    this.procReadVdd(found, args);
                    break;
                }
                case 30: {
                    this.procReadTherm(found, args);
                    break;
                }
                case 10: {
                    this.procShowRegs(found, args);
                    break;
                }
                case 4: {
                    this.procReadReg(found, args);
                    break;
                }
                case 5: {
                    this.procWriteReg(found, args);
                    break;
                }
                case 0: {
                    this.procReadMem(found, args);
                    break;
                }
                case 1: {
                    this.procWriteMem(found, args);
                    break;
                }
                case 3: {
                    this.procReset(found, args);
                    break;
                }
                case 2: {
                    this.procLoad(found, args);
                    break;
                }
                default: {
                    out.println((Object)"Command not fully implemented");
                    break;
                }
            }
        }
        catch (UsbException e) {
            this.showException((Exception)((Object)e));
        }
        return true;
    }

    private void procInit(int found, Object[] args) throws UsbException {
        this.ad.setupStandard();
    }

    private void procShowStatus(int found, Object[] args) throws UsbException {
        int status = this.ad.getStatus();
        out.format("Status: %sready, %serror, %sextref, %s, chan = %s\n", new Object[]{(status & 0x80) == 0 ? "" : "not ", (status & 0x40) != 0 ? "" : "no ", (status & 0x20) == 0 ? "" : "no ", (status & 8) != 0 ? "AD7794" : "AD7795", chanNames.decode(status & 7)});
    }

    private void procSetConv(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            TestAd7794.showKeywords("conversion mode", cnvModeNames);
            return;
        }
        this.ad.setConvMode((Integer)args[0]);
    }

    private void procShowConv(int found, Object[] args) throws UsbException {
        int mode = this.ad.getConvMode();
        out.format("Conversion mode = %s (%s)\n", new Object[]{mode, cnvModeNames.decode(mode)});
    }

    private void procSetRate(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            TestAd7794.showKeywords("conversion rate", rateNames);
            return;
        }
        this.ad.setConvRate((Integer)args[0]);
    }

    private void procShowRate(int found, Object[] args) throws UsbException {
        int rate = this.ad.getConvRate();
        out.format("Conversion rate = %s (%s)\n", new Object[]{rate, rateNames.decode(rate)});
    }

    private void procSetClock(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            TestAd7794.showKeywords("clock source", clockNames);
            return;
        }
        this.ad.setClockSource((Integer)args[0]);
    }

    private void procShowClock(int found, Object[] args) throws UsbException {
        int clock = this.ad.getClockSource();
        out.format("Clock source = %s (%s)\n", new Object[]{clock, clockNames.decode(clock)});
    }

    private void procSetGain(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            TestAd7794.showKeywords("gain", gainNames);
            return;
        }
        this.ad.setGain((Integer)args[0]);
    }

    private void procShowGain(int found, Object[] args) throws UsbException {
        int gain = this.ad.getGain();
        out.format("ADC gain = %s (%s)\n", new Object[]{gain, gainNames.decode(gain)});
    }

    private void procSetRefsel(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            TestAd7794.showKeywords("reference source", refsNames);
            return;
        }
        this.ad.setRefSelect((Integer)args[0]);
    }

    private void procShowRefsel(int found, Object[] args) throws UsbException {
        int refs = this.ad.getRefSelect();
        out.format("Reference source = %s (%s)\n", new Object[]{refs, refsNames.decode(refs)});
    }

    private void procSetRefdet(int found, Object[] args) throws UsbException {
        this.ad.setRefDetect((Integer)args[0] != 0);
    }

    private void procShowRefdet(int found, Object[] args) throws UsbException {
        out.format("Reference detection is %s\n", new Object[]{TestAd7794.onOff(this.ad.isRefDetect())});
    }

    private void procSetBuff(int found, Object[] args) throws UsbException {
        this.ad.setBuffered((Integer)args[0] != 0);
    }

    private void procShowBuff(int found, Object[] args) throws UsbException {
        out.format("Buffered mode is %s\n", new Object[]{TestAd7794.onOff(this.ad.isBuffered())});
    }

    private void procSetUnipol(int found, Object[] args) throws UsbException {
        this.ad.setUnipolar((Integer)args[0] != 0);
    }

    private void procShowUnipol(int found, Object[] args) throws UsbException {
        out.format("Unipolar mode is %s\n", new Object[]{TestAd7794.onOff(this.ad.isUnipolar())});
    }

    private void procSetSwitch(int found, Object[] args) throws UsbException {
        this.ad.setPowerSwitch((Integer)args[0] != 0);
    }

    private void procShowSwitch(int found, Object[] args) throws UsbException {
        out.format("Power switch is %s\n", new Object[]{TestAd7794.onOff(this.ad.isPowerSwitch())});
    }

    private void procReadAdc(int found, Object[] args) throws UsbException {
        if ((found & 1) == 0) {
            TestAd7794.showKeywords("channel", chanNames);
            return;
        }
        int chan = (Integer)args[0];
        int[] params = TestAd7794.getParams(1, found, args);
        double sum = 0.0;
        double sumsq = 0.0;
        int j = 0;
        while (j < params[1]) {
            double value = this.ad.readAdc(chan, params[0]);
            sum += value;
            sumsq += value * value;
            ++j;
        }
        TestAd7794.showStats("Raw " + chanNames.decode(chan), params[1], sum, sumsq);
    }

    private void procReadTemp(int found, Object[] args) throws UsbException {
        int[] params = TestAd7794.getParams(0, found, args);
        double sum = 0.0;
        double sumsq = 0.0;
        int j = 0;
        while (j < params[1]) {
            double value = this.ad.readTemperature(params[0]);
            sum += value;
            sumsq += value * value;
            ++j;
        }
        TestAd7794.showStats("Temperature", params[1], sum, sumsq);
    }

    private void procReadVdd(int found, Object[] args) throws UsbException {
        int[] params = TestAd7794.getParams(0, found, args);
        double sum = 0.0;
        double sumsq = 0.0;
        int j = 0;
        while (j < params[1]) {
            double value = this.ad.readVdd(params[0]);
            sum += value;
            sumsq += value * value;
            ++j;
        }
        TestAd7794.showStats("Voltage", params[1], sum, sumsq);
    }

    private void procReadTherm(int found, Object[] args) throws UsbException {
        this.ad.setupThermistor();
        int[] params = TestAd7794.getParams(0, found, args);
        double sum = 0.0;
        double sumsq = 0.0;
        int j = 0;
        while (j < params[1]) {
            double value = this.ad.readThermistor(params[0]);
            sum += value;
            sumsq += value * value;
            ++j;
        }
        TestAd7794.showStats("Thermistor", params[1], sum, sumsq);
        this.ad.cleanupThermistor();
    }

    private void procShowRegs(int found, Object[] args) throws UsbException {
        int[] regSize = this.ad.getRegSizes();
        int j = 0;
        while (j < 8) {
            int value = this.ad.readRegister(j);
            int size = 2 * regSize[j];
            String fmt = String.format("%%d (%%s): %%s%%0%sx  %%s\n", size);
            out.format(fmt, new Object[]{j, regName[j], "      ".substring(size), value, regDesc0[j]});
            if (!regDesc1[j].equals("")) {
                out.format("                  %s\n", new Object[]{regDesc1[j]});
            }
            ++j;
        }
    }

    private void procReadReg(int found, Object[] args) throws UsbException {
        int regnum = (Integer)args[0];
        String fmt = String.format("Register %%s: %%0%sx\n", 2 * this.ad.getRegSizes()[regnum]);
        out.format(fmt, new Object[]{regnum, this.ad.readRegister(regnum)});
    }

    private void procWriteReg(int found, Object[] args) throws UsbException {
        this.ad.writeRegister((Integer)args[0], (Integer)args[1]);
    }

    private void procReset(int found, Object[] args) throws UsbException {
        this.ad.setReset((Integer)args[0] != 0);
    }

    private void procReadMem(int found, Object[] args) throws UsbException {
        int addr = (Integer)args[0];
        float tmo = 1000.0f * ((found & 4) != 0 ? ((Float)args[2]).floatValue() : 1.0f);
        byte[] data = new byte[((Integer)args[1]).intValue()];
        TestAd7794.dispData(addr, data, this.ad.readMemory(addr, data, (int)tmo));
    }

    private void procWriteMem(int found, Object[] args) throws UsbException {
        this.ad.writeMemory((Integer)args[0], TestAd7794.genData(found & 0x1FE, args));
    }

    private void procLoad(int found, Object[] args) throws UsbException {
        boolean force = false;
        if ((found & 2) != 0 && (Integer)args[1] != 0) {
            force = true;
        }
        if ((found & 1) == 0) {
            this.ad.load(force);
        } else {
            this.ad.load((String)args[0], force);
        }
    }

    private static int[] getParams(int offs, int found, Object[] args) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] params = nArray;
        if ((found & 1 << offs) != 0 && (Integer)args[offs] != 0) {
            params[0] = params[0] | 1;
        }
        if ((found & 1 << ++offs) != 0 && (Integer)args[offs] != 0) {
            params[0] = params[0] | 2;
        }
        if ((found & 1 << ++offs) != 0 && (Integer)args[offs] != 0) {
            params[0] = params[0] | 4;
        }
        if ((found & 1 << ++offs) != 0) {
            params[1] = (Integer)args[offs];
        }
        return params;
    }

    private static void showStats(String name, int count, double sum, double sumsq) {
        double mean = sum / (double)count;
        double sigsq = sumsq / (double)count - mean * mean;
        double sigma = sigsq <= 0.0 ? 0.0 : Math.sqrt(sigsq);
        out.format("%s: mean = %.7g, sigma = %.7g\n", new Object[]{name, mean, sigma});
    }

    private static void dispData(int addr, byte[] data, int count) {
        int j = 0;
        while (j < count) {
            if ((j & 0xF) == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%04x:", new Object[]{addr + j});
            }
            out.format(" %02x", new Object[]{data[j] & 0xFF});
            ++j;
        }
        out.println();
    }

    private static byte[] genData(int found, Object[] args) {
        int k;
        byte[] sData;
        int count = 0;
        int mask = found;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int j = 0;
        while (found != 0) {
            if ((found & 1) != 0) {
                String hex = (String)args[j];
                int leng = hex.length();
                if ((leng & 1) != 0) break;
                sData = new byte[leng / 2];
                try {
                    k = 0;
                    while (k < leng) {
                        String num = hex.substring(k, k + 2);
                        sData[k / 2] = (byte)Integer.parseInt(num, 16);
                        k += 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                count += leng / 2;
                list.add(sData);
                mask ^= 1 << j;
            }
            found >>= 1;
            ++j;
        }
        if (mask != 0) {
            out.println((Object)"Invalid hexadecimal string");
            return null;
        }
        byte[] data = new byte[count];
        int l = 0;
        int j2 = 0;
        while (j2 < list.size()) {
            sData = (byte[])list.get(j2);
            k = 0;
            while (k < sData.length) {
                data[l++] = sData[k];
                ++k;
            }
            ++j2;
        }
        return data;
    }

    private static String onOff(boolean on) {
        return on ? "on" : "off";
    }

    private static void showKeywords(String text, CmndProcess.Lookup kwds) {
        out.format("Valid %s values are:\n", new Object[]{text});
        int j = 0;
        while (j < kwds.count()) {
            out.format("  %s (%s)\n", new Object[]{kwds.name(j), kwds.code(j)});
            ++j;
        }
    }

    private void showException(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        } else {
            out.println((Object)e);
        }
    }
}

