/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import javax.usb.UsbException;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ad.Ad7747Eval;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class TestAd7747
implements CmndProcess.Dispatch {
    private static final int MODE_CONTINUOUS = 256;
    private static final int CMD_READMEM = 0;
    private static final int CMD_WRITEMEM = 1;
    private static final int CMD_LOAD = 2;
    private static final int CMD_RESET = 3;
    private static final int CMD_READREG = 4;
    private static final int CMD_WRITEREG = 5;
    private static final int CMD_READCAP = 6;
    private static final int CMD_READTEMP = 7;
    private static final int CMD_READVOLT = 8;
    private static final int CMD_READ2REG = 9;
    private static final int CMD_READ3REG = 10;
    private static final int CMD_SETCAP = 11;
    private static final int CMD_SHOWCAP = 12;
    private static final int CMD_SETVT = 13;
    private static final int CMD_SHOWVT = 14;
    private static final int CMD_SETCONV = 15;
    private static final int CMD_SHOWCONV = 16;
    private static final int CMD_SETDAC = 17;
    private static final int CMD_SHOWDAC = 18;
    private static final int CMD_INIT = 19;
    private static final int CMD_SHOWREGS = 20;
    private static final int CMD_MONCAP = 21;
    private static final int CMD_MONTEMP = 22;
    private static final int CMD_MONVOLT = 23;
    private static final int CMD_MONSTAT = 24;
    private static final int NUM_CMDS = 25;
    private static final String[] helpInit = new String[]{"Initializes setup registers to standard values", "init"};
    private static final String[] helpSetcap = new String[]{"Set capacitance channel configuration", "setcap [<enable>] [<rate>]", "enable  If non-zero, enable capacitance channel; otherwise disable it", "rate    The encoded capacitance data conversion rate (0 - 7)"};
    private static final String[] helpShowcap = new String[]{"Display capacitance channel configuration", "showcap"};
    private static final String[] helpSetvt = new String[]{"Set voltage/temperature channel configuration", "setvt [<enable>] [<mode>] [<rate>] [<short>] [<extref>]", "enable  If non-zero, enable volt/temp channel; otherwise disable it", "mode    The encoded volt/temp channel mode (0 - 3)", "rate    The encoded volt/temp data conversion rate (0 - 3)", "short   If non-zero, short the input; otherwise open it", "extref  If non-zero, use external ref voltage; otherwise internal"};
    private static final String[] helpShowvt = new String[]{"Display voltage/temperature channel configuration", "showvt"};
    private static final String[] helpSetconv = new String[]{"Set conversion mode", "setconv <value>", "value  The encoded conversion mode (0 - 7)"};
    private static final String[] helpShowconv = new String[]{"Display conversion mode", "showconv"};
    private static final String[] helpSetdac = new String[]{"Set capacitance DAC state and value", "setdac <dac> [<enable>] [<value>]", "dac     If zero, use DAC A; otherwise DAC B", "enable  If non-zero enable the DAC; otherwise disable it", "value   The DAC value"};
    private static final String[] helpShowdac = new String[]{"Display DAC configuration", "showdac"};
    private static final String[] helpReadcap = new String[]{"Read the capacitance sensor and display the value", "readcap [single | cont | none] [immed | wait] [<count>]", "single  Set to single conversion mode each read", "cont    Set to contunuous conversion mode at the start", "none    Don't change the conversion mode (default)", "immed   Don't wait for conversion to complete", "wait    Wait for conversion (default)", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadtemp = new String[]{"Read the internal or external temperature sensor and display the value", "readtemp [int | ext | cint | cext] [single | cont | none] [immed | wait] [<count>]", "int     Read as internal but don't configure (default)", "ext     Read as external but don't configure", "cint    Configure to read the internal sensor", "cext    Configure to read the external sensor", "single  Set to single conversion mode each read", "cont    Set to contunuous conversion mode at the start", "none    Don't change the conversion mode (default)", "immed   Don't wait for conversion to complete", "wait    Wait for conversion (default)", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadvolt = new String[]{"Read the internal or external voltage and display the value", "readvolt [int | ext | cint | cext] [single | cont | none] [immed | wait] [<count>]", "int     Read as internal but don't configure (default)", "ext     Read as external but don't configure", "cint    Configure to read the internal sensor", "cext    Configure to read the external sensor", "single  Set to single conversion mode each read", "cont    Set to contunuous conversion mode at the start", "none    Don't change the conversion mode (default)", "immed   Don't wait for conversion to complete", "wait    Wait for conversion (default)", "count   The number of reads to average (default 1)"};
    private static final String[] helpMoncap = new String[]{"Continuously monitor the capacitance sensor", "moncap [cont | single]", "cont    Set to contunuous conversion mode at the start (default)", "single  Set to single conversion mode each read"};
    private static final String[] helpMontemp = new String[]{"Continuously monitor a temperature sensor", "montemp [int | ext] [cont | single]", "int     Monitor the internal sensor (default)", "ext     Monitor the external sensor", "cont    Set to contunuous conversion mode at the start (default)", "single  Set to single conversion mode each read"};
    private static final String[] helpMonvolt = new String[]{"Continuously monitor a voltage sensor", "monvolt [int | ext] [cont | single]", "int     Monitor the internal sensor (default)", "ext     Monitor the external sensor", "cont    Set to contunuous conversion mode at the start (default)", "single  Set to single conversion mode each read"};
    private static final String[] helpMonstat = new String[]{"Continuously monitor the status register", "monstat [<count>]", "count   If present, save and analyze this number of samples"};
    private static final String[] helpReadmem = new String[]{"Read data from memory and display it", "readmem <addr> <leng> [<timwout>]", "addr     The address to read from", "leng     The number of bytes to read", "timeout  The timeout value (secs, default 1.0)"};
    private static final String[] helpWritemem = new String[]{"Write data to memory", "writemem <addr> [<data1>]... [<data8>]", "addr   The address to write to", "datan  String of (an even number of) hexadecimal digits to write"};
    private static final String[] helpShowregs = new String[]{"Show formatted display of all registers", "showregs"};
    private static final String[] helpReadreg = new String[]{"Read register(s) and display the contents", "readreg <regnum> [<count>]", "regnum   The number of the first register to read", "count    The number of registers to read (default: 1)"};
    private static final String[] helpWritereg = new String[]{"Write to register(s)", "writereg <regnum> <value1> [<value2>]... [<value8>]", "regnum  The number of the first register to write", "valuen  Values to write to consecutive registers"};
    private static final String[] helpRead2reg = new String[]{"Read two consecutive registers and display the resultant value", "readreg <regnum>", "regnum   The number of the first register to read"};
    private static final String[] helpRead3reg = new String[]{"Read three consecutive registers and display the resultant value", "readreg <regnum>", "regnum   The number of the first register to read"};
    private static final String[] helpReset = new String[]{"Set or clear the RESET state", "reset  <opern>", "opern  If non-zero, RESET is set; if zero, RESET is cleared"};
    private static final String[] helpLoad = new String[]{"Load memory from a file", "load  [<file>] [<force>]", "file   The name of the .hex file to load (default: standard)", "force  If present and non-zero, do the load even if unnecessary"};
    private static final CmndProcess.Lookup capRateNames = new CmndProcess.Lookup(8);
    private static final CmndProcess.Lookup vtRateNames;
    private static final CmndProcess.Lookup vtModeNames;
    private static final CmndProcess.Lookup cnvModeNames;
    private static final CmndProcess.Lookup rdConfNames;
    private static final CmndProcess.Lookup rdModeNames;
    private static final CmndProcess.Lookup rdTypeNames;
    private static final CmndProcess.Lookup monConfNames;
    private static final CmndProcess.Lookup monModeNames;
    private static final CmndProcess.Command cmnd;
    private static final PrintStream out;
    private final CmndProcess proc = new CmndProcess();
    private final boolean debug;
    private ConsoleReader reader;
    private Ad7747Eval ad;
    private boolean monActive;
    private ArrayBlockingQueue<Integer> monConsQueue;
    private static final int[] regSize;
    private static final String[] regName;
    private static final String[] regDesc;

    static {
        capRateNames.add("45.5", 0);
        capRateNames.add("41.9", 1);
        capRateNames.add("25.0", 2);
        capRateNames.add("13.2", 3);
        capRateNames.add("8.1", 4);
        capRateNames.add("6.5", 5);
        capRateNames.add("5.5", 6);
        capRateNames.add("4.6", 7);
        vtRateNames = new CmndProcess.Lookup(4);
        vtRateNames.add("49.8", 0);
        vtRateNames.add("31.2", 1);
        vtRateNames.add("16.1", 2);
        vtRateNames.add("8.2", 3);
        vtModeNames = new CmndProcess.Lookup(4);
        vtModeNames.add("temperature", 0);
        vtModeNames.add("exttemp", 1);
        vtModeNames.add("vdd", 2);
        vtModeNames.add("voltage", 3);
        cnvModeNames = new CmndProcess.Lookup(6);
        cnvModeNames.add("idle", 0);
        cnvModeNames.add("continuous", 1);
        cnvModeNames.add("single", 2);
        cnvModeNames.add("powerdown", 3);
        cnvModeNames.add("offsetcal", 5);
        cnvModeNames.add("gaincal", 6);
        rdConfNames = new CmndProcess.Lookup(4);
        rdConfNames.add("internal", 0);
        rdConfNames.add("external", 2);
        rdConfNames.add("cinternal", 1);
        rdConfNames.add("cexternal", 3);
        rdModeNames = new CmndProcess.Lookup(3);
        rdModeNames.add("none", 0);
        rdModeNames.add("single", 4);
        rdModeNames.add("continuous", 256);
        rdTypeNames = new CmndProcess.Lookup(2);
        rdTypeNames.add("wait", 0);
        rdTypeNames.add("immediate", 8);
        monConfNames = new CmndProcess.Lookup(2);
        monConfNames.add("internal", 0);
        monConfNames.add("external", 2);
        monModeNames = new CmndProcess.Lookup(2);
        monModeNames.add("continuous", 0);
        monModeNames.add("single", 4);
        cmnd = new CmndProcess.Command(25);
        cmnd.add("readcap", 6, helpReadcap, "kki", new CmndProcess.Lookup[]{rdModeNames, rdTypeNames});
        cmnd.add("readtemp", 7, helpReadtemp, "kkki", new CmndProcess.Lookup[]{rdConfNames, rdModeNames, rdTypeNames});
        cmnd.add("readvolt", 8, helpReadvolt, "kkki", new CmndProcess.Lookup[]{rdConfNames, rdModeNames, rdTypeNames});
        cmnd.add("moncap", 21, helpMoncap, "k", new CmndProcess.Lookup[]{rdModeNames});
        cmnd.add("montemp", 22, helpMontemp, "kk", new CmndProcess.Lookup[]{monConfNames, monModeNames});
        cmnd.add("monvolt", 23, helpMonvolt, "kk", new CmndProcess.Lookup[]{monConfNames, monModeNames});
        cmnd.add("monstat", 24, helpMonstat, "i", new CmndProcess.Lookup[0]);
        cmnd.add("readmem", 0, helpReadmem, "IIf", new CmndProcess.Lookup[0]);
        cmnd.add("writemem", 1, helpWritemem, "Issssssss", new CmndProcess.Lookup[0]);
        cmnd.add("showregs", 20, helpShowregs, "", new CmndProcess.Lookup[0]);
        cmnd.add("readreg", 4, helpReadreg, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("writereg", 5, helpWritereg, "Issssssss", new CmndProcess.Lookup[0]);
        cmnd.add("read2reg", 9, helpRead2reg, "I", new CmndProcess.Lookup[0]);
        cmnd.add("read3reg", 10, helpRead3reg, "I", new CmndProcess.Lookup[0]);
        cmnd.add("init", 19, helpInit, "", new CmndProcess.Lookup[0]);
        cmnd.add("setcap", 11, helpSetcap, "ij", new CmndProcess.Lookup[]{capRateNames});
        cmnd.add("setvt", 13, helpSetvt, "ijjii", new CmndProcess.Lookup[]{vtModeNames, vtRateNames});
        cmnd.add("setconv", 15, helpSetconv, "J", new CmndProcess.Lookup[]{cnvModeNames});
        cmnd.add("setdac", 17, helpSetdac, "Iii", new CmndProcess.Lookup[0]);
        cmnd.add("showcap", 12, helpShowcap, "", new CmndProcess.Lookup[0]);
        cmnd.add("showvt", 14, helpShowvt, "", new CmndProcess.Lookup[0]);
        cmnd.add("showconv", 16, helpShowconv, "", new CmndProcess.Lookup[0]);
        cmnd.add("showdac", 18, helpShowdac, "", new CmndProcess.Lookup[0]);
        cmnd.add("reset", 3, helpReset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("load", 2, helpLoad, "si", new CmndProcess.Lookup[0]);
        out = System.out;
        regSize = new int[]{1, 3, 3, 1, 1, 1, 1, 1, 1, 2, 2, 2};
        regName = new String[]{"STAT", "CPDT", "VTDT", "CPSU", "VTSU", "EXSU", "CONF", "DACA", "DACB", "COFF", "CPGN", "VTGN"};
        regDesc = new String[]{"|  --  |  --  |  --  |  --  |  --  | ~RDY |~RDYVT|~RDYCP|", "", "", "|CAPENA|  --  |CAPDIF|  --  |  --  |  --  |  --  |  --  |", "| VTENA|VTMOD1|VTMOD0|EXTREF|  --  |  --  | SHORT| CHOP |", "|  --  |  --  |  --  |  --  |EXCDAC|EXCENA|EXVLV1|EXCLV0|", "| VTFS1| VTFS0|CAPFS2|CAPFS1|CAPFS0| MODE2| MODE1| MODE0|", "|DAENAB|DAVAL6|DAVAL5|DAVAL4|DAVAL3|DAVAL2|DAVAL1|DAVAL0|", "|DBENAB|DBVAL6|DBVAL5|DBVAL4|DBVAL3|DBVAL2|DBVAL1|DBVAL0|", "", "", ""};
    }

    public TestAd7747(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) {
        int index = args.length >= 1 ? Integer.decode(args[0]) : 0;
        new TestAd7747(args.length >= 2).run(index);
        System.exit(0);
    }

    public void run(int index) {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        this.monConsQueue = new ArrayBlockingQueue(1);
        new MonConsThread().start();
        try {
            String line;
            this.ad = new Ad7747Eval(index);
            this.reader = new ConsoleReader();
            while ((line = this.reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 19: {
                    this.procInit(found, args);
                    break;
                }
                case 11: {
                    this.procSetCap(found, args);
                    break;
                }
                case 13: {
                    this.procSetVt(found, args);
                    break;
                }
                case 15: {
                    this.procSetConv(found, args);
                    break;
                }
                case 17: {
                    this.procSetDac(found, args);
                    break;
                }
                case 12: {
                    this.procShowCap(found, args);
                    break;
                }
                case 14: {
                    this.procShowVt(found, args);
                    break;
                }
                case 16: {
                    this.procShowConv(found, args);
                    break;
                }
                case 18: {
                    this.procShowDac(found, args);
                    break;
                }
                case 6: {
                    this.procReadCap(found, args);
                    break;
                }
                case 7: {
                    this.procReadTemp(found, args);
                    break;
                }
                case 8: {
                    this.procReadVolt(found, args);
                    break;
                }
                case 21: {
                    this.procMonCap(found, args);
                    break;
                }
                case 22: {
                    this.procMonTemp(found, args);
                    break;
                }
                case 23: {
                    this.procMonVolt(found, args);
                    break;
                }
                case 24: {
                    this.procMonStat(found, args);
                    break;
                }
                case 20: {
                    this.procShowRegs(found, args);
                    break;
                }
                case 4: {
                    this.procReadReg(found, args);
                    break;
                }
                case 9: {
                    this.procRead2Reg(found, args);
                    break;
                }
                case 10: {
                    this.procRead3Reg(found, args);
                    break;
                }
                case 5: {
                    this.procWriteReg(found, args);
                    break;
                }
                case 3: {
                    this.procReset(found, args);
                    break;
                }
                case 0: {
                    this.procReadMem(found, args);
                    break;
                }
                case 1: {
                    this.procWriteMem(found, args);
                    break;
                }
                case 2: {
                    this.procLoad(found, args);
                    break;
                }
                default: {
                    out.println("Command not fully implemented");
                    break;
                }
            }
        }
        catch (UsbException e) {
            this.showException((Exception)((Object)e));
        }
        return true;
    }

    private void procInit(int found, Object[] args) throws UsbException {
        this.ad.setupStandard();
    }

    private void procSetCap(int found, Object[] args) throws UsbException {
        if ((found & 1) != 0) {
            this.ad.setCapEnabled((Integer)args[0] != 0);
        }
        if ((found & 2) != 0) {
            this.ad.setCapConvRate((Integer)args[1]);
        }
    }

    private void procSetVt(int found, Object[] args) throws UsbException {
        if ((found & 1) != 0) {
            this.ad.setVtEnabled((Integer)args[0] != 0);
        }
        if ((found & 2) != 0) {
            this.ad.setVtMode((Integer)args[1]);
        }
        if ((found & 4) != 0) {
            this.ad.setVtConvRate((Integer)args[2]);
        }
        if ((found & 8) != 0) {
            this.ad.setVtShorted((Integer)args[3] != 0);
        }
        if ((found & 0x10) != 0) {
            this.ad.setExternalRef((Integer)args[4] != 0);
        }
    }

    private void procSetConv(int found, Object[] args) throws UsbException {
        this.ad.setConvMode((Integer)args[0]);
    }

    private void procSetDac(int found, Object[] args) throws UsbException {
        int dac = (Integer)args[0];
        if ((found & 2) != 0) {
            if (dac == 0) {
                this.ad.setDacAEnabled((Integer)args[1] != 0);
            } else {
                this.ad.setDacBEnabled((Integer)args[1] != 0);
            }
        }
        if ((found & 4) != 0) {
            if (dac == 0) {
                this.ad.setDacAValue((Integer)args[2]);
            } else {
                this.ad.setDacBValue((Integer)args[2]);
            }
        }
    }

    private void procShowCap(int found, Object[] args) throws UsbException {
        int rate = this.ad.getCapConvRate();
        out.format("%s, conv. rate = %s (%s Hz)\n", this.ad.isCapEnabled() ? "Enabled" : "Disabled", rate, capRateNames.decode(rate));
    }

    private void procShowVt(int found, Object[] args) throws UsbException {
        int mode = this.ad.getVtMode();
        int rate = this.ad.getVtConvRate();
        out.format("%s, mode = %s (%s), conv. rate = %s (%s Hz)%s%s\n", this.ad.isVtEnabled() ? "Enabled" : "Disabled", mode, vtModeNames.decode(mode), rate, vtRateNames.decode(rate), this.ad.isVtShorted() ? ", shorted" : "", this.ad.isExternalRef() ? ", external ref" : "");
    }

    private void procShowConv(int found, Object[] args) throws UsbException {
        int mode = this.ad.getConvMode();
        out.format("Conversion mode = %s (%s)\n", mode, cnvModeNames.decode(mode));
    }

    private void procShowDac(int found, Object[] args) throws UsbException {
        out.format("DAC A: %s, value = %s; DAC B: %s, value = %s\n", this.ad.isDacAEnabled() ? "Enabled" : "Disabled", this.ad.getDacAValue(), this.ad.isDacBEnabled() ? "Enabled" : "Disabled", this.ad.getDacBValue());
    }

    private void procReadCap(int found, Object[] args) throws UsbException {
        int[] params = TestAd7747.getParams(-1, found, args);
        int optns = params[0];
        int count = params[1];
        double sum = 0.0;
        double sumsq = 0.0;
        long msec = System.currentTimeMillis();
        if ((optns & 0x100) != 0) {
            this.ad.setConvMode(1);
            optns &= 0xFFFFFEFF;
        }
        int j = 0;
        while (j < count) {
            double value = this.ad.readCapacitance(optns);
            sum += value;
            sumsq += value * value;
            ++j;
        }
        msec = System.currentTimeMillis() - msec;
        TestAd7747.showStats("Capacitance", count, sum, sumsq, msec);
    }

    private void procReadTemp(int found, Object[] args) throws UsbException {
        int[] params = TestAd7747.getParams(0, found, args);
        int optns = params[0];
        int count = params[1];
        double sum = 0.0;
        double sumsq = 0.0;
        long msec = System.currentTimeMillis();
        if ((optns & 0x100) != 0) {
            this.ad.setConvMode(1);
            optns &= 0xFFFFFEFF;
        }
        int j = 0;
        while (j < count) {
            double value = this.ad.readTemperature(optns);
            sum += value;
            sumsq += value * value;
            ++j;
        }
        msec = System.currentTimeMillis() - msec;
        TestAd7747.showStats("Temperature", count, sum, sumsq, msec);
    }

    private void procReadVolt(int found, Object[] args) throws UsbException {
        int[] params = TestAd7747.getParams(0, found, args);
        int optns = params[0];
        int count = params[1];
        double sum = 0.0;
        double sumsq = 0.0;
        long msec = System.currentTimeMillis();
        if ((optns & 0x100) != 0) {
            this.ad.setConvMode(1);
            optns &= 0xFFFFFEFF;
        }
        int j = 0;
        while (j < count) {
            double value = this.ad.readVoltage(optns);
            sum += value;
            sumsq += value * value;
            ++j;
        }
        msec = System.currentTimeMillis() - msec;
        TestAd7747.showStats("Voltage", count, sum, sumsq, msec);
    }

    private void procMonCap(int found, Object[] args) throws UsbException {
        int mode;
        int n = mode = (found & 1) == 0 ? 0 : (Integer)args[0];
        if (mode == 0) {
            this.ad.setConvMode(1);
        }
        out.println("Monitoring capacitance, press any key to terminate...");
        this.monActive = true;
        this.monConsQueue.offer(0);
        long time = System.currentTimeMillis();
        float value = this.ad.readCapacitance(mode);
        int count = 1;
        while (this.monActive) {
            out.format("\r  %.6g    ", Float.valueOf(value));
            value = this.ad.readCapacitance(mode);
            ++count;
        }
        double rate = 1000.0 * (double)count / (double)(System.currentTimeMillis() - time);
        out.format("\nRead rate = %.4g Hz, set rate = %s Hz\n", rate, capRateNames.decode(this.ad.getCapConvRate()));
    }

    private void procMonTemp(int found, Object[] args) throws UsbException {
        int mode;
        int conf = (found & 1) == 0 ? 0 : (Integer)args[0];
        this.ad.setVtMode(conf == 0 ? 0 : 1);
        int n = mode = (found & 2) == 0 ? 0 : (Integer)args[1];
        if (mode == 0) {
            this.ad.setConvMode(1);
        }
        mode |= conf;
        out.println("Monitoring temperature, press any key to terminate...");
        this.monActive = true;
        this.monConsQueue.offer(0);
        long time = System.currentTimeMillis();
        float value = this.ad.readTemperature(mode);
        int count = 1;
        while (this.monActive) {
            out.format("\r  %.6g    ", Float.valueOf(value));
            value = this.ad.readTemperature(mode);
            ++count;
        }
        double rate = 1000.0 * (double)count / (double)(System.currentTimeMillis() - time);
        out.format("\nRead rate = %.4g Hz, set rate = %s Hz\n", rate, vtRateNames.decode(this.ad.getVtConvRate()));
    }

    private void procMonVolt(int found, Object[] args) throws UsbException {
        int mode;
        int conf = (found & 1) == 0 ? 0 : (Integer)args[0];
        this.ad.setVtMode(conf == 0 ? 2 : 3);
        int n = mode = (found & 2) == 0 ? 0 : (Integer)args[1];
        if (mode == 0) {
            this.ad.setConvMode(1);
        }
        mode |= conf;
        out.println("Monitoring voltage, press any key to terminate...");
        this.monActive = true;
        this.monConsQueue.offer(0);
        long time = System.currentTimeMillis();
        float value = this.ad.readVoltage(mode);
        int count = 1;
        while (this.monActive) {
            out.format("\r  %.6g    ", Float.valueOf(value));
            value = this.ad.readVoltage(mode);
            ++count;
        }
        double rate = 1000.0 * (double)count / (double)(System.currentTimeMillis() - time);
        out.format("\nRead rate = %.4g Hz, set rate = %s Hz\n", rate, vtRateNames.decode(this.ad.getVtConvRate()));
    }

    private void procMonStat(int found, Object[] args) throws UsbException {
        int count;
        int n = count = (found & 1) == 0 ? 0 : (Integer)args[0];
        if (count < 0) {
            count = 0;
        }
        long[] times = new long[count];
        int[] values = new int[count];
        out.format("Monitoring status, press any key to terminate%s...\n", count == 0 ? "" : " early");
        this.monActive = true;
        this.monConsQueue.offer(0);
        long time0 = System.currentTimeMillis();
        int value = this.ad.getStatus();
        int nValue = 1;
        while (this.monActive) {
            if (count > 0) {
                times[nValue - 1] = System.currentTimeMillis();
                values[nValue - 1] = value;
            }
            out.format("\r  %02x    ", value);
            if (nValue == count) break;
            value = this.ad.getStatus();
            ++nValue;
        }
        double rate = 1000.0 * (double)nValue / (double)(System.currentTimeMillis() - time0);
        out.format("\nRead rate = %.4g Hz\n", rate);
        if (count > 0) {
            out.print("Status register transition times and values:");
            int cValue = -1;
            int nPrint = 0;
            if (!this.monActive) {
                --nValue;
            }
            int j = 0;
            while (j < nValue) {
                value = values[j];
                if (value != cValue) {
                    if ((nPrint & 7) == 0) {
                        out.println();
                    }
                    out.format("%6s%2s", times[j] - time0, value);
                    ++nPrint;
                    cValue = value;
                }
                ++j;
            }
            out.println();
        }
        this.monActive = false;
    }

    private void procShowRegs(int found, Object[] args) throws UsbException {
        int reg = 0;
        int j = 0;
        while (j < regSize.length) {
            int size = regSize[j];
            out.format("%2s (%s): ", reg, regName[j]);
            int k = size;
            while (k < 3) {
                out.print("  ");
                ++k;
            }
            k = 0;
            while (k < size) {
                out.format("%02x", this.ad.readRegister(reg++));
                ++k;
            }
            out.println("  " + regDesc[j]);
            ++j;
        }
    }

    private void procReadReg(int found, Object[] args) throws UsbException {
        int regnum = (Integer)args[0];
        if ((found & 2) != 0) {
            byte[] data = new byte[((Integer)args[1]).intValue()];
            TestAd7747.dispRegs(regnum, data, this.ad.readRegister(regnum, data));
        } else {
            out.format("%02x: %02x\n", regnum, this.ad.readRegister(regnum));
        }
    }

    private void procRead2Reg(int found, Object[] args) throws UsbException {
        out.format("Value = %d (0x%1$04x)\n", this.ad.readRegister2((Integer)args[0]));
    }

    private void procRead3Reg(int found, Object[] args) throws UsbException {
        out.format("Value = %d (0x%1$04x)\n", this.ad.readRegister3((Integer)args[0]));
    }

    private void procWriteReg(int found, Object[] args) throws UsbException {
        int regnum = (Integer)args[0];
        int count = 0;
        int value = -1;
        int j = 1;
        while (j <= 8) {
            String number;
            if ((found & 1 << j) != 0 && (count += ((number = (String)args[j]).length() + 1) / 2) == 1) {
                try {
                    value = Integer.parseInt(number, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    out.println("Invalid hexadecimal string");
                }
            }
            ++j;
        }
        if (count == 1) {
            if (value == -1) {
                return;
            }
            this.ad.writeRegister(regnum, value);
        } else {
            byte[] data = TestAd7747.genData(found & 0x1FE, args);
            this.ad.writeMemory((Integer)args[0], data);
        }
    }

    private void procReset(int found, Object[] args) throws UsbException {
        this.ad.setReset((Integer)args[0] != 0);
    }

    private void procReadMem(int found, Object[] args) throws UsbException {
        int addr = (Integer)args[0];
        float tmo = 1000.0f * ((found & 4) != 0 ? ((Float)args[2]).floatValue() : 1.0f);
        byte[] data = new byte[((Integer)args[1]).intValue()];
        TestAd7747.dispData(addr, data, this.ad.readMemory(addr, data, (int)tmo));
    }

    private void procWriteMem(int found, Object[] args) throws UsbException {
        this.ad.writeMemory((Integer)args[0], TestAd7747.genData(found & 0x1FE, args));
    }

    private void procLoad(int found, Object[] args) throws UsbException {
        boolean force = false;
        if ((found & 2) != 0 && (Integer)args[1] != 0) {
            force = true;
        }
        if ((found & 1) == 0) {
            this.ad.load(force);
        } else {
            this.ad.load((String)args[0], force);
        }
    }

    private static int[] getParams(int offs, int found, Object[] args) {
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] params = nArray;
        if ((found & 1 << offs) != 0) {
            params[0] = params[0] | (Integer)args[offs];
        }
        if ((found & 1 << ++offs) != 0) {
            params[0] = params[0] | (Integer)args[offs];
        }
        if ((found & 1 << ++offs) != 0) {
            params[0] = params[0] | (Integer)args[offs];
        }
        if ((found & 1 << ++offs) != 0) {
            params[1] = (Integer)args[offs];
        }
        return params;
    }

    private static void showStats(String name, int count, double sum, double sumsq, long msec) {
        double mean = sum / (double)count;
        double sigsq = sumsq / (double)count - mean * mean;
        double sigma = sigsq <= 0.0 ? 0.0 : Math.sqrt(sigsq);
        double rate = 1000.0 * (double)count / (double)msec;
        out.format("%s: mean = %.7g, sigma = %.7g, rate = %.4g\n", name, mean, sigma, rate);
    }

    private static void dispRegs(int regnum, byte[] data, int count) {
        int j = 0;
        while (j < count) {
            if ((j & 0xF) == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%02x:", regnum + j);
            }
            out.format(" %02x", data[j] & 0xFF);
            ++j;
        }
        out.println();
    }

    private static void dispData(int addr, byte[] data, int count) {
        int j = 0;
        while (j < count) {
            if ((j & 0xF) == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%04x:", addr + j);
            }
            out.format(" %02x", data[j] & 0xFF);
            ++j;
        }
        out.println();
    }

    private static byte[] genData(int found, Object[] args) {
        int k;
        byte[] sData;
        int count = 0;
        int mask = found;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int j = 0;
        while (found != 0) {
            if ((found & 1) != 0) {
                String hex = (String)args[j];
                int leng = hex.length();
                if ((leng & 1) != 0) break;
                sData = new byte[leng / 2];
                try {
                    k = 0;
                    while (k < leng) {
                        String num = hex.substring(k, k + 2);
                        sData[k / 2] = (byte)Integer.parseInt(num, 16);
                        k += 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
                count += leng / 2;
                list.add(sData);
                mask ^= 1 << j;
            }
            found >>= 1;
            ++j;
        }
        if (mask != 0) {
            out.println("Invalid hexadecimal string");
            return null;
        }
        byte[] data = new byte[count];
        int l = 0;
        int j2 = 0;
        while (j2 < list.size()) {
            sData = (byte[])list.get(j2);
            k = 0;
            while (k < sData.length) {
                data[l++] = sData[k];
                ++k;
            }
            ++j2;
        }
        return data;
    }

    private void showException(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        } else {
            out.println(e);
        }
    }

    private static void take(ArrayBlockingQueue queue) {
        while (true) {
            try {
                queue.take();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static void awaitTerminal() {
        while (true) {
            try {
                while (true) {
                    if (System.in.available() > 0) {
                        return;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    private static void clearTerminal() {
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
        }
        catch (IOException iOException) {}
    }

    class MonConsThread
    extends Thread {
        MonConsThread() {
        }

        @Override
        public void run() {
            block0: while (true) {
                TestAd7747.take(TestAd7747.this.monConsQueue);
                while (true) {
                    if (!TestAd7747.this.monActive) continue block0;
                    TestAd7747.awaitTerminal();
                    if (TestAd7747.this.monActive) {
                        TestAd7747.clearTerminal();
                    }
                    TestAd7747.this.monActive = false;
                }
                break;
            }
        }
    }
}

