/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jusb.tools.text;

import javax.usb.UsbDevice;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbPort;
import javax.usb.util.UsbUtil;

public class TextUsbView {
    private static int verbose = 0;

    public static void main(String[] argv) throws Exception {
        UsbHub rootHub = UsbHostManager.getUsbServices().getRootUsbHub();
        int i = 0;
        while (i < argv.length) {
            if ("-v".equals(argv[i]) || "--verbose".equals(argv[i])) {
                ++verbose;
            }
            ++i;
        }
        TextUsbView.displayUsbDevice(rootHub, "");
    }

    protected static void displayUsbDevice(UsbDevice device, String offset) throws Exception {
        TextUsbView.print(device.isUsbHub() ? "UsbHub" : "UsbDevice");
        if (1 < verbose) {
            TextUsbView.print(" " + device.getManufacturerString());
        }
        if (verbose > 0) {
            TextUsbView.print(" " + device.getProductString());
        }
        if (2 < verbose) {
            TextUsbView.print(" " + device.getSerialNumberString());
        }
        TextUsbView.println("");
        if (device.isUsbHub()) {
            UsbHub hub = (UsbHub)device;
            int ports = UsbUtil.unsignedInt(hub.getNumberOfPorts());
            offset = String.valueOf(offset) + "  ";
            int i = 0;
            while (i < ports) {
                UsbPort port = hub.getUsbPort((byte)(i + 1));
                if (port.isUsbDeviceAttached()) {
                    TextUsbView.print(offset);
                    TextUsbView.displayUsbDevice(port.getUsbDevice(), offset);
                } else if (2 < verbose) {
                    TextUsbView.println(String.valueOf(offset) + "UsbPort " + port.getPortNumber());
                }
                ++i;
            }
        }
    }

    protected static void print(String s) {
        System.out.print(s);
    }

    protected static void println(String s) {
        System.out.println(s);
    }
}

