/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.shell.CLIException;
import org.lsst.ccs.shell.InputConverter;
import org.lsst.ccs.shell.Token;
import org.lsst.ccs.shell.TokenException;

public class InputConversionEngine {
    private List<InputConverter> inputConverters = new ArrayList<InputConverter>();

    public void addConverter(InputConverter converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Converter == null");
        }
        this.inputConverters.add(converter);
    }

    public boolean removeConverter(InputConverter converter) {
        return this.inputConverters.remove(converter);
    }

    public Object convertInput(String string, Class aClass) throws Exception {
        for (InputConverter currentConverter : this.inputConverters) {
            Object conversionResult = currentConverter.convertInput(string, aClass);
            if (conversionResult == null) continue;
            if (!aClass.isAssignableFrom(conversionResult.getClass())) {
                throw new CLIException("Registered asg.Cliche converter " + currentConverter + " returns wrong result");
            }
            return conversionResult;
        }
        return InputConversionEngine.convertArgToElementaryType(string, aClass);
    }

    public final Object[] convertToParameters(List<Token> tokens, Class[] paramClasses, boolean isVarArgs) throws TokenException {
        assert (isVarArgs || paramClasses.length == tokens.size() - 1);
        Object[] parameters = new Object[paramClasses.length];
        int i = 0;
        while (i < parameters.length - 1) {
            try {
                parameters[i] = this.convertInput(tokens.get(i + 1).getString(), paramClasses[i]);
            }
            catch (CLIException ex) {
                throw new TokenException(tokens.get(i + 1), ex.getMessage());
            }
            catch (Exception e) {
                throw new TokenException(tokens.get(i + 1), (Throwable)e);
            }
            ++i;
        }
        int lastIndex = paramClasses.length - 1;
        if (isVarArgs) {
            Class varClass = paramClasses[lastIndex];
            assert (varClass.isArray());
            Class<?> elemClass = varClass.getComponentType();
            Object theArray = Array.newInstance(elemClass, tokens.size() - paramClasses.length);
            int i2 = 0;
            while (i2 < Array.getLength(theArray)) {
                try {
                    Array.set(theArray, i2, this.convertInput(tokens.get(lastIndex + 1 + i2).getString(), elemClass));
                }
                catch (CLIException ex) {
                    throw new TokenException(tokens.get(lastIndex + 1 + i2), ex.getMessage());
                }
                catch (Exception e) {
                    throw new TokenException(tokens.get(lastIndex + 1 + i2), (Throwable)e);
                }
                ++i2;
            }
            parameters[lastIndex] = theArray;
        } else if (lastIndex >= 0) {
            try {
                parameters[lastIndex] = this.convertInput(tokens.get(lastIndex + 1).getString(), paramClasses[lastIndex]);
            }
            catch (CLIException ex) {
                throw new TokenException(tokens.get(lastIndex + 1), ex.getMessage());
            }
            catch (Exception e) {
                throw new TokenException(tokens.get(lastIndex + 1), (Throwable)e);
            }
        }
        return parameters;
    }

    private static Object convertArgToElementaryType(String string, Class aClass) throws CLIException {
        if (aClass.equals(String.class) || aClass.isInstance(string)) {
            return string;
        }
        if (aClass.equals(Integer.class) || aClass.equals(Integer.TYPE)) {
            return Integer.parseInt(string);
        }
        if (aClass.equals(Long.class) || aClass.equals(Long.TYPE)) {
            return Long.parseLong(string);
        }
        if (aClass.equals(Double.class) || aClass.equals(Double.TYPE)) {
            return Double.parseDouble(string);
        }
        if (aClass.equals(Float.class) || aClass.equals(Float.TYPE)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (aClass.equals(Boolean.class) || aClass.equals(Boolean.TYPE)) {
            return Boolean.parseBoolean(string);
        }
        try {
            Constructor c = aClass.getConstructor(String.class);
            try {
                return c.newInstance(string);
            }
            catch (Exception ex) {
                throw new CLIException(String.format("Error instantiating class %c using string %s", aClass, string), ex);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CLIException("Can't convert string to " + aClass.getName());
        }
    }

    public void addDeclaredConverters(Object handler) {
        Field[] fields;
        Field[] fieldArray = fields = handler.getClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().startsWith("CLI_INPUT_CONVERTERS") && field.getType().isArray() && InputConverter.class.isAssignableFrom(field.getType().getComponentType())) {
                try {
                    Object convertersArray = field.get(handler);
                    int i = 0;
                    while (i < Array.getLength(convertersArray)) {
                        this.addConverter((InputConverter)Array.get(convertersArray, i));
                        ++i;
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error getting converter from field " + field.getName(), ex);
                }
            }
            ++n2;
        }
    }
}

