/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import javax.usb.UsbException;
import org.lsst.ccs.drivers.ad.Cypress;
import org.lsst.ccs.drivers.usb.UsbComm;

public abstract class SpiBus
extends Cypress {
    private static final int READ_TIMEOUT = 1000;
    private static final int RQST_SPI = 218;
    private static final String STD_LOAD_FILE = "/Icv_spi.hex";
    private int rdyTimeout = 0;

    public SpiBus(UsbComm com) throws UsbException {
        super(com);
    }

    void initialize() throws UsbException {
        this.load(false);
    }

    public abstract int commReg(int var1, boolean var2);

    public void setRdyTimeout(int period) {
        this.rdyTimeout = period;
    }

    public int getRdyTimeout(int period) {
        return this.rdyTimeout;
    }

    public int readRegister(int regnum, int size) throws UsbException {
        byte[] data = new byte[size + 1];
        this.com.read(192, 218, this.commReg(regnum, true), this.rdyTimeout, data, 1000);
        int value = 0;
        int j = 1;
        while (j <= size) {
            value = value << 8 | data[j] & 0xFF;
            ++j;
        }
        return value;
    }

    public void writeRegister(int regnum, int size, int value) throws UsbException {
        byte[] data = new byte[size + 1];
        data[0] = (byte)this.commReg(regnum, false);
        int j = 0;
        while (j < size) {
            data[size - j] = (byte)value;
            value >>= 8;
            ++j;
        }
        this.com.write(64, 218, 0, this.rdyTimeout, data);
    }

    public void updateRegister(int regnum, int size, int mask, int value) throws UsbException {
        int data = this.readRegister(regnum, size);
        this.writeRegister(regnum, size, data & ~mask | value & mask);
    }

    public void load(boolean force) throws UsbException {
        this.load(STD_LOAD_FILE, force);
    }
}

