/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import javax.usb.UsbException;
import org.lsst.ccs.drivers.ad.AdException;
import org.lsst.ccs.drivers.ad.SpiBus;
import org.lsst.ccs.drivers.usb.UsbComm;

public class Ad7794Eval
extends SpiBus {
    public static final int STATUS_REG = 0;
    public static final int MODE_REG = 1;
    public static final int CONFIG_REG = 2;
    public static final int DATA_REG = 3;
    public static final int ID_REG = 4;
    public static final int IO_REG = 5;
    public static final int OFFSET_REG = 6;
    public static final int SCALE_REG = 7;
    public static final int COM_READ = 64;
    public static final int COM_ADDRESS_M = 56;
    public static final int COM_ADDRESS_V = 3;
    public static final int COM_CONT_READ = 4;
    public static final int STS_READY = 128;
    public static final int STS_ERROR = 64;
    public static final int STS_NOXREF = 32;
    public static final int STS_AD7794 = 8;
    public static final int STS_CHANNEL_M = 7;
    public static final int STS_CHANNEL_V = 0;
    public static final int MOD_MODE_M = 57344;
    public static final int MOD_MODE_V = 13;
    public static final int MODE_CONT = 0;
    public static final int MODE_SINGLE = 1;
    public static final int MODE_IDLE = 2;
    public static final int MODE_PWR_DOWN = 3;
    public static final int MODE_INT_Z_CAL = 4;
    public static final int MODE_INT_F_CAL = 5;
    public static final int MODE_SYS_Z_CAL = 6;
    public static final int MODE_SYS_F_CAL = 7;
    public static final int MOD_PSW = 4096;
    public static final int MOD_AMP_CM = 512;
    public static final int MOD_CLOCK_M = 192;
    public static final int MOD_CLOCK_V = 6;
    public static final int CLOCK_INT = 0;
    public static final int CLOCK_INT_AVL = 1;
    public static final int CLOCK_EXT = 2;
    public static final int CLOCK_EXT_HALF = 3;
    public static final int MOD_CHOP_DIS = 16;
    public static final int MOD_FRS_M = 15;
    public static final int MOD_FRS_V = 0;
    public static final int FRS_RATE_470 = 1;
    public static final int FRS_RATE_242 = 2;
    public static final int FRS_RATE_123 = 3;
    public static final int FRS_RATE_62 = 4;
    public static final int FRS_RATE_50 = 5;
    public static final int FRS_RATE_39 = 6;
    public static final int FRS_RATE_33 = 7;
    public static final int FRS_RATE_19 = 8;
    public static final int FRS_RATE_17 = 9;
    public static final int FRS_RATE_16 = 10;
    public static final int FRS_RATE_12 = 11;
    public static final int FRS_RATE_10 = 12;
    public static final int FRS_RATE_8 = 13;
    public static final int FRS_RATE_6 = 14;
    public static final int FRS_RATE_4 = 15;
    public static final int MOD_STANDARD = 10;
    public static final int CFG_VBIAS_M = 49152;
    public static final int CFG_VBIAS_V = 14;
    public static final int VBIAS_OFF = 0;
    public static final int VBIAS_AIN1 = 1;
    public static final int VBIAS_AIN2 = 2;
    public static final int VBIAS_AIN3 = 3;
    public static final int CFG_BURNOUT = 8192;
    public static final int CFG_UNIPOLAR = 4096;
    public static final int CFG_BOOST = 2048;
    public static final int CFG_GAIN_M = 1792;
    public static final int CFG_GAIN_V = 8;
    public static final int GAIN_1 = 0;
    public static final int GAIN_2 = 1;
    public static final int GAIN_4 = 2;
    public static final int GAIN_8 = 3;
    public static final int GAIN_16 = 4;
    public static final int GAIN_32 = 5;
    public static final int GAIN_64 = 6;
    public static final int GAIN_128 = 7;
    public static final int RANGE_2500 = 0;
    public static final int RANGE_1250 = 1;
    public static final int RANGE_625 = 2;
    public static final int RANGE_312 = 3;
    public static final int RANGE_156 = 4;
    public static final int RANGE_78 = 5;
    public static final int RANGE_39 = 6;
    public static final int RANGE_19 = 7;
    public static final int CFG_REFSEL_M = 192;
    public static final int CFG_REFSEL_V = 6;
    public static final int REFSEL_EXT1 = 0;
    public static final int REFSEL_EXT2 = 1;
    public static final int REFSEL_INT = 2;
    public static final int CFG_REF_DETECT = 32;
    public static final int CFG_BUFFERED = 16;
    public static final int CFG_CHANNEL_M = 15;
    public static final int CFG_CHANNEL_V = 0;
    public static final int CHAN_AIN1 = 0;
    public static final int CHAN_AIN2 = 1;
    public static final int CHAN_AIN3 = 2;
    public static final int CHAN_AIN4 = 3;
    public static final int CHAN_AIN5 = 4;
    public static final int CHAN_AIN6 = 5;
    public static final int CHAN_TEMP = 6;
    public static final int CHAN_VDD = 7;
    public static final int CHAN_AIN1A = 8;
    public static final int CFG_STANDARD = 1808;
    public static final int IO_DIOENA = 64;
    public static final int IO_IO2DAT = 32;
    public static final int IO_IO1DAT = 16;
    public static final int IO_IEXCDIR_M = 12;
    public static final int IO_IEXCDIR_V = 2;
    public static final int IEXCDIR_12 = 0;
    public static final int IEXCDIR_21 = 1;
    public static final int IEXCDIR_11 = 2;
    public static final int IEXCDIR_22 = 3;
    public static final int IO_IEXCENA_M = 3;
    public static final int IO_IEXCENA_V = 0;
    public static final int IEXCENA_OFF = 0;
    public static final int IEXCENA_10 = 1;
    public static final int IEXCENA_210 = 2;
    public static final int IEXCENA_1000 = 3;
    public static final int IO_STANDARD = 0;
    public static final int OPTN_CONFIG = 1;
    public static final int OPTN_SINGLE = 2;
    public static final int OPTN_IMMED = 4;
    public static final int DIO_ENABLE = 1;
    public static final int DIO_P1DATA = 2;
    public static final int DIO_P2DATA = 4;
    public static final int CAL_INT_ZERO = 0;
    public static final int CAL_INT_FULL = 1;
    public static final int CAL_SYS_ZERO = 2;
    public static final int CAL_SYS_FULL = 3;
    public static final float HALF_RANGE = 8388608.0f;
    public static final float REF_VOLTAGE = 1.17f;
    public static final float INT_TEMP_SCALE = 100.0f;
    public static final float INT_VOLT_SCALE = 6.0f;
    private static final int AD_VID = 1110;
    private static final int AD_7794_PID = 46208;
    private static final double REF_RESISTANCE = 5000.0;
    private static final double BASE_RESISTANCE = 1000.0;
    private static final double CELSIUS_OFFSET = 273.15;
    private static final double BASE_TEMPERATURE = 298.15;
    private static final double THERM_B_COEFF = 3470.0;
    private static final int[] REG_SIZE = new int[]{1, 2, 2, 3, 1, 1, 3, 3};
    private int thermGain;
    private int thermRefsel;
    private int thermSrcdir;
    private int thermSrcena;
    private boolean thermSaved;
    private boolean thermUnipol;

    public Ad7794Eval() throws UsbException {
        this(0);
    }

    public Ad7794Eval(int index) throws UsbException {
        super(new UsbComm());
        if (this.com.findDevice(1110, 46208, index) == null) {
            throw new AdException("Board not found");
        }
        this.initialize();
        int mode = this.readRegister(1);
        this.writeRegister(1, 1);
        if (this.readRegister(1) == 1) {
            this.writeRegister(1, mode);
        }
    }

    @Override
    public int commReg(int regnum, boolean read) {
        return regnum << 3 & 0x38 | (read ? 64 : 0);
    }

    public void setupStandard() throws UsbException {
        this.writeRegister(1, 10);
        this.writeRegister(2, 1808);
        this.writeRegister(5, 0);
    }

    public int[] getRegSizes() {
        return REG_SIZE;
    }

    public int getStatus() throws UsbException {
        return this.readRegister(0);
    }

    public void setChannel(int chan) throws UsbException {
        this.updateRegister(2, 15, chan << 0);
    }

    public int getChannel() throws UsbException {
        return (this.readRegister(2) & 0xF) >> 0;
    }

    public void setConvMode(int mode) throws UsbException {
        this.updateRegister(1, 57344, mode << 13);
    }

    public int getConvMode() throws UsbException {
        return (this.readRegister(1) & 0xE000) >> 13;
    }

    public void setClockSource(int source) throws UsbException {
        this.updateRegister(1, 192, source << 6);
    }

    public int getClockSource() throws UsbException {
        return (this.readRegister(1) & 0xC0) >> 6;
    }

    public void setPowerSwitch(boolean on) throws UsbException {
        this.updateRegister(1, 4096, on ? 4096 : 0);
    }

    public boolean isPowerSwitch() throws UsbException {
        return (this.readRegister(1) & 0x1000) != 0;
    }

    public void setConvRate(int rate) throws UsbException {
        this.updateRegister(1, 15, rate << 0);
    }

    public int getConvRate() throws UsbException {
        return (this.readRegister(1) & 0xF) >> 0;
    }

    public void setUnipolar(boolean enable) throws UsbException {
        this.updateRegister(2, 4096, enable ? 4096 : 0);
    }

    public boolean isUnipolar() throws UsbException {
        return (this.readRegister(2) & 0x1000) != 0;
    }

    public void setBuffered(boolean enable) throws UsbException {
        this.updateRegister(2, 16, enable ? 16 : 0);
    }

    public boolean isBuffered() throws UsbException {
        return (this.readRegister(2) & 0x10) != 0;
    }

    public void setRefDetect(boolean enable) throws UsbException {
        this.updateRegister(2, 32, enable ? 32 : 0);
    }

    public boolean isRefDetect() throws UsbException {
        return (this.readRegister(2) & 0x20) != 0;
    }

    public void setRefSelect(int mode) throws UsbException {
        this.updateRegister(2, 192, mode << 6);
    }

    public int getRefSelect() throws UsbException {
        return (this.readRegister(2) & 0xC0) >> 6;
    }

    public void setGain(int gain) throws UsbException {
        this.updateRegister(2, 1792, gain << 8);
    }

    public int getGain() throws UsbException {
        return (this.readRegister(2) & 0x700) >> 8;
    }

    public void setDio(int value) throws UsbException {
        int mask = ((value & 1) != 0 ? 64 : 0) | ((value & 2) != 0 ? 16 : 0) | ((value & 4) != 0 ? 32 : 0);
        this.updateRegister(5, 112, mask);
    }

    public int getDio() throws UsbException {
        int mask = this.readRegister(5) & 0x70;
        return ((mask & 0x40) != 0 ? 1 : 0) | ((mask & 0x10) != 0 ? 2 : 0) | ((mask & 0x20) != 0 ? 4 : 0);
    }

    public void setSourceDirection(int dirn) throws UsbException {
        this.updateRegister(5, 12, dirn << 2);
    }

    public int getSourceDirection() throws UsbException {
        return (this.readRegister(5) & 0xC) >> 2;
    }

    public void setSourceEnable(int enab) throws UsbException {
        this.updateRegister(5, 3, enab << 0);
    }

    public int getSourceEnable() throws UsbException {
        return (this.readRegister(5) & 3) >> 0;
    }

    public int readAdc(int chan, int optns) throws UsbException {
        this.updateRegister(2, 15, chan << 0);
        if ((optns & 1) != 0) {
            int mode = (optns & 2) != 0 ? 1 : 0;
            this.updateRegister(1, 57344, mode << 13);
        }
        if ((optns & 4) == 0) {
            this.waitReady();
        }
        return this.readRegister(3);
    }

    public float readTemperature(int optns) throws UsbException {
        return ((float)this.readAdc(6, optns) / 8388608.0f - 1.0f) * 1.17f * 100.0f;
    }

    public float readVdd(int optns) throws UsbException {
        return ((float)this.readAdc(7, optns) / 8388608.0f - 1.0f) * 1.17f * 6.0f;
    }

    public float readThermistor(int optns) throws UsbException {
        double r = (double)((float)this.readAdc(3, optns) / 8388608.0f - 1.0f) * 5000.0;
        double t = 1.0 / (0.0033540164346805303 + Math.log(r / 1000.0) / 3470.0) - 273.15;
        return (float)t;
    }

    public void setupThermistor() throws UsbException {
        this.thermGain = this.getGain();
        this.thermUnipol = this.isUnipolar();
        this.thermRefsel = this.getRefSelect();
        this.thermSrcdir = this.getSourceDirection();
        this.thermSrcena = this.getSourceEnable();
        this.thermSaved = true;
        this.setGain(0);
        this.setUnipolar(false);
        this.setRefSelect(0);
        this.setSourceDirection(3);
        this.setSourceEnable(2);
    }

    public void cleanupThermistor() throws UsbException {
        if (this.thermSaved) {
            this.thermSaved = false;
            this.setGain(this.thermGain);
            this.setUnipolar(this.thermUnipol);
            this.setRefSelect(this.thermRefsel);
            this.setSourceDirection(this.thermSrcdir);
            this.setSourceEnable(this.thermSrcena);
        }
    }

    public int calibrate(int chan, int type) throws UsbException {
        this.updateRegister(2, 15, chan << 0);
        this.updateRegister(1, 57344, (type | 4) << 13);
        this.waitReady();
        return this.readRegister((type & 1) == 0 ? 6 : 7);
    }

    public int[] getCalibration(int chan) throws UsbException {
        this.updateRegister(2, 15, chan << 0);
        int[] value = new int[]{this.readRegister(6), this.readRegister(7)};
        return value;
    }

    public int readRegister(int regnum) throws UsbException {
        return this.readRegister(regnum, REG_SIZE[regnum & 7]);
    }

    public void writeRegister(int regnum, int value) throws UsbException {
        this.writeRegister(regnum, REG_SIZE[regnum & 7], value);
    }

    public void updateRegister(int regnum, int mask, int value) throws UsbException {
        this.updateRegister(regnum, REG_SIZE[regnum & 7], mask, value);
    }

    private void waitReady() throws UsbException {
        long start = System.currentTimeMillis();
        boolean ready = false;
        while (!(ready = (this.getStatus() & 0x80) == 0) && System.currentTimeMillis() - start <= 5000L) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!ready) {
            throw new AdException("Conversion timed out");
        }
    }
}

