package org.lsst.ccs.drivers.ad;

import java.io.PrintStream;
import javax.usb.UsbException;

/**
 ***************************************************************************
 **
 **  Program to monitor an Analog Devices 7747 evaluation board
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MonitorAd7747 {

    private final static PrintStream out = System.out;
    private final static String[]
        names = {"capacitance", "temperature", "board voltage",
                 "ext. voltage"};
    private final static Thread exitHook =
        new Thread() {
            @Override
            public void run() {
                out.println();
            }
        };


   /**
    ***************************************************************************
    **
    **  Main program
    **
    ***************************************************************************
    */
    public static void main(String[] args)
    {
        int index = (args.length >= 1) ? Integer.decode(args[0]) : 0;
        int type = 0;
        if (args.length >= 2) {
            if (args[1].equals("t")) type = 1;
            if (args[1].equals("v")) type = 2;
            if (args[1].equals("V")) type = 3;
        }
        int rate = (args.length >= 3) ? Integer.decode(args[2]) : 7;

        try {
            (new MonitorAd7747()).run(index, type, rate);
        }
        catch (UsbException e) {
            System.out.println(e);
        }

        System.exit(0);
    }


   /**
    ***************************************************************************
    **
    **  Run the monitor
    **
    ***************************************************************************
    */
    public void run(int index, int type, int rate) throws UsbException
    {
        Ad7747Eval ad = new Ad7747Eval(index);
        Runtime.getRuntime().addShutdownHook(exitHook);
        out.format("Monitoring %s...\n", names[type]);
        ad.setupStandard();
        if (type == 0) {
            ad.setCapConvRate(rate);
            ad.setCapEnabled(true);
        }
        else {
            ad.setVtConvRate(rate);
            ad.setVtMode(  type == 1 ? Ad7747Eval.VTMD_INT_TEMP
                         : type == 2 ? Ad7747Eval.VTMD_VDD_MON
                                     : Ad7747Eval.VTMD_EXT_VOLT);
            ad.setVtEnabled(true);
        }
        ad.setConvMode(Ad7747Eval.MODE_CONT);

        while (true) {
            float value;
            if (type == 0)
                value = ad.readCapacitance(0);
            else if (type == 1)
                value = ad.readTemperature(0);
            else
                value = ad.readVoltage(type == 3 ? Ad7747Eval.OPTN_EXTERN : 0);
            out.format("\r%-15s", value);
        }
    }

}
