/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.usb.UsbException;
import org.lsst.ccs.drivers.ad.Ad7747Exception;
import org.lsst.ccs.drivers.usb.UsbComm;

public class Ad7747Eval {
    public static final int STATUS_REG = 0;
    public static final int CAP_DATA_REG = 1;
    public static final int VT_DATA_REG = 4;
    public static final int CAP_SETUP_REG = 7;
    public static final int VT_SETUP_REG = 8;
    public static final int EXC_SETUP_REG = 9;
    public static final int CONFIG_REG = 10;
    public static final int CAP_DAC_A_REG = 11;
    public static final int CAP_DAC_B_REG = 12;
    public static final int CAP_OFFSET_REG = 13;
    public static final int CAP_GAIN_REG = 15;
    public static final int VOLT_GAIN_REG = 17;
    public static final int STS_READY = 4;
    public static final int STS_RDYVT = 2;
    public static final int STS_RDYCAP = 1;
    public static final int CPSU_CAPEN = 128;
    public static final int CPSU_CAPDIFF = 32;
    public static final int CPSU_STANDARD = 32;
    public static final int VTSU_VTEN = 128;
    public static final int VTSU_VTMODE_M = 96;
    public static final int VTSU_VTMODE_V = 5;
    public static final int VTMD_INT_TEMP = 0;
    public static final int VTMD_EXT_TEMP = 1;
    public static final int VTMD_VDD_MON = 2;
    public static final int VTMD_EXT_VOLT = 3;
    public static final int VTSU_EXTREF = 16;
    public static final int VTSU_VTSHORT = 2;
    public static final int VTSU_VTCHOP = 1;
    public static final int VTSU_STANDARD = 1;
    public static final int EXSU_EXCDAC = 8;
    public static final int EXSU_EXCEN = 4;
    public static final int EXSU_EXCLVL_M = 3;
    public static final int EXSU_EXCLVL_V = 0;
    public static final int EXCLVL_1_8 = 0;
    public static final int EXCLVL_1_4 = 1;
    public static final int EXCLVL_3_8 = 2;
    public static final int EXCLVL_1_2 = 3;
    public static final int EXSU_STANDARD = 14;
    public static final int CFG_VTFS_M = 192;
    public static final int CFG_VTFS_V = 6;
    public static final int VTFS_RATE_50 = 0;
    public static final int VTFS_RATE_31 = 1;
    public static final int VTFS_RATE_16 = 2;
    public static final int VTFS_RATE_8 = 3;
    public static final int VTFS_TIME_20 = 0;
    public static final int VTFS_TIME_32 = 1;
    public static final int VTFS_TIME_62 = 2;
    public static final int VTFS_TIME_122 = 3;
    public static final int CFG_CAPFS_M = 56;
    public static final int CFG_CAPFS_V = 3;
    public static final int CAPFS_RATE_45 = 0;
    public static final int CAPFS_RATE_42 = 1;
    public static final int CAPFS_RATE_25 = 2;
    public static final int CAPFS_RATE_13 = 3;
    public static final int CAPFS_RATE_8 = 4;
    public static final int CAPFS_RATE_7 = 5;
    public static final int CAPFS_RATE_6 = 6;
    public static final int CAPFS_RATE_5 = 7;
    public static final int CAPFS_TIME_22 = 0;
    public static final int CAPFS_TIME_24 = 1;
    public static final int CAPFS_TIME_40 = 2;
    public static final int CAPFS_TIME_76 = 3;
    public static final int CAPFS_TIME_124 = 4;
    public static final int CAPFS_TIME_154 = 5;
    public static final int CAPFS_TIME_184 = 6;
    public static final int CAPFS_TIME_219 = 7;
    public static final int CFG_MODE_M = 7;
    public static final int CFG_MODE_V = 0;
    public static final int MODE_IDLE = 0;
    public static final int MODE_CONT = 1;
    public static final int MODE_SINGLE = 2;
    public static final int MODE_POWERDOWN = 3;
    public static final int MODE_OFFS_CAL = 5;
    public static final int MODE_GAIN_CAL = 6;
    public static final int DACA_ENABLE = 128;
    public static final int DACA_VALUE_M = 63;
    public static final int DACB_ENABLE = 128;
    public static final int DACB_VALUE_M = 63;
    public static final int OPTN_EXTCFG = 1;
    public static final int OPTN_EXTERN = 2;
    public static final int OPTN_SINGLE = 4;
    public static final int OPTN_IMMED = 8;
    public static final float HALF_RANGE3 = 8388608.0f;
    public static final float REF_VOLTAGE = 1.17f;
    public static final float CAP_FULL_SCALE = 8.192f;
    public static final float TEMP_FULL_SCALE = 4096.0f;
    public static final float INT_VOLT_SCALE = 6.0f;
    private static final int AD_VID = 1110;
    private static final int AD_7747_PID = 46209;
    private static final int READ_TIMEOUT = 1000;
    private static final int RTYP_VENDOR_READ = 192;
    private static final int RTYP_VENDOR_WRITE = 64;
    private static final int RQST_CYPRESS = 160;
    private static final int RQST_I2C = 221;
    private static final int ADDR_I2C_READ = 145;
    private static final int ADDR_I2C_WRITE = 144;
    private static final int CACHE_SIZE = 4096;
    private static final int PACKET_SIZE = 256;
    private static final String STD_LOAD_FILE = "/Icv_usb.hex";
    private static String loadFile;
    private static int[] loadMap;
    private static byte[] loadImage;
    private final UsbComm com = new UsbComm();

    public Ad7747Eval() throws UsbException {
        this(0);
    }

    public Ad7747Eval(int index) throws UsbException {
        if (this.com.findDevice(1110, 46209, index) == null) {
            throw new Ad7747Exception("Board not found");
        }
    }

    public void setupStandard() throws UsbException {
        this.writeRegister(7, 32);
        this.writeRegister(9, 14);
        this.writeRegister(8, 1);
        this.writeRegister(10, 0);
    }

    public int getStatus() throws UsbException {
        return this.readRegister(0);
    }

    public void setCapEnabled(boolean set) throws UsbException {
        this.updateRegister(7, 128, set ? 128 : 0);
    }

    public boolean isCapEnabled() throws UsbException {
        return (this.readRegister(7) & 0x80) != 0;
    }

    public void setVtEnabled(boolean set) throws UsbException {
        this.updateRegister(8, 128, set ? 128 : 0);
    }

    public boolean isVtEnabled() throws UsbException {
        return (this.readRegister(8) & 0x80) != 0;
    }

    public void setVtMode(int mode) throws UsbException {
        this.updateRegister(8, 96, mode << 5);
    }

    public int getVtMode() throws UsbException {
        return (this.readRegister(8) & 0x60) >> 5;
    }

    public void setVtShorted(boolean set) throws UsbException {
        this.updateRegister(8, 2, set ? 2 : 0);
    }

    public boolean isVtShorted() throws UsbException {
        return (this.readRegister(8) & 2) != 0;
    }

    public void setExternalRef(boolean set) throws UsbException {
        this.updateRegister(8, 16, set ? 16 : 0);
    }

    public boolean isExternalRef() throws UsbException {
        return (this.readRegister(8) & 0x10) != 0;
    }

    public void setVtConvRate(int rate) throws UsbException {
        this.updateRegister(10, 192, rate << 6);
    }

    public int getVtConvRate() throws UsbException {
        return (this.readRegister(10) & 0xC0) >> 6;
    }

    public void setCapConvRate(int rate) throws UsbException {
        this.updateRegister(10, 56, rate << 3);
    }

    public int getCapConvRate() throws UsbException {
        return (this.readRegister(10) & 0x38) >> 3;
    }

    public void setConvMode(int mode) throws UsbException {
        this.updateRegister(10, 7, mode);
    }

    public int getConvMode() throws UsbException {
        return this.readRegister(10) & 7;
    }

    public void setDacAEnabled(boolean set) throws UsbException {
        this.updateRegister(11, 128, set ? 128 : 0);
    }

    public boolean isDacAEnabled() throws UsbException {
        return (this.readRegister(11) & 0x80) != 0;
    }

    public void setDacAValue(int value) throws UsbException {
        this.updateRegister(11, 63, value);
    }

    public int getDacAValue() throws UsbException {
        return this.readRegister(11) & 0x3F;
    }

    public void setDacBEnabled(boolean set) throws UsbException {
        this.updateRegister(12, 128, set ? 128 : 0);
    }

    public boolean isDacBEnabled() throws UsbException {
        return (this.readRegister(12) & 0x80) != 0;
    }

    public void setDacBValue(int value) throws UsbException {
        this.updateRegister(12, 63, value);
    }

    public int getDacBValue() throws UsbException {
        return this.readRegister(12) & 0x3F;
    }

    public float readCapacitance(int optns) throws UsbException {
        if ((optns & 4) != 0) {
            this.updateRegister(10, 7, 2);
        }
        if ((optns & 8) == 0) {
            this.waitReady(1);
        }
        return ((float)this.readRegister3(1) / 8388608.0f - 1.0f) * 8.192f;
    }

    public float readTemperature(int optns) throws UsbException {
        if ((optns & 1) != 0) {
            this.updateRegister(8, 96, ((optns & 2) != 0 ? 1 : 0) << 5);
        }
        if ((optns & 4) != 0) {
            this.updateRegister(10, 7, 2);
        }
        if ((optns & 8) == 0) {
            this.waitReady(2);
        }
        return ((float)this.readRegister3(4) / 8388608.0f - 1.0f) * 4096.0f;
    }

    public float readVoltage(int optns) throws UsbException {
        boolean ext;
        boolean bl = ext = (optns & 2) != 0;
        if ((optns & 1) != 0) {
            this.updateRegister(8, 96, (ext ? 3 : 2) << 5);
        }
        if ((optns & 4) != 0) {
            this.updateRegister(10, 7, 2);
        }
        if ((optns & 8) == 0) {
            this.waitReady(2);
        }
        float volts = ((float)this.readRegister3(4) / 8388608.0f - 1.0f) * 1.17f;
        if (!ext) {
            volts *= 6.0f;
        }
        return volts;
    }

    public int readRegister2(int regnum) throws UsbException {
        byte[] data = new byte[2];
        this.readRegister(regnum, data);
        return data[1] & 0xFF | (data[0] & 0xFF) << 8;
    }

    public int readRegister3(int regnum) throws UsbException {
        byte[] data = new byte[3];
        this.readRegister(regnum, data);
        return data[2] & 0xFF | (data[1] & 0xFF) << 8 | (data[0] & 0xFF) << 16;
    }

    public int readRegister(int regnum, byte[] data) throws UsbException {
        return this.com.read(192, 221, 145, regnum, data, 1000);
    }

    public int readRegister(int regnum) throws UsbException {
        byte[] data = new byte[1];
        this.com.read(192, 221, 145, regnum, data, 1000);
        return data[0] & 0xFF;
    }

    public int writeRegister(int regnum, byte[] data) throws UsbException {
        return this.com.write(64, 221, 144, regnum, data);
    }

    public void writeRegister(int regnum, int value) throws UsbException {
        byte[] data = new byte[]{(byte)value};
        this.com.write(64, 221, 144, regnum, data);
    }

    public void updateRegister(int regnum, int mask, int value) throws UsbException {
        byte[] data = new byte[1];
        this.com.read(192, 221, 145, regnum, data, 1000);
        data[0] = (byte)(data[0] & ~mask | value & mask);
        this.com.write(64, 221, 144, regnum, data);
    }

    public void setReset(boolean on) throws UsbException {
        byte[] data = new byte[]{(byte)(on ? 1 : 0)};
        this.com.write(64, 160, 58880, 0, data);
    }

    public int readMemory(int addr, byte[] data, int timeout) throws UsbException {
        return this.com.read(192, 160, addr, 0, data, timeout);
    }

    public int readMemory(int addr, byte[] data, int offs, int leng, int timeout) throws UsbException {
        return this.com.read(192, 160, addr, 0, data, offs, leng, timeout);
    }

    public int writeMemory(int addr, byte[] data) throws UsbException {
        return this.com.write(64, 160, addr, 0, data);
    }

    public int writeMemory(int addr, byte[] data, int offs, int leng) throws UsbException {
        return this.com.write(64, 160, addr, 0, data, offs, leng);
    }

    public void load(boolean force) throws UsbException {
        this.load(STD_LOAD_FILE, force);
    }

    public void load(String name, boolean force) throws UsbException {
        if (!name.equals(loadFile)) {
            this.cacheFile(name);
        }
        if (force || !this.checkCache()) {
            this.loadCache();
        }
    }

    private void cacheFile(String name) throws UsbException {
        int nRead;
        byte[] data;
        InputStream file;
        int fileSize = 0;
        try {
            file = Ad7747Eval.class.getResourceAsStream(name);
            if (file == null) {
                throw new FileNotFoundException(name);
            }
            data = new byte[1024];
            while ((nRead = file.read(data)) >= 0) {
                fileSize += nRead;
            }
            file.close();
        }
        catch (Exception e) {
            throw new Ad7747Exception("Error reading file: " + e);
        }
        try {
            file = Ad7747Eval.class.getResourceAsStream(name);
            if (file == null) {
                throw new FileNotFoundException(name);
            }
            data = new byte[fileSize];
            nRead = file.read(data);
            file.close();
        }
        catch (Exception e) {
            throw new Ad7747Exception("Error reading file: " + e);
        }
        if (nRead != fileSize) {
            throw new Ad7747Exception("Inconsistent data amount read");
        }
        loadFile = null;
        for (int j = 0; j < loadMap.length; ++j) {
            Ad7747Eval.loadMap[j] = 0;
        }
        int posn = 0;
        while (posn >= 0 && posn < fileSize) {
            posn = this.processLine(data, posn);
        }
        if (posn >= 0) {
            throw new Ad7747Exception("EOF record missing");
        }
        if (-posn < fileSize) {
            throw new Ad7747Exception("EOF record not last in file");
        }
        loadFile = name;
    }

    private int processLine(byte[] data, int posn) throws UsbException {
        if (posn + 11 > data.length) {
            throw new Ad7747Exception("Record too short");
        }
        if (data[posn] != 58) {
            throw new Ad7747Exception("Beginning-of-line marker not found");
        }
        int leng = this.decodeHex(data, posn + 1);
        if (posn + 11 + 2 * leng > data.length) {
            throw new Ad7747Exception("Record too short");
        }
        posn += 3;
        int checkSum = leng;
        int addr = 0;
        int type = 0;
        int j = 0;
        while (j < leng + 4) {
            int value = this.decodeHex(data, posn);
            if (j == 0) {
                addr = value << 8;
            } else if (j == 1) {
                addr |= value;
            } else if (j == 2) {
                type = value;
                if (type != 0 && type != 1) {
                    throw new Ad7747Exception("Invalid record type");
                }
            } else if (j < leng + 3) {
                int ad = addr + j - 3;
                if (ad >= 4096) {
                    throw new Ad7747Exception("Address too large");
                }
                Ad7747Eval.loadImage[ad] = (byte)value;
                int n = ad >> 5;
                loadMap[n] = loadMap[n] | 1 << (ad & 0x1F);
            }
            checkSum += value;
            ++j;
            posn += 2;
        }
        if ((checkSum & 0xFF) != 0) {
            throw new Ad7747Exception("Checksum failed");
        }
        if (!(data[posn] != 13 && data[posn] != 10 || data[++posn] != 13 && data[posn] != 10)) {
            ++posn;
        }
        return type == 0 ? posn : -posn;
    }

    private int decodeHex(byte[] data, int offs) throws UsbException {
        try {
            return Integer.parseInt(new String(data, offs, 2), 16);
        }
        catch (Exception e) {
            throw new Ad7747Exception("Invalid hexadecimal number");
        }
    }

    private void loadCache() throws UsbException {
        this.setReset(true);
        int start = 0;
        boolean skip = true;
        for (int j = 0; j < loadImage.length; ++j) {
            boolean set;
            boolean bl = set = (loadMap[j >> 5] & 1 << (j & 0x1F)) != 0;
            if (skip ^ set) continue;
            if (skip) {
                start = j;
            } else {
                int leng = j - start;
                while (leng > 0) {
                    int wLeng = leng > 256 ? 256 : leng;
                    this.writeMemory(start, loadImage, start, wLeng);
                    leng -= wLeng;
                    start += wLeng;
                }
            }
            skip = !skip;
        }
        this.setReset(false);
    }

    private boolean checkCache() throws UsbException {
        this.setReset(true);
        boolean match = true;
        boolean skip = true;
        int start = 0;
        for (int j = 0; j < loadImage.length; ++j) {
            boolean set;
            boolean bl = set = (loadMap[j >> 5] & 1 << (j & 0x1F)) != 0;
            if (skip ^ set) continue;
            if (!skip) {
                int leng = j - start;
                if (leng > 256) {
                    leng = 256;
                }
                byte[] data = new byte[leng];
                this.readMemory(start, data, 1000);
                for (int k = 0; k < leng; ++k) {
                    if (data[k] == loadImage[start + k]) continue;
                    match = false;
                }
                break;
            }
            start = j;
            skip = !skip;
        }
        this.setReset(false);
        return match;
    }

    private void waitReady(int mask) throws UsbException {
        int count;
        for (count = 0; count < 25 && (this.readRegister(0) & mask) != 0; ++count) {
            try {
                Thread.sleep(5L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (count >= 25) {
            throw new Ad7747Exception("Conversion timed out");
        }
    }

    static {
        loadMap = new int[129];
        loadImage = new byte[4097];
    }
}

