/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import java.util.ArrayList;
import javax.usb.UsbException;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.ad.Ad7747Eval;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestAd7747
implements CmndProcess.Dispatch {
    private static final int CMD_READMEM = 0;
    private static final int CMD_WRITEMEM = 1;
    private static final int CMD_LOAD = 2;
    private static final int CMD_RESET = 3;
    private static final int CMD_READREG = 4;
    private static final int CMD_WRITEREG = 5;
    private static final int CMD_READCAP = 6;
    private static final int CMD_READTEMP = 7;
    private static final int CMD_READVOLT = 8;
    private static final int CMD_READ2REG = 9;
    private static final int CMD_READ3REG = 10;
    private static final int CMD_SETCAP = 11;
    private static final int CMD_SHOWCAP = 12;
    private static final int CMD_SETVT = 13;
    private static final int CMD_SHOWVT = 14;
    private static final int CMD_SETCONV = 15;
    private static final int CMD_SHOWCONV = 16;
    private static final int CMD_SETDAC = 17;
    private static final int CMD_SHOWDAC = 18;
    private static final int CMD_INIT = 19;
    private static final int NUM_CMDS = 20;
    private static final String[] helpInit = new String[]{"Initializes setup registers to standard values", "init"};
    private static final String[] helpSetcap = new String[]{"Set capacitance channel configuration", "setcap [<enable>] [<rate>]", "enable  If non-zero, enable capacitance channel; otherwise disable it", "rate    The encoded capacitance data conversion rate (0 - 7)"};
    private static final String[] helpShowcap = new String[]{"Display capacitance channel configuration", "showcap"};
    private static final String[] helpSetvt = new String[]{"Set voltage/temperature channel configuration", "setvt [<enable>] [<mode>] [<rate>] [<short>] [<extref>]", "enable  If non-zero, enable volt/temp channel; otherwise disable it", "mode    The encoded volt/temp channel mode (0 - 3)", "rate    The encoded volt/temp data conversion rate (0 - 3)", "short   If non-zero, short the input; otherwise open it", "extref  If non-zero, use external ref voltage; otherwise internal"};
    private static final String[] helpShowvt = new String[]{"Display voltage/temperature channel configuration", "showvt"};
    private static final String[] helpSetconv = new String[]{"Set conversion mode", "setconv <value>", "value  The encoded conversion mode (0 - 7)"};
    private static final String[] helpShowconv = new String[]{"Display conversion mode", "showconv"};
    private static final String[] helpSetdac = new String[]{"Set capacitance DAC state and value", "setdac <dac> [<enable>] [<value>]", "dac     If zero, use DAC A; otherwise DAC B", "enable  If non-zero enable the DAC; otherwise disable it", "value   The DAC value"};
    private static final String[] helpShowdac = new String[]{"Display DAC configuration", "showdac"};
    private static final String[] helpReadcap = new String[]{"Read the capacitance sensor and display the value", "readcap [<single>] [<immed>] [<count>]", "single  If present and non-zero, perform a single conversion", "immed   If present and non-zero, don't wait for conversion", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadtemp = new String[]{"Read the internal or external temperature sensor and display the value", "readtemp [<extcfg>] [<extern>] [<single>] [<immed>] [<count>]", "extcfg  If present and non-zero, configure which sensor to read", "extern  If present and non-zero, read the external sensor", "single  If present and non-zero, perform a single conversion", "immed   If present and non-zero, don't wait for conversion", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadvolt = new String[]{"Read the internal or external voltage and display the value", "readvolt [<extcfg>] [<extern>] [<single>] [<immed>] [<count>]", "extcfg  If present and non-zero, configure which voltage to read", "extern  If present and non-zero, read the external voltage", "single  If present and non-zero, perform a single conversion", "immed   If present and non-zero, don't wait for conversion", "count   The number of reads to average (default 1)"};
    private static final String[] helpReadmem = new String[]{"Read data from memory and display it", "readmem <addr> <leng> [<timwout>]", "addr     The address to read from", "leng     The number of bytes to read", "timeout  The timeout value (secs, default 1.0)"};
    private static final String[] helpWritemem = new String[]{"Write data to memory", "writemem <addr> [<data1>]... [<data8>]", "addr   The address to write to", "datan  String of (an even number of) hexadecimal digits to write"};
    private static final String[] helpReadreg = new String[]{"Read register(s) and display the contents", "readreg <regnum> [<count>]", "regnum   The number of the first register to read", "count    The number of registers to read (default: 1)"};
    private static final String[] helpWritereg = new String[]{"Write to register(s)", "writereg <regnum> <value1> [<value2>]... [<value8>]", "regnum  The number of the first register to write", "valuen  Values to write to consecutive registers"};
    private static final String[] helpRead2reg = new String[]{"Read two consecutive registers and display the resultant value", "readreg <regnum>", "regnum   The number of the first register to read"};
    private static final String[] helpRead3reg = new String[]{"Read three consecutive registers and display the resultant value", "readreg <regnum>", "regnum   The number of the first register to read"};
    private static final String[] helpReset = new String[]{"Set or clear the RESET state", "reset  <opern>", "opern  If non-zero, RESET is set; if zero, RESET is cleared"};
    private static final String[] helpLoad = new String[]{"Load memory from a file", "load  [<file>] [<force>]", "file   The name of the .hex file to load (default: standard)", "force  If present and non-zero, do the load even if unnecessary"};
    private static final CmndProcess.Lookup capRateNames = new CmndProcess.Lookup(8);
    private static final CmndProcess.Lookup vtRateNames;
    private static final CmndProcess.Lookup vtModeNames;
    private static final CmndProcess.Lookup cnvModeNames;
    private static final CmndProcess.Command cmnd;
    private final Output out = new ConsOut();
    private final CmndProcess proc = new CmndProcess();
    private final boolean debug;
    private Ad7747Eval ad;

    public TestAd7747(boolean debug) {
        this.debug = debug;
    }

    public static void main(String[] args) {
        int index = args.length >= 1 ? Integer.decode(args[0]) : 0;
        new TestAd7747(args.length >= 2).run(index);
        System.exit(0);
    }

    public void run(int index) {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            this.ad = new Ad7747Eval(index);
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
        }
        catch (Exception e) {
            this.out.println((Object)e);
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 19: {
                    this.procInit(found, args);
                    break;
                }
                case 11: {
                    this.procSetCap(found, args);
                    break;
                }
                case 13: {
                    this.procSetVt(found, args);
                    break;
                }
                case 15: {
                    this.procSetConv(found, args);
                    break;
                }
                case 17: {
                    this.procSetDac(found, args);
                    break;
                }
                case 12: {
                    this.procShowCap(found, args);
                    break;
                }
                case 14: {
                    this.procShowVt(found, args);
                    break;
                }
                case 16: {
                    this.procShowConv(found, args);
                    break;
                }
                case 18: {
                    this.procShowDac(found, args);
                    break;
                }
                case 6: {
                    this.procReadCap(found, args);
                    break;
                }
                case 7: {
                    this.procReadTemp(found, args);
                    break;
                }
                case 8: {
                    this.procReadVolt(found, args);
                    break;
                }
                case 4: {
                    this.procReadReg(found, args);
                    break;
                }
                case 9: {
                    this.procRead2Reg(found, args);
                    break;
                }
                case 10: {
                    this.procRead3Reg(found, args);
                    break;
                }
                case 5: {
                    this.procWriteReg(found, args);
                    break;
                }
                case 3: {
                    this.procReset(found, args);
                    break;
                }
                case 0: {
                    this.procReadMem(found, args);
                    break;
                }
                case 1: {
                    this.procWriteMem(found, args);
                    break;
                }
                case 2: {
                    this.procLoad(found, args);
                    break;
                }
                default: {
                    this.out.println((Object)"Command not fully implemented");
                    break;
                }
            }
        }
        catch (UsbException e) {
            this.out.println((Object)e);
        }
        return true;
    }

    private void procInit(int found, Object[] args) throws UsbException {
        this.ad.setupStandard();
    }

    private void procSetCap(int found, Object[] args) throws UsbException {
        if ((found & 1) != 0) {
            this.ad.setCapEnabled((Integer)args[0] != 0);
        }
        if ((found & 2) != 0) {
            this.ad.setCapConvRate((Integer)args[1]);
        }
    }

    private void procSetVt(int found, Object[] args) throws UsbException {
        if ((found & 1) != 0) {
            this.ad.setVtEnabled((Integer)args[0] != 0);
        }
        if ((found & 2) != 0) {
            this.ad.setVtMode((Integer)args[1]);
        }
        if ((found & 4) != 0) {
            this.ad.setVtConvRate((Integer)args[2]);
        }
        if ((found & 8) != 0) {
            this.ad.setVtShorted((Integer)args[3] != 0);
        }
        if ((found & 0x10) != 0) {
            this.ad.setExternalRef((Integer)args[4] != 0);
        }
    }

    private void procSetConv(int found, Object[] args) throws UsbException {
        this.ad.setConvMode((Integer)args[0]);
    }

    private void procSetDac(int found, Object[] args) throws UsbException {
        int dac = (Integer)args[0];
        if ((found & 2) != 0) {
            if (dac == 0) {
                this.ad.setDacAEnabled((Integer)args[1] != 0);
            } else {
                this.ad.setDacBEnabled((Integer)args[1] != 0);
            }
        }
        if ((found & 4) != 0) {
            if (dac == 0) {
                this.ad.setDacAValue((Integer)args[2]);
            } else {
                this.ad.setDacBValue((Integer)args[2]);
            }
        }
    }

    private void procShowCap(int found, Object[] args) throws UsbException {
        int rate = this.ad.getCapConvRate();
        this.out.format("%s, conv. rate = %s (%s Hz)\n", new Object[]{this.ad.isCapEnabled() ? "Enabled" : "Disabled", rate, capRateNames.decode(rate)});
    }

    private void procShowVt(int found, Object[] args) throws UsbException {
        int mode = this.ad.getVtMode();
        int rate = this.ad.getVtConvRate();
        this.out.format("%s, mode = %s (%s), conv. rate = %s (%s Hz)%s%s\n", new Object[]{this.ad.isVtEnabled() ? "Enabled" : "Disabled", mode, vtModeNames.decode(mode), rate, vtRateNames.decode(rate), this.ad.isVtShorted() ? ", shorted" : "", this.ad.isExternalRef() ? ", external ref" : ""});
    }

    private void procShowConv(int found, Object[] args) throws UsbException {
        int mode = this.ad.getConvMode();
        this.out.format("Conversion mode = %s (%s)\n", new Object[]{mode, cnvModeNames.decode(mode)});
    }

    private void procShowDac(int found, Object[] args) throws UsbException {
        this.out.format("DAC A: %s, value = %s; DAC B: %s, value = %s\n", new Object[]{this.ad.isDacAEnabled() ? "Enabled" : "Disabled", this.ad.getDacAValue(), this.ad.isDacBEnabled() ? "Enabled" : "Disabled", this.ad.getDacBValue()});
    }

    private void procReadCap(int found, Object[] args) throws UsbException {
        int optns = 0;
        if ((found & 1) != 0 && (Integer)args[0] != 0) {
            optns |= 4;
        }
        if ((found & 2) != 0 && (Integer)args[1] != 0) {
            optns |= 8;
        }
        int count = (found & 4) != 0 ? (Integer)args[2] : 1;
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.ad.readCapacitance(optns);
            sum += value;
            sumsq += value * value;
        }
        this.showStats("Capacitance", count, sum, sumsq);
    }

    private void procReadTemp(int found, Object[] args) throws UsbException {
        int optns = 0;
        if ((found & 1) != 0 && (Integer)args[0] != 0) {
            optns |= 1;
        }
        if ((found & 2) != 0 && (Integer)args[1] != 0) {
            optns |= 2;
        }
        if ((found & 4) != 0 && (Integer)args[2] != 0) {
            optns |= 4;
        }
        if ((found & 8) != 0 && (Integer)args[3] != 0) {
            optns |= 8;
        }
        int count = (found & 0x10) != 0 ? (Integer)args[4] : 1;
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.ad.readTemperature(optns);
            sum += value;
            sumsq += value * value;
        }
        this.showStats("Temperature", count, sum, sumsq);
    }

    private void procReadVolt(int found, Object[] args) throws UsbException {
        int optns = 0;
        if ((found & 1) != 0 && (Integer)args[0] != 0) {
            optns |= 1;
        }
        if ((found & 2) != 0 && (Integer)args[1] != 0) {
            optns |= 2;
        }
        if ((found & 4) != 0 && (Integer)args[2] != 0) {
            optns |= 4;
        }
        if ((found & 8) != 0 && (Integer)args[3] != 0) {
            optns |= 8;
        }
        int count = (found & 0x10) != 0 ? (Integer)args[4] : 1;
        double sum = 0.0;
        double sumsq = 0.0;
        for (int j = 0; j < count; ++j) {
            double value = this.ad.readVoltage(optns);
            sum += value;
            sumsq += value * value;
        }
        this.showStats("Voltage", count, sum, sumsq);
    }

    private void procReadReg(int found, Object[] args) throws UsbException {
        int regnum = (Integer)args[0];
        if ((found & 2) != 0) {
            byte[] data = new byte[((Integer)args[1]).intValue()];
            this.dispRegs(regnum, data, this.ad.readRegister(regnum, data));
        } else {
            this.out.format("%02x: %02x\n", new Object[]{regnum, this.ad.readRegister(regnum)});
        }
    }

    private void procRead2Reg(int found, Object[] args) throws UsbException {
        this.out.format("Value = %d (0x%1$04x)\n", new Object[]{this.ad.readRegister2((Integer)args[0])});
    }

    private void procRead3Reg(int found, Object[] args) throws UsbException {
        this.out.format("Value = %d (0x%1$04x)\n", new Object[]{this.ad.readRegister3((Integer)args[0])});
    }

    private void procWriteReg(int found, Object[] args) throws UsbException {
        int regnum = (Integer)args[0];
        int count = 0;
        int value = -1;
        for (int j = 1; j <= 8; ++j) {
            String number;
            if ((found & 1 << j) == 0 || (count += ((number = (String)args[j]).length() + 1) / 2) != 1) continue;
            try {
                value = Integer.parseInt(number, 16);
                continue;
            }
            catch (NumberFormatException e) {
                this.out.println((Object)"Invalid hexadecimal string");
            }
        }
        if (count == 1) {
            if (value == -1) {
                return;
            }
            this.ad.writeRegister(regnum, value);
        } else {
            byte[] data = this.genData(found & 0x1FE, args);
            this.ad.writeMemory((Integer)args[0], data);
        }
    }

    private void procReset(int found, Object[] args) throws UsbException {
        this.ad.setReset((Integer)args[0] != 0);
    }

    private void procReadMem(int found, Object[] args) throws UsbException {
        int addr = (Integer)args[0];
        float tmo = 1000.0f * ((found & 4) != 0 ? ((Float)args[2]).floatValue() : 1.0f);
        byte[] data = new byte[((Integer)args[1]).intValue()];
        this.dispData(addr, data, this.ad.readMemory(addr, data, (int)tmo));
    }

    private void procWriteMem(int found, Object[] args) throws UsbException {
        this.ad.writeMemory((Integer)args[0], this.genData(found & 0x1FE, args));
    }

    private void procLoad(int found, Object[] args) throws UsbException {
        boolean force = false;
        if ((found & 2) != 0 && (Integer)args[1] != 0) {
            force = true;
        }
        if ((found & 1) == 0) {
            this.ad.load(force);
        } else {
            this.ad.load((String)args[0], force);
        }
    }

    private void showStats(String name, int count, double sum, double sumsq) {
        double mean = sum / (double)count;
        double sigsq = sumsq / (double)count - mean * mean;
        double sigma = sigsq <= 0.0 ? 0.0 : Math.sqrt(sigsq);
        this.out.format("%s: mean = %.7g, sigma = %.7g\n", new Object[]{name, mean, sigma});
    }

    private void dispRegs(int regnum, byte[] data, int count) {
        for (int j = 0; j < count; ++j) {
            if ((j & 0xF) == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%02x:", new Object[]{regnum + j});
            }
            this.out.format(" %02x", new Object[]{data[j] & 0xFF});
        }
        this.out.println();
    }

    private void dispData(int addr, byte[] data, int count) {
        for (int j = 0; j < count; ++j) {
            if ((j & 0xF) == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%04x:", new Object[]{addr + j});
            }
            this.out.format(" %02x", new Object[]{data[j] & 0xFF});
        }
        this.out.println();
    }

    private byte[] genData(int found, Object[] args) {
        byte[] sData;
        int count = 0;
        int mask = found;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int j = 0;
        while (found != 0) {
            if ((found & 1) != 0) {
                String hex = (String)args[j];
                int leng = hex.length();
                if ((leng & 1) != 0) break;
                sData = new byte[leng / 2];
                try {
                    for (int k = 0; k < leng; k += 2) {
                        String num = hex.substring(k, k + 2);
                        sData[k / 2] = (byte)Integer.parseInt(num, 16);
                    }
                }
                catch (NumberFormatException e) {
                    break;
                }
                count += leng / 2;
                list.add(sData);
                mask ^= 1 << j;
            }
            found >>= 1;
            ++j;
        }
        if (mask != 0) {
            this.out.println((Object)"Invalid hexadecimal string");
            return null;
        }
        byte[] data = new byte[count];
        int l = 0;
        for (int j2 = 0; j2 < list.size(); ++j2) {
            sData = (byte[])list.get(j2);
            for (int k = 0; k < sData.length; ++k) {
                data[l++] = sData[k];
            }
        }
        return data;
    }

    static {
        capRateNames.add("45.5", 0);
        capRateNames.add("41.9", 1);
        capRateNames.add("25.0", 2);
        capRateNames.add("13.2", 3);
        capRateNames.add("8.1", 4);
        capRateNames.add("6.5", 5);
        capRateNames.add("5.5", 6);
        capRateNames.add("4.6", 7);
        vtRateNames = new CmndProcess.Lookup(4);
        vtRateNames.add("49.8", 0);
        vtRateNames.add("31.2", 1);
        vtRateNames.add("16.1", 2);
        vtRateNames.add("8.2", 3);
        vtModeNames = new CmndProcess.Lookup(4);
        vtModeNames.add("temperature", 0);
        vtModeNames.add("exttemp", 1);
        vtModeNames.add("vdd", 2);
        vtModeNames.add("voltage", 3);
        cnvModeNames = new CmndProcess.Lookup(6);
        cnvModeNames.add("idle", 0);
        cnvModeNames.add("continuous", 1);
        cnvModeNames.add("single", 2);
        cnvModeNames.add("powerdown", 3);
        cnvModeNames.add("offsetcal", 5);
        cnvModeNames.add("gaincal", 6);
        cmnd = new CmndProcess.Command(20);
        cmnd.add("readcap", 6, helpReadcap, "iii", new CmndProcess.Lookup[0]);
        cmnd.add("readtemp", 7, helpReadtemp, "iiiii", new CmndProcess.Lookup[0]);
        cmnd.add("readvolt", 8, helpReadvolt, "iiiii", new CmndProcess.Lookup[0]);
        cmnd.add("readmem", 0, helpReadmem, "IIf", new CmndProcess.Lookup[0]);
        cmnd.add("writemem", 1, helpWritemem, "Issssssss", new CmndProcess.Lookup[0]);
        cmnd.add("readreg", 4, helpReadreg, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("writereg", 5, helpWritereg, "Issssssss", new CmndProcess.Lookup[0]);
        cmnd.add("read2reg", 9, helpRead2reg, "I", new CmndProcess.Lookup[0]);
        cmnd.add("read3reg", 10, helpRead3reg, "I", new CmndProcess.Lookup[0]);
        cmnd.add("init", 19, helpInit, "", new CmndProcess.Lookup[0]);
        cmnd.add("setcap", 11, helpSetcap, "ij", new CmndProcess.Lookup[]{capRateNames});
        cmnd.add("setvt", 13, helpSetvt, "ijjii", new CmndProcess.Lookup[]{vtModeNames, vtRateNames});
        cmnd.add("setconv", 15, helpSetconv, "J", new CmndProcess.Lookup[]{cnvModeNames});
        cmnd.add("setdac", 17, helpSetdac, "Iii", new CmndProcess.Lookup[0]);
        cmnd.add("showcap", 12, helpShowcap, "", new CmndProcess.Lookup[0]);
        cmnd.add("showvt", 14, helpShowvt, "", new CmndProcess.Lookup[0]);
        cmnd.add("showconv", 16, helpShowconv, "", new CmndProcess.Lookup[0]);
        cmnd.add("showdac", 18, helpShowdac, "", new CmndProcess.Lookup[0]);
        cmnd.add("reset", 3, helpReset, "I", new CmndProcess.Lookup[0]);
        cmnd.add("load", 2, helpLoad, "si", new CmndProcess.Lookup[0]);
    }
}

