/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ad;

import java.io.PrintStream;
import javax.usb.UsbException;
import org.lsst.ccs.drivers.ad.Ad7747Eval;

public class MonitorAd7747 {
    private static final PrintStream out = System.out;
    private static final String[] names = new String[]{"capacitance", "temperature", "board voltage", "ext. voltage"};
    private static final Thread exitHook = new Thread(){

        @Override
        public void run() {
            out.println();
        }
    };

    public static void main(String[] args) {
        int index = args.length >= 1 ? Integer.decode(args[0]) : 0;
        int type = 0;
        if (args.length >= 2) {
            if (args[1].equals("t")) {
                type = 1;
            }
            if (args[1].equals("v")) {
                type = 2;
            }
            if (args[1].equals("V")) {
                type = 3;
            }
        }
        int rate = args.length >= 3 ? Integer.decode(args[2]) : 7;
        try {
            new MonitorAd7747().run(index, type, rate);
        }
        catch (UsbException e) {
            System.out.println((Object)e);
        }
        System.exit(0);
    }

    public void run(int index, int type, int rate) throws UsbException {
        Ad7747Eval ad = new Ad7747Eval(index);
        Runtime.getRuntime().addShutdownHook(exitHook);
        out.format("Monitoring %s...\n", names[type]);
        ad.setupStandard();
        if (type == 0) {
            ad.setCapConvRate(rate);
            ad.setCapEnabled(true);
        } else {
            ad.setVtConvRate(rate);
            ad.setVtMode(type == 1 ? 0 : (type == 2 ? 2 : 3));
            ad.setVtEnabled(true);
        }
        ad.setConvMode(1);
        while (true) {
            float value = type == 0 ? ad.readCapacitance(0) : (type == 1 ? ad.readTemperature(0) : ad.readVoltage(type == 3 ? 2 : 0));
            out.format("\r%-15s", Float.valueOf(value));
        }
    }
}

