/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.modbus.CRC16;
import org.lsst.ccs.utilities.conv.Convert;

public class Modbus
extends Ascii {
    private static final Map<ConnType, DriverConstants.ConnType> connTypeMap = new HashMap<ConnType, DriverConstants.ConnType>();
    private static final Map<DriverConstants.ConnType, ConnType> revTypeMap;
    static final byte FUNC_READ_COILS = 1;
    static final byte FUNC_READ_DISCRETES = 2;
    static final byte FUNC_READ_REGISTERS = 3;
    static final byte FUNC_READ_INPUTS = 4;
    static final byte FUNC_WRITE_COIL = 5;
    static final byte FUNC_WRITE_REGISTER = 6;
    static final byte FUNC_WRITE_COILS = 15;
    static final byte FUNC_WRITE_REGISTERS = 16;
    static final int OFF_TID = 0;
    static final int OFF_PID = 2;
    static final int OFF_LENGTH = 4;
    static final int OFF_UID = 6;
    static final int OFF_FUNC = 7;
    static final int OFF_RLENG = 8;
    static final int OFF_ERROR = 8;
    static final int OFF_ADDR = 8;
    static final int OFF_RDATA = 9;
    static final int OFF_COUNT = 10;
    static final int OFF_DATA = 12;
    static final int LENG_HEADER = 6;
    static final int LENG_CRC = 2;
    static final int EXCP_ILL_FUNC = 1;
    static final int EXCP_ILL_ADDR = 2;
    static final int EXCP_ILL_VALUE = 3;
    static final int EXCP_SRVR_FAIL = 4;
    static final int EXCP_SRVR_BUSY = 6;
    static final int DEFAULT_PORT_NUMBER = 502;
    static final int DEFAULT_BAUD_RATE = 115200;
    private static final double READ_TIMEOUT = 2.0;
    private static final double PACKET_INTERVAL = 0.1;
    private ConnType connType;
    private int nmbrOff = 1;
    private short tranId = 0;
    private byte[] resp = new byte[1024];

    public synchronized void open(ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(connTypeMap.get((Object)type), ident, parm1, parm2);
        this.connType = type;
        this.setTimeout(2.0);
    }

    public synchronized void open(ConnType type, String ident, int parm1) throws DriverException {
        this.open(type, ident, parm1, 0);
    }

    public void open(ConnType type, String ident) throws DriverException {
        this.open(type, ident, type == ConnType.NET ? 502 : 115200);
    }

    @Override
    public synchronized void open(DriverConstants.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(type, ident, parm1, parm2);
        this.connType = revTypeMap.get(type);
        this.setTimeout(2.0);
    }

    public void setAddressMode(boolean mode) {
        this.nmbrOff = mode ? 0 : 1;
    }

    public boolean isAddressMode() {
        return this.nmbrOff == 0;
    }

    public synchronized byte[] readCoils(short dAddr, short cNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(cNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)1, cmnd);
        int nbyte = this.resp[8] & 0xFF;
        byte[] value = new byte[nbyte];
        System.arraycopy(this.resp, 9, value, 0, nbyte);
        return value;
    }

    public synchronized byte[] readDiscretes(short dAddr, short iNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(iNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)2, cmnd);
        int nbyte = this.resp[8] & 0xFF;
        byte[] value = new byte[nbyte];
        System.arraycopy(this.resp, 9, value, 0, nbyte);
        return value;
    }

    public synchronized short[] readRegisters(short dAddr, short rNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)3, cmnd);
        int nvalue = (this.resp[8] & 0xFF) / 2;
        short[] value = new short[nvalue];
        for (int j = 0; j < nvalue; ++j) {
            value[j] = Convert.bytesToShortBE((byte[])this.resp, (int)(2 * j + 9));
        }
        return value;
    }

    public synchronized short[] readInputs(short dAddr, short rNmbr, short count) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)4, cmnd);
        int nvalue = (this.resp[8] & 0xFF) / 2;
        short[] value = new short[nvalue];
        for (int j = 0; j < nvalue; ++j) {
            value[j] = Convert.bytesToShortBE((byte[])this.resp, (int)(2 * j + 9));
        }
        return value;
    }

    public synchronized void writeRegister(short dAddr, short rNmbr, short value) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)value, (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)6, cmnd);
    }

    public synchronized void writeCoil(short dAddr, short cNmbr, boolean value) throws DriverException {
        byte[] cmnd = new byte[14];
        Convert.shortToBytesBE((short)((short)(cNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)((short)(value ? 65280 : 0)), (byte[])cmnd, (int)10);
        this.send(dAddr, (byte)5, cmnd);
    }

    public synchronized void writeRegisters(short dAddr, short rNmbr, short[] value) throws DriverException {
        int count = value.length;
        byte[] cmnd = new byte[2 * count + 1 + 12 + 2];
        Convert.shortToBytesBE((short)((short)(rNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)((short)count), (byte[])cmnd, (int)10);
        cmnd[12] = (byte)(2 * count);
        for (int j = 0; j < count; ++j) {
            Convert.shortToBytesBE((short)value[j], (byte[])cmnd, (int)(2 * j + 1 + 12));
        }
        this.send(dAddr, (byte)16, cmnd);
    }

    public synchronized void writeCoils(short dAddr, short cNmbr, short count, byte[] value) throws DriverException {
        int nbyte = (count + 7) / 8;
        byte[] cmnd = new byte[nbyte + 1 + 12 + 2];
        Convert.shortToBytesBE((short)((short)(cNmbr - this.nmbrOff)), (byte[])cmnd, (int)8);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)10);
        cmnd[12] = (byte)nbyte;
        System.arraycopy(value, 0, cmnd, 13, nbyte);
        this.send(dAddr, (byte)15, cmnd);
    }

    private int send(short addr, byte func, byte[] cmnd) throws DriverException {
        short s = this.tranId;
        this.tranId = (short)(s + 1);
        Convert.shortToBytesBE((short)s, (byte[])cmnd, (int)0);
        cmnd[6] = (byte)addr;
        cmnd[7] = func;
        this.writeCmnd(cmnd);
        int leng = this.readResp();
        if ((this.resp[6] & 0xFF) != addr) {
            throw new DriverException("Invalid reply address");
        }
        if ((this.resp[7] & 0x7F) != func) {
            throw new DriverException("Invalid reply function code");
        }
        if ((this.resp[7] & 0x80) != 0) {
            String message;
            byte code = this.resp[8];
            switch (code) {
                case 1: {
                    message = "illegal function";
                    break;
                }
                case 2: {
                    message = "illegal data address";
                    break;
                }
                case 3: {
                    message = "illegal data value";
                    break;
                }
                case 4: {
                    message = "server device failure";
                    break;
                }
                case 6: {
                    message = "server device busy";
                    break;
                }
                default: {
                    message = "unknown code (" + code + ")";
                }
            }
            throw new DriverException("Reply exception: " + message);
        }
        return leng;
    }

    private void writeCmnd(byte[] command) throws DriverException {
        if (this.connType == ConnType.NET) {
            Convert.shortToBytesBE((short)0, (byte[])command, (int)0);
            Convert.shortToBytesBE((short)0, (byte[])command, (int)2);
            int leng = command.length - 6 - 2;
            Convert.shortToBytesBE((short)((short)leng), (byte[])command, (int)4);
            this.writeBytes(command, 0, command.length - 2);
        } else if (this.connType == ConnType.SERIAL || this.connType == ConnType.FTDI) {
            int leng = command.length;
            CRC16.generateStd(command, 6, leng - 6 - 2, command, leng - 2);
            this.writeBytes(command, 6, leng - 6);
        } else {
            int leng = command.length - 2;
            command[leng] = Modbus.generateLRC(command, 6, leng - 6);
            this.write(Modbus.bytesToHex(command, 6, leng + 1));
        }
    }

    private int readResp() throws DriverException {
        if (this.connType == ConnType.NET) {
            int posn;
            int rqstLeng = 6;
            for (posn = 0; posn < rqstLeng; posn += this.readBytes(this.resp, posn, rqstLeng - posn)) {
            }
            if ((rqstLeng += Convert.bytesToShortBE((byte[])this.resp, (int)4)) > this.resp.length) {
                this.resp = Arrays.copyOf(this.resp, rqstLeng);
            }
            while (posn < rqstLeng) {
                posn += this.readBytes(this.resp, posn, rqstLeng - posn);
            }
            return posn;
        }
        if (this.connType == ConnType.SERIAL || this.connType == ConnType.FTDI) {
            this.setTimeout(2.0);
            int posn = 6;
            try {
                posn += this.readBytes(this.resp, posn);
                this.setTimeout(0.1);
                while (true) {
                    if (posn < this.resp.length) {
                        posn += this.readBytes(this.resp, posn);
                        continue;
                    }
                    this.resp = Arrays.copyOf(this.resp, 2 * this.resp.length);
                }
            }
            catch (DriverTimeoutException e) {
                if (posn == 6) {
                    throw e;
                }
                if (CRC16.generateStd(this.resp, 6, posn - 6) != 0) {
                    throw new DriverException("Reply checksum error");
                }
                return posn;
            }
        }
        return 0;
    }

    private static byte generateLRC(byte[] data, int offset, int length) {
        int value = 0;
        for (int j = offset; j < offset + length; ++j) {
            value += data[j];
        }
        return (byte)(-value);
    }

    private static String bytesToHex(byte[] data, int offset, int length) {
        StringBuilder str = new StringBuilder(":");
        for (int j = offset; j < offset + length; ++j) {
            str.append(Integer.toHexString(data[j]).toUpperCase());
        }
        return str.toString();
    }

    private static byte hexToBytes(String str, byte[] data, int offset, int length) {
        int value = 0;
        for (int j = offset; j < offset + length; ++j) {
            value += data[j];
        }
        return (byte)(-value);
    }

    static {
        connTypeMap.put(ConnType.NET, DriverConstants.ConnType.NET);
        connTypeMap.put(ConnType.SERIAL, DriverConstants.ConnType.SERIAL);
        connTypeMap.put(ConnType.FTDI, DriverConstants.ConnType.FTDI);
        connTypeMap.put(ConnType.ASERIAL, DriverConstants.ConnType.SERIAL);
        connTypeMap.put(ConnType.AFTDI, DriverConstants.ConnType.FTDI);
        revTypeMap = new HashMap<DriverConstants.ConnType, ConnType>();
        revTypeMap.put(DriverConstants.ConnType.NET, ConnType.NET);
        revTypeMap.put(DriverConstants.ConnType.SERIAL, ConnType.SERIAL);
        revTypeMap.put(DriverConstants.ConnType.FTDI, ConnType.FTDI);
    }

    public static enum ConnType {
        NET,
        SERIAL,
        FTDI,
        ASERIAL,
        AFTDI;

    }
}

