/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.daq.utilities.FitsServiceInterface;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.ITLCCDType;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsServiceTest
extends CcsTestCaseTemplate {
    private Subsystem s;
    private Subsystem publisher;

    @Before
    public void setup() throws Exception {
        this.publisher = new Subsystem("publisher", AgentInfo.AgentType.WORKER);
        this.publisher.startAgent();
        this.s = BootUtils.getSubsystemFromFile((String)"FitsService");
        this.s.startAgent();
        ((AgentStateService)this.s.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS);
        ((AgentStateService)this.publisher.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS);
    }

    @After
    public void tearDown() throws Exception {
        this.s.shutdownAgent();
        this.publisher.shutdownAgent();
    }

    @Test
    public void testConfiguration() throws Exception {
        FitsService fitsService = (FitsService)this.s.getComponentLookup().getComponentByPath("main/fitsService");
        Map specs = fitsService.getHeaderSpecificationMap("scienceConfiguration");
        Assert.assertTrue((String)"primary header ", (boolean)specs.containsKey("primary"));
        Assert.assertTrue((String)"extended header ", (boolean)specs.containsKey("extended"));
        Assert.assertTrue((String)"primary ccd_cond ", (boolean)specs.containsKey("ccd_cond"));
        Assert.assertTrue((String)"primary reb_cond ", (boolean)specs.containsKey("reb_cond"));
        Assert.assertTrue((String)"Make sure the size is 4", (specs.keySet().size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testReplacement() throws Exception {
        this.publisher.getMessagingAccess().getAgentPresenceManager().waitForConnectedAgent(this.s.getName(), 20L, TimeUnit.SECONDS);
        this.s.getMessagingAccess().getAgentPresenceManager().waitForConnectedAgent(this.publisher.getName(), 20L, TimeUnit.SECONDS);
        FitsService fitsService = (FitsService)this.s.getComponentLookup().getComponentByPath("main/fitsService");
        Assert.assertNotNull((Object)fitsService);
        ITLCCDType type = new ITLCCDType();
        Raft raftGeometry = Raft.createRaft((CCDType)type);
        Reb reb0 = (Reb)raftGeometry.getRebs().get(0);
        FitsServiceInterface fitsServiceForReb0 = fitsService.getFitsServiceForReb(reb0);
        Reb reb1 = (Reb)raftGeometry.getRebs().get(1);
        FitsServiceInterface fitsServiceForReb1 = fitsService.getFitsServiceForReb(reb1);
        Assert.assertNotNull((Object)fitsServiceForReb0);
        Assert.assertNotNull((Object)fitsServiceForReb1);
        KeyValueDataList kvd = new KeyValueDataList();
        kvd.addData("RaftName", (Serializable)((Object)"R00"));
        kvd.addData("RebName", (Serializable)((Object)"Reb1"));
        this.publisher.publishSubsystemDataOnStatusBus((KeyValueData)kvd);
        kvd = new KeyValueDataList();
        kvd.addData("R00/Reb1/S01", (Serializable)((Object)"S01Value"));
        this.publisher.publishSubsystemDataOnStatusBus((KeyValueData)kvd);
        kvd = new KeyValueDataList();
        kvd.addData("R00/Reb0/S00", (Serializable)((Object)"S00Value"));
        this.publisher.publishSubsystemDataOnStatusBus((KeyValueData)kvd);
        Thread.sleep(100L);
        MetaDataSet primaryReb0 = fitsServiceForReb0.getFitsHeaderMetadataProvider("R00/Reb1/S00").getPrimaryHeaderMetadata();
        Assert.assertEquals((Object)"R00", (Object)primaryReb0.getValue("publisher/RaftName"));
        Assert.assertEquals((Object)"Reb1", (Object)primaryReb0.getValue("publisher/RebName"));
        Assert.assertEquals((Object)"S00Value", (Object)primaryReb0.getValue("publisher/R00/Reb0/S00"));
        Assert.assertNull((Object)primaryReb0.getValue("S01Value"));
        MetaDataSet primaryReb1 = fitsServiceForReb1.getFitsHeaderMetadataProvider("R00/Reb2/S00").getPrimaryHeaderMetadata();
        Assert.assertEquals((Object)"R00", (Object)primaryReb1.getValue("publisher/RaftName"));
        Assert.assertEquals((Object)"Reb1", (Object)primaryReb1.getValue("publisher/RebName"));
        Assert.assertNotNull((Object)primaryReb1.getValue("publisher/R00/Reb0/S00"));
        Assert.assertNotNull((Object)primaryReb1.getValue("publisher/R00/Reb1/S01"));
        MetaDataSet rebCond = fitsServiceForReb1.getFitsHeaderMetadataProvider("R00/Reb2/S00").getAdditionalExtendedHeaderMetadata("reb_cond");
        Assert.assertEquals((Object)this.s.getName(), (Object)rebCond.getValue("AGENT_NAME"));
    }
}

