/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.imagenaming.service;

import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.ImageNameAssigner;
import org.lsst.ccs.imagenaming.Source;

public class ImageNameService
implements HasLifecycle,
ConfigurationBulkChangeHandler {
    @ConfigurationParameter(isFinal=true)
    private volatile String dbURL;
    @ConfigurationParameter(isFinal=true, name="controller", description="The controller of this image name service (CCS, OCS, etc)")
    private volatile String controllerStr = Controller.CCS.name();
    private Controller controller = Controller.CCS;
    @ConfigurationParameter(isFinal=true, name="source", description="The source of this image name service MainCamera, ComCam, AuxTel, TestStand")
    private volatile String sourceStr;
    private Source source;
    @ConfigurationParameter(isFinal=true, description="The timezone used to assign the date (e.g. UTC)")
    private volatile String timeZoneId = "UTC";
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @ConfigurationParameter(isFinal=true, description="The offset from midnight when the data transition occurs (e.g. 12 hours)")
    private volatile Duration offset = Duration.ofHours(12L);
    private Instant testTime;
    private ImageNameAssigner imageNameAssigner;

    public static ImageNameService testInstance(String dbURL, Controller controller, Source source, String timeZoneId, Duration offset, Instant testTime) {
        ImageNameService imageNameService = new ImageNameService();
        imageNameService.dbURL = dbURL;
        imageNameService.controller = controller;
        imageNameService.source = source;
        imageNameService.timeZoneId = timeZoneId;
        imageNameService.offset = offset;
        imageNameService.testTime = testTime;
        imageNameService.postInit();
        return imageNameService;
    }

    public void postInit() {
        if (this.controller == null || this.dbURL == null || this.source == null) {
            throw new RuntimeException("Invalid configuration for ImageNameService");
        }
        this.checkTimeZoneId(this.timeZoneId);
        this.timeZone = TimeZone.getTimeZone(this.timeZoneId);
        this.imageNameAssigner = new ImageNameAssigner(this.dbURL);
    }

    public void shutdown() {
        try {
            this.imageNameAssigner.close();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error closing database connection for image naming", ex);
        }
    }

    @ConfigurationParameterChanger(propertyName="source")
    public void setSource(String source) {
        this.source = Source.valueOf(source);
        this.sourceStr = source;
    }

    @ConfigurationParameterChanger(propertyName="controller")
    public void setController(String controller) {
        this.controller = Controller.valueOf(controller);
        this.controllerStr = controller;
    }

    public ImageName getImageName() {
        try {
            return this.imageNameAssigner.assignImageName(this.source, this.controller, this.timeZone, this.offset, this.testTime);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error accessing image name database", ex);
        }
    }

    public List<ImageName> getImageNames(int n) {
        try {
            return this.imageNameAssigner.assignImageNames(this.source, this.controller, this.timeZone, this.offset, n, this.testTime);
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error accessing image name database", ex);
        }
    }

    public void setParameterBulk(Map<String, Object> parametersView) {
        if (parametersView.containsKey("timeZoneId")) {
            this.timeZone = TimeZone.getTimeZone(parametersView.get("timeZoneId").toString());
        }
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        if (parametersView.containsKey("timeZoneId")) {
            this.checkTimeZoneId(parametersView.get("timeZoneId").toString());
        }
    }

    private void checkTimeZoneId(String timeZoneId) throws IllegalArgumentException {
        if (!Arrays.asList(TimeZone.getAvailableIDs()).contains(timeZoneId)) {
            throw new IllegalArgumentException("Invalid time zone id " + timeZoneId);
        }
    }
}

