/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.daq.utilities.FitsServiceConfiguration;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.WFCCDType;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsService
implements HasLifecycle,
StatusMessageListener {
    private final Map<String, MetaDataSet> geometryReplacementMetaDataSetMap = new HashMap<String, MetaDataSet>();
    private Reb geometry;
    private String uniqueId = "notSet";
    private static final Logger LOGGER = Logger.getLogger(FitsService.class.getName());
    private final Map<String, Map<String, HeaderKeywordValue>> headerKeywordValuesMap = new HashMap<String, Map<String, HeaderKeywordValue>>();
    private Map<String, HeaderSpecification> headerSpecificationsMap;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private FitsServiceConfiguration config;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService aggregatorService;
    public static final String COMMON_HEADER_NAME = "all";
    private Boolean enableAtStart = null;

    public void start() {
        this.headerSpecificationsMap = this.config.getHeaderSpecificationMap();
        for (String headerName : this.headerSpecificationsMap.keySet()) {
            if (this.headerKeywordValuesMap.containsKey(headerName)) continue;
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        this.headerKeywordValuesMap.put(COMMON_HEADER_NAME, new HashMap());
        if (this.enableAtStart != null) {
            this.setEnabled(this.enableAtStart);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.agent != null) {
            LOGGER.log(Level.INFO, "{0} FitService for Reb {1}", new Object[]{enabled ? "Enabling" : "Disabling", this.geometry.getFullName()});
            if (enabled) {
                this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
            } else {
                this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
            }
        } else {
            this.enableAtStart = enabled;
        }
    }

    protected Reb getGeometry() {
        return this.geometry;
    }

    public void setReb(Reb reb) {
        this.setGeometry(reb);
    }

    public void setGeometry(Reb reb) {
        LOGGER.log(Level.FINE, "Configuring Fits Header for geometry {0}", reb.getUniqueId());
        if (!(reb instanceof Reb)) {
            throw new RuntimeException("A FitsService must be configured for a Reb geometry");
        }
        this.geometry = reb;
        this.uniqueId = this.geometry.getUniqueId();
        this.fillHeaderKeywordMapsForReb(this.geometry);
        String raftName = "";
        if (this.geometry.getRaft() != null) {
            raftName = this.geometry.getRaft().getName();
        }
        String rebName = this.geometry.getName();
        this.geometryReplacementMetaDataSetMap.clear();
        MetaDataSet mds = new MetaDataSet();
        mds.addMetaData("", "RAFT", (Object)raftName);
        mds.addMetaData("", "REB", (Object)rebName);
        LOGGER.log(Level.FINE, "Adding default replacements for REB and RAFT: {0} {1}", new Object[]{mds.getValue("REB"), mds.getValue("RAFT")});
        for (CCD ccd : this.geometry.getCCDs()) {
            String ccdName;
            MetaDataSet ccd_mds = new MetaDataSet();
            ccd_mds.addMetaDataSet(mds);
            String ccdTrending = ccdName = ccd.getName();
            if (ccd.getType() instanceof WFCCDType) {
                ccdTrending = "SW";
            }
            ccd_mds.addMetaData("", "CCD", (Object)ccdName);
            ccd_mds.addMetaData("", "CCD_TRENDING", (Object)ccdTrending);
            this.geometryReplacementMetaDataSetMap.put(ccd.getUniqueId(), ccd_mds);
            LOGGER.log(Level.FINE, "Adding default replacements for CCD: {0}: {1}", new Object[]{ccd.getUniqueId(), ccd_mds.getValue("CCD")});
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        if (d.getDataKey().equals("fitsHeaderKeywordData")) {
            FitsHeaderKeywordData fitsHeaderKeywordData = (FitsHeaderKeywordData)((KeyValueData)d.getObject()).getValue();
            String headerKeywordDataId = fitsHeaderKeywordData.getDataId();
            if (headerKeywordDataId != null && !headerKeywordDataId.isEmpty() && !headerKeywordDataId.startsWith(this.uniqueId)) {
                return;
            }
            for (FitsHeaderKeywordData.HeaderKeywordValue value : fitsHeaderKeywordData.getHeaderKeywordValues()) {
                this.setHeaderKeywordValue(value);
            }
        }
    }

    public Map<String, HeaderSpecification> getHeaderSpecificationMap() {
        return this.headerSpecificationsMap;
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        this.setHeaderKeywordValue(COMMON_HEADER_NAME, headerKeywordName, headerKeywordValue, sticky);
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue(COMMON_HEADER_NAME, headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue(headerName, headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        this.getHeaderKeywordMapForHeader(headerName).put(headerKeywordName, new HeaderKeywordValue(headerKeywordValue, sticky));
    }

    private void setHeaderKeywordValue(FitsHeaderKeywordData.HeaderKeywordValue value) {
        this.setHeaderKeywordValue(value.getHeaderName(), value.getHeaderKeywordName(), value.getHeaderKeywordValue(), value.isSticky());
    }

    private void fillHeaderKeywordMaps(Geometry geometry) {
        if (geometry instanceof Raft) {
            Raft raft = (Raft)geometry;
            for (Reb reb : raft.getRebs()) {
                this.fillHeaderKeywordMapsForReb(reb);
            }
        } else {
            throw new RuntimeException("This class is currently designed to support a single Raft.");
        }
    }

    private void fillHeaderKeywordMapsForReb(Reb reb) {
        for (CCD ccd : reb.getCCDs()) {
            if (this.headerKeywordValuesMap.containsKey(ccd.getUniqueId())) continue;
            this.headerKeywordValuesMap.put(ccd.getUniqueId(), new HashMap());
        }
    }

    private Map<String, HeaderKeywordValue> getHeaderKeywordMapForHeader(String headerName) {
        if (!this.headerKeywordValuesMap.containsKey(headerName)) {
            LOGGER.log(Level.WARNING, "The FitsService is not configured to store data for header {0}", headerName);
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        return this.headerKeywordValuesMap.get(headerName);
    }

    private MetaDataSet buildMetaDataSetForExtension(String extension) {
        Map<String, HeaderKeywordValue> headerKeywordMap = this.getHeaderKeywordMapForHeader(extension);
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        for (String headerKeyword : headerKeywordMap.keySet()) {
            valuesMap.put(headerKeyword, headerKeywordMap.get(headerKeyword).getValue());
        }
        MetaDataSet result = new MetaDataSet();
        result.addMetaDataMap(extension, valuesMap);
        return result;
    }

    public void clearNonStickyHeaderKeywordValues() {
        for (Map<String, HeaderKeywordValue> map : this.headerKeywordValuesMap.values()) {
            this.clearNonStickyHeaderKeywordValuesFromMap(map);
        }
    }

    private void clearNonStickyHeaderKeywordValuesFromMap(Map<String, HeaderKeywordValue> map) {
        Iterator<Map.Entry<String, HeaderKeywordValue>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, HeaderKeywordValue> entry = iter.next();
            if (entry.getValue().isSticky()) continue;
            iter.remove();
        }
    }

    public FitsHeaderMetadataProvider getFitsHeaderMetadataProvider(String source) {
        return new FitsServiceFitsHeaderMetadataProvider(source);
    }

    private MetaDataSet getStatusAggregatorMetaDataSet() {
        MetaDataSet m = new MetaDataSet();
        Map aggrMap = this.aggregatorService.getAllLast();
        m.addMetaDataMap("StatusAggregator", aggrMap);
        return m;
    }

    public static class FitsServiceKeyReplacement {
        private final String match;
        private final String replace;

        public FitsServiceKeyReplacement(String configStr) {
            int index = configStr.indexOf(":");
            this.match = "(?i)" + Pattern.quote(configStr.substring(0, index));
            this.replace = configStr.substring(index + 1);
        }

        public String manipulate(String input) {
            return input.replaceAll(this.match, this.replace);
        }

        public String toString() {
            return this.match + ":" + this.replace;
        }
    }

    private class HeaderKeywordValue {
        private final Object value;
        private final boolean sticky;

        HeaderKeywordValue(Object value, boolean sticky) {
            this.value = value;
            this.sticky = sticky;
        }

        Object getValue() {
            return this.value;
        }

        boolean isSticky() {
            return this.sticky;
        }
    }

    private class FitsServiceFitsHeaderMetadataProvider
    implements FitsHeaderMetadataProvider {
        private final String ccdUniqueId;
        private final Map<String, MetaDataSet> storedMetaDataSets = new HashMap<String, MetaDataSet>();

        private MetaDataSet getMetaDataSet(String key) {
            MetaDataSet result = this.storedMetaDataSets.get(key);
            if (result == null) {
                if (key.equals("statusAggregator")) {
                    result = FitsService.this.getStatusAggregatorMetaDataSet();
                    result.addMetaData("", "AGENT_NAME", (Object)FitsService.this.agent.getName());
                } else {
                    result = key.equals("geometry") ? (MetaDataSet)FitsService.this.geometryReplacementMetaDataSetMap.get(this.ccdUniqueId) : FitsService.this.buildMetaDataSetForExtension(key);
                }
                this.storedMetaDataSets.put(key, result);
            }
            return result;
        }

        public FitsServiceFitsHeaderMetadataProvider(String ccdUniqueId) {
            this.ccdUniqueId = ccdUniqueId;
        }

        public MetaDataSet getAdditionalExtendedHeaderMetadata(String extendedKeyword) {
            MetaDataSet r = FitsService.this.buildMetaDataSetForExtension(extendedKeyword);
            r.addMetaDataSet(this.getMetaDataSet(FitsService.COMMON_HEADER_NAME));
            r.addMetaDataSet(this.getMetaDataSet(this.ccdUniqueId));
            r.addMetaDataSet(this.getMetaDataSet("statusAggregator"));
            r.addMetaDataSet(this.getMetaDataSet("geometry"));
            return r;
        }

        public MetaDataSet getDataExtendedHeaderMetadata(String imageExtensionName) {
            MetaDataSet r = new MetaDataSet();
            r.addMetaDataSet(this.getMetaDataSet(FitsService.COMMON_HEADER_NAME));
            r.addMetaDataSet(this.getMetaDataSet(this.ccdUniqueId));
            r.addMetaDataSet(this.getMetaDataSet("statusAggregator"));
            r.addMetaDataSet(this.getMetaDataSet("geometry"));
            return r;
        }

        public MetaDataSet getPrimaryHeaderMetadata() {
            MetaDataSet r = new MetaDataSet();
            r.addMetaDataSet(this.getMetaDataSet("primary"));
            r.addMetaDataSet(this.getMetaDataSet(FitsService.COMMON_HEADER_NAME));
            r.addMetaDataSet(this.getMetaDataSet(this.ccdUniqueId));
            r.addMetaDataSet(this.getMetaDataSet("statusAggregator"));
            r.addMetaDataSet(this.getMetaDataSet("geometry"));
            return r;
        }
    }
}

