import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.daq.utilities.DaqUtilitiesNode
import org.lsst.ccs.daq.utilities.FitsService
import org.lsst.ccs.daq.utilities.FitsServiceConfiguration
import org.lsst.ccs.utilities.ccd.*;
import org.lsst.ccs.utilities.image.*;

tags = ["agentFitsHeaderService/headerFilesList":["primary", "extended", "ts8_primary:primary","ccd_cond"]]

CCSBuilder builder = ["fitsHeaderTest"]

CCDType type = new ITLCCDType();
raftGeometry = Raft.createRaft(type);


builder.
    "main" (DaqUtilitiesNode) {

        fitsServiceConfiguration (FitsServiceConfiguration, 
            headerFilesList:["primary", "extended", "ts8_primary:primary","ccd_cond","reb_cond"]
        )

        reb0FitsService (FitsService, 
            geometry:raftGeometry.getRebs().get(0), enabled:true
        )

        reb1FitsService (FitsService, 
            geometry:raftGeometry.getRebs().get(1), enabled:true
        )
    }