/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.daq.utilities.FitsServiceHeaderCommands;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.readout.ReadOutImageSet;
import org.lsst.ccs.utilities.readout.ReadOutParameters;
import org.lsst.ccs.utilities.readout.ReadOutParametersBuilder;

public class FitsServiceTest
extends CcsTestCaseTemplate {
    private Subsystem s;
    private Subsystem publisher;

    @Before
    public void setup() throws Exception {
        this.s = BootUtils.getSubsystemFromFile((String)"fitsService");
        this.s.startAgent();
        this.publisher = new Subsystem("publisher", AgentInfo.AgentType.WORKER);
        this.publisher.startAgent();
        Assert.assertTrue((boolean)((AgentStateService)this.s.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)((AgentStateService)this.publisher.getAgentService(AgentStateService.class)).waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS));
    }

    @After
    public void tearDown() throws Exception {
        this.s.shutdownAgent();
        this.publisher.shutdownAgent();
    }

    @Test
    public void testConfiguration() throws Exception {
        FitsService fitsService = (FitsService)this.s.getComponentLookup().getComponentByPath("main/reb0FitsService");
        Map specs = fitsService.getHeaderSpecificationMap();
        Assert.assertTrue((String)"primary header ", (boolean)specs.containsKey("primary"));
        Assert.assertTrue((String)"extended header ", (boolean)specs.containsKey("extended"));
        Assert.assertTrue((String)"primary ccd_cond ", (boolean)specs.containsKey("ccd_cond"));
        Assert.assertTrue((String)"primary reb_cond ", (boolean)specs.containsKey("reb_cond"));
        Assert.assertTrue((String)"Make sure the size is 4", (specs.keySet().size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testReplacement() throws Exception {
        Assert.assertTrue((boolean)this.publisher.getMessagingAccess().getAgentPresenceManager().waitForAgent(this.s.getName(), 20L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.s.getMessagingAccess().getAgentPresenceManager().waitForAgent(this.publisher.getName(), 20L, TimeUnit.SECONDS));
        FitsService reb0FitsService = (FitsService)this.s.getComponentLookup().getComponentByPath("main/reb0FitsService");
        FitsService reb1FitsService = (FitsService)this.s.getComponentLookup().getComponentByPath("main/reb1FitsService");
        Assert.assertTrue((reb0FitsService != null ? 1 : 0) != 0);
        Assert.assertTrue((reb1FitsService != null ? 1 : 0) != 0);
        ReadOutParameters rop = ReadOutParametersBuilder.create().ccdType((CCDType)new E2VCCDType()).build();
        ReadOutImageSet reb0ImageSet = new ReadOutImageSet((CCD)reb0FitsService.getGeometry().getCCDs().get(0), rop);
        ReadOutImageSet reb1ImageSet = new ReadOutImageSet((CCD)reb1FitsService.getGeometry().getCCDs().get(2), rop);
        FitsServiceHeaderCommands commands = new FitsServiceHeaderCommands((Agent)this.s);
        commands.setPrimaryHeaderKeyword("RaftName", (Serializable)((Object)"R00"));
        commands.setPrimaryHeaderKeyword("RebName", (Serializable)((Object)"Reb1"));
        commands.setHeaderKeywordForCCD("R00.Reb1.S10", "S01Value", (Serializable)((Object)"S01"), false);
        commands.setHeaderKeywordForCCD("R00.Reb0.S00", "S00Value", (Serializable)((Object)"S00"), true);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("S01Value", "S01");
        commands.setNamedHeaderKeywords("R00.Reb1.S10", data);
        commands.setHeaderKeywordForCCD("R00.Reb0.S00", "S00Value", (Serializable)((Object)"S00"), true);
        Thread.sleep(100L);
        MetaDataSet primaryReb0 = reb0FitsService.getFitsHeaderMetadataProvider("R00/Reb1/S00").getPrimaryHeaderMetadata();
        Assert.assertEquals((Object)"R00", (Object)primaryReb0.getValue("RaftName"));
        Assert.assertEquals((Object)"Reb1", (Object)primaryReb0.getValue("RebName"));
        Assert.assertNull((Object)primaryReb0.getValue("S01Value"));
        MetaDataSet primaryReb1 = reb1FitsService.getFitsHeaderMetadataProvider("R00/Reb2/S00").getPrimaryHeaderMetadata();
        Assert.assertEquals((Object)"R00", (Object)primaryReb1.getValue("RaftName"));
        Assert.assertEquals((Object)"Reb1", (Object)primaryReb1.getValue("RebName"));
        Assert.assertNull((Object)primaryReb1.getValue("S00Value"));
        Assert.assertNull((Object)primaryReb1.getValue("S01Value"));
        commands.setHeaderKeywordForCCD("R00.Reb1.S10", "S01Value", (Serializable)((Object)"S01"), false);
        commands.setHeaderKeywordForCCD("R00.Reb0.S00", "S00Value", (Serializable)((Object)"S00"), true);
    }
}

