/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsService
implements HasLifecycle,
StatusMessageListener,
FitsHeaderMetadataProvider {
    @ConfigurationParameter(isFinal=true)
    private final List<String> headerFilesList = new ArrayList<String>();
    private final Map<String, List<FitsServiceKeyReplacement>> geometryDefaultkeyReplacements = new HashMap<String, List<FitsServiceKeyReplacement>>();
    private Reb geometry;
    private String uniqueId = "notSet";
    private static final Logger LOGGER = Logger.getLogger(FitsService.class.getName());
    private final FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
    private final Map<String, Map<String, HeaderKeywordValue>> headerKeywordValuesMap = new HashMap<String, Map<String, HeaderKeywordValue>>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService aggregatorService;
    public static final String COMMON_HEADER_NAME = "all";
    private final Map<ImageSet, Map<String, Object>> statusAggregatorDataMap = new ConcurrentHashMap<ImageSet, Map<String, Object>>();

    @ConfigurationParameterChanger(propertyName="headerFilesList")
    public void setHeaderFilesList(List<String> list) {
        LOGGER.log(Level.FINE, "Configuring Fits Header Service with {0}", list);
        this.headerFilesList.clear();
        this.headerFilesList.addAll(list);
    }

    public void postInit() {
        for (String headerFile : this.headerFilesList) {
            String headerName;
            int index = headerFile.indexOf(":");
            String fileName = index >= 0 ? headerFile.substring(0, index) : headerFile;
            String string = headerName = index >= 0 ? headerFile.substring(index + 1) : null;
            if (headerName == null) {
                headerName = fileName.replace(".spec", "");
            }
            LOGGER.log(Level.FINE, "Loading spec file: {0} for extension {1}", new Object[]{fileName, headerName});
            this.headerSpecsBuilder.addSpecFile(fileName, headerName);
            if (this.headerKeywordValuesMap.containsKey(headerName)) continue;
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        this.headerKeywordValuesMap.put(COMMON_HEADER_NAME, new HashMap());
    }

    protected Reb getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry reb) {
        LOGGER.log(Level.FINE, "Configuring Fits Header for geometry {0}", reb.getUniqueId());
        if (!(reb instanceof Reb)) {
            throw new RuntimeException("A FitsService must be configured for a Reb geometry");
        }
        this.geometry = (Reb)reb;
        this.uniqueId = this.geometry.getUniqueId();
        this.fillHeaderKeywordMaps((Geometry)this.geometry);
        String raftName = "";
        if (this.geometry.getParent() != null) {
            raftName = this.geometry.getParent().getName();
        }
        String rebName = this.geometry.getName();
        this.geometryDefaultkeyReplacements.clear();
        FitsServiceKeyReplacement rebReplacement = new FitsServiceKeyReplacement(rebName + ":REB");
        FitsServiceKeyReplacement raftReplacement = new FitsServiceKeyReplacement(raftName + ":RAFT");
        LOGGER.log(Level.FINE, "Adding default replacements for REB and RAFT: {0} {1}", new Object[]{rebReplacement, raftReplacement});
        for (CCD ccd : this.geometry.getChildrenList()) {
            String ccdName = ccd.getName();
            FitsServiceKeyReplacement ccdReplacement = new FitsServiceKeyReplacement(ccdName + ":CCD");
            ArrayList<FitsServiceKeyReplacement> ccdLevelReplacements = new ArrayList<FitsServiceKeyReplacement>();
            ccdLevelReplacements.add(ccdReplacement);
            ccdLevelReplacements.add(rebReplacement);
            ccdLevelReplacements.add(raftReplacement);
            this.geometryDefaultkeyReplacements.put(ccd.getUniqueId(), ccdLevelReplacements);
            LOGGER.log(Level.FINE, "Adding default replacements for CCD: {0}: {1}", new Object[]{ccd.getUniqueId(), ccdReplacement});
        }
    }

    public void start() {
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        if (d.getDataKey().equals("fitsHeaderKeywordData")) {
            FitsHeaderKeywordData fitsHeaderKeywordData = (FitsHeaderKeywordData)((KeyValueData)d.getObject()).getValue();
            String headerKeywordDataId = fitsHeaderKeywordData.getDataId();
            if (headerKeywordDataId != null && !headerKeywordDataId.isEmpty() && !headerKeywordDataId.startsWith(this.uniqueId)) {
                return;
            }
            for (FitsHeaderKeywordData.HeaderKeywordValue value : fitsHeaderKeywordData.getHeaderKeywordValues()) {
                this.setHeaderKeywordValue(value);
            }
        }
    }

    public Map<String, HeaderSpecification> getHeaderSpecificationMap() {
        return this.headerSpecsBuilder.getHeaderSpecifications();
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public String printHeaderSpecifications() {
        StringBuilder sb = new StringBuilder("Header specifications\n");
        Map config = this.headerSpecsBuilder.getHeaderSpecifications();
        for (String header : config.keySet()) {
            sb.append("***************************\n");
            sb.append("     Header: ").append(header).append("\n");
            sb.append("***************************\n");
            HeaderSpecification spec = (HeaderSpecification)config.get(header);
            for (HeaderSpecification.HeaderLine line : spec.getHeaders()) {
                sb.append("## ").append(line.getKeyword()).append(" ").append(line.getMetaName()).append(" ").append(line.getDataType()).append(" ").append(line.getComment()).append("\n");
            }
        }
        return sb.toString();
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        this.setHeaderKeywordValue(COMMON_HEADER_NAME, headerKeywordName, headerKeywordValue, sticky);
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue(COMMON_HEADER_NAME, headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue(headerName, headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        this.getHeaderKeywordMapForHeader(headerName).put(headerKeywordName, new HeaderKeywordValue(headerKeywordValue, sticky));
    }

    private void setHeaderKeywordValue(FitsHeaderKeywordData.HeaderKeywordValue value) {
        this.setHeaderKeywordValue(value.getHeaderName(), value.getHeaderKeywordName(), value.getHeaderKeywordValue(), value.isSticky());
    }

    private void fillHeaderKeywordMaps(Geometry geometry) {
        if (geometry instanceof Raft) {
            Raft raft = (Raft)geometry;
            for (Reb reb : raft.getChildrenList()) {
                this.fillHeaderKeywordMapsForReb(reb);
            }
        } else if (geometry instanceof Reb) {
            this.fillHeaderKeywordMapsForReb((Reb)geometry);
        } else {
            throw new RuntimeException("This class is currently designed to support a single Raft.");
        }
    }

    private void fillHeaderKeywordMapsForReb(Reb reb) {
        for (CCD ccd : reb.getChildrenList()) {
            if (this.headerKeywordValuesMap.containsKey(ccd.getUniqueId())) continue;
            this.headerKeywordValuesMap.put(ccd.getUniqueId(), new HashMap());
        }
    }

    private Map<String, HeaderKeywordValue> getHeaderKeywordMapForHeader(String headerName) {
        if (!this.headerKeywordValuesMap.containsKey(headerName)) {
            LOGGER.log(Level.WARNING, "The FitsService is not configured to store data for header {0}", headerName);
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        return this.headerKeywordValuesMap.get(headerName);
    }

    private MetaDataSet buildMetaDataSetForExtension(String extension) {
        Map<String, HeaderKeywordValue> headerKeywordMap = this.getHeaderKeywordMapForHeader(extension);
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        for (String headerKeyword : headerKeywordMap.keySet()) {
            valuesMap.put(headerKeyword, headerKeywordMap.get(headerKeyword).getValue());
        }
        MetaDataSet result = new MetaDataSet();
        result.addMetaDataMap(extension, valuesMap);
        return result;
    }

    public void clearNonStickyHeaderKeywordValues() {
        for (Map<String, HeaderKeywordValue> map : this.headerKeywordValuesMap.values()) {
            this.clearNonStickyHeaderKeywordValuesFromMap(map);
        }
    }

    private void clearNonStickyHeaderKeywordValuesFromMap(Map<String, HeaderKeywordValue> map) {
        Iterator<Map.Entry<String, HeaderKeywordValue>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, HeaderKeywordValue> entry = iter.next();
            if (entry.getValue().isSticky()) continue;
            iter.remove();
        }
    }

    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        MetaDataSet r = this.buildMetaDataSetForExtension(extendedKeyword);
        r.addMetaDataSet(this.buildMetaDataSetForExtension(COMMON_HEADER_NAME));
        r.addMetaDataSet(this.buildMetaDataSetForExtension(imageSet.getCCD().getUniqueId()));
        r.addMetaDataSet(this.getStatusAggregatorMetaDataSet(imageSet));
        return r;
    }

    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        MetaDataSet r = this.buildMetaDataSetForExtension(COMMON_HEADER_NAME);
        r.addMetaDataSet(this.buildMetaDataSetForExtension(imageSet.getCCD().getUniqueId()));
        r.addMetaDataSet(this.getStatusAggregatorMetaDataSet(imageSet));
        return r;
    }

    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        MetaDataSet r = this.buildMetaDataSetForExtension("primary");
        r.addMetaDataSet(this.buildMetaDataSetForExtension(COMMON_HEADER_NAME));
        r.addMetaDataSet(this.buildMetaDataSetForExtension(imageSet.getCCD().getUniqueId()));
        r.addMetaDataSet(this.getStatusAggregatorMetaDataSet(imageSet));
        return r;
    }

    public void completedHeaderMetadata(ImageSet imageSet) {
        this.statusAggregatorDataMap.remove(imageSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaDataSet getStatusAggregatorMetaDataSet(ImageSet imageSet) {
        MetaDataSet m = new MetaDataSet();
        Map<ImageSet, Map<String, Object>> map = this.statusAggregatorDataMap;
        synchronized (map) {
            if (!this.statusAggregatorDataMap.containsKey(imageSet)) {
                Map aggrMap = this.aggregatorService.getAllLast();
                HashMap toAdd = new HashMap();
                long start = System.currentTimeMillis();
                int mapSize = aggrMap.size();
                List replacementsToUse = this.geometryDefaultkeyReplacements.getOrDefault(imageSet.getCCD().getUniqueId(), new ArrayList());
                if (replacementsToUse.isEmpty()) {
                    LOGGER.log(Level.WARNING, "No default header keyword replacements were found for {0}", imageSet.getCCD().getUniqueId());
                }
                for (FitsServiceKeyReplacement r : replacementsToUse) {
                    aggrMap.entrySet().forEach(e -> {
                        String key = (String)e.getKey();
                        if (!(key = r.manipulate(key)).equals(e.getKey())) {
                            if (toAdd.containsKey(key) || aggrMap.containsKey(key)) {
                                LOGGER.log(Level.WARNING, "Key {0} already exists in metadata set from Status Aggregator. This might lead to problems.", key);
                            }
                            toAdd.put(key, e.getValue());
                        }
                    });
                    aggrMap.putAll(toAdd);
                }
                this.statusAggregatorDataMap.put(imageSet, aggrMap);
                long delta = System.currentTimeMillis() - start;
                LOGGER.log(Level.FINEST, "Manipulated StatusAggregator map({0}) in {1}ms to yield {2} entries.", new Object[]{mapSize, delta, aggrMap.size()});
            }
            m.addMetaDataMap("StatusAggregator", this.statusAggregatorDataMap.get(imageSet));
        }
        return m;
    }

    public static class FitsServiceKeyReplacement {
        private final String match;
        private final String replace;

        public FitsServiceKeyReplacement(String configStr) {
            int index = configStr.indexOf(":");
            this.match = "(?i)" + Pattern.quote(configStr.substring(0, index));
            this.replace = configStr.substring(index + 1);
        }

        public String manipulate(String input) {
            return input.replaceAll(this.match, this.replace);
        }

        public String toString() {
            return this.match + ":" + this.replace;
        }
    }

    private class HeaderKeywordValue {
        private final Object value;
        private final boolean sticky;

        HeaderKeywordValue(Object value, boolean sticky) {
            this.value = value;
            this.sticky = sticky;
        }

        Object getValue() {
            return this.value;
        }

        boolean isSticky() {
            return this.sticky;
        }
    }
}

