/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.daq.utilities.FitsServiceHeaderCommands;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.E2VCCDType;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public class FitsServiceTest
extends CcsTestCaseTemplate {
    @Test
    public void testConfiguration() throws Exception {
        Subsystem s = BootUtils.getSubsystemFromFile((String)"fitsService");
        s.startAgent();
        FitsService fitsService = (FitsService)s.getComponentLookup().getComponentByPath("main/reb0FitsService");
        Map specs = fitsService.getHeaderSpecificationMap();
        Assert.assertTrue((String)"primary header ", (boolean)specs.containsKey("primary"));
        Assert.assertTrue((String)"extended header ", (boolean)specs.containsKey("extended"));
        Assert.assertTrue((String)"primary ccd_cond ", (boolean)specs.containsKey("ccd_cond"));
        Assert.assertTrue((String)"primary reb_cond ", (boolean)specs.containsKey("reb_cond"));
        Assert.assertTrue((String)"Make sure the size is 4", (specs.keySet().size() == 4 ? 1 : 0) != 0);
        s.shutdownAgent();
    }

    @Test
    public void testReplacement() throws Exception {
        Subsystem s = BootUtils.getSubsystemFromFile((String)"fitsService");
        s.startAgent();
        Subsystem publisher = new Subsystem("publisher", AgentInfo.AgentType.WORKER);
        publisher.startAgent();
        Assert.assertTrue((boolean)publisher.getMessagingAccess().getAgentPresenceManager().waitForAgent(s.getName(), 20L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)s.getMessagingAccess().getAgentPresenceManager().waitForAgent(publisher.getName(), 20L, TimeUnit.SECONDS));
        FitsService reb0FitsService = (FitsService)s.getComponentLookup().getComponentByPath("main/reb0FitsService");
        FitsService reb1FitsService = (FitsService)s.getComponentLookup().getComponentByPath("main/reb1FitsService");
        Assert.assertTrue((reb0FitsService != null ? 1 : 0) != 0);
        Assert.assertTrue((reb1FitsService != null ? 1 : 0) != 0);
        DefaultImageSet reb0ImageSet = new DefaultImageSet((CCD)reb0FitsService.getGeometry().getChild(0, 0), new ReadOutParameters((CCDType)new E2VCCDType()));
        DefaultImageSet reb1ImageSet = new DefaultImageSet((CCD)reb1FitsService.getGeometry().getChild(0, 2), new ReadOutParameters((CCDType)new E2VCCDType()));
        Assert.assertTrue((String)"R00.Reb0.S00", (boolean)reb0ImageSet.getCCD().getUniqueId().equals("R00.Reb0.S00"));
        Assert.assertTrue((String)"R00.Reb1.S12", (boolean)reb1ImageSet.getCCD().getUniqueId().equals("R00.Reb1.S12"));
        FitsServiceHeaderCommands commands = new FitsServiceHeaderCommands((Agent)s);
        commands.setPrimaryHeaderKeyword("RaftName", (Serializable)((Object)"R00"));
        commands.setPrimaryHeaderKeyword("RebName", (Serializable)((Object)"Reb1"));
        commands.setHeaderKeywordForCCD("R00.Reb1.S10", "S01Value", (Serializable)((Object)"S01"), false);
        commands.setHeaderKeywordForCCD("R00.Reb0.S00", "S00Value", (Serializable)((Object)"S00"), true);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("S01Value", "S01");
        commands.setNamedHeaderKeywords("R00.Reb1.S10", data);
        commands.setHeaderKeywordForCCD("R00.Reb0.S00", "S00Value", (Serializable)((Object)"S00"), true);
        Thread.sleep(100L);
        MetaDataSet primaryReb0 = reb0FitsService.getPrimaryHeaderMetadata((ImageSet)reb0ImageSet);
        Assert.assertEquals((Object)"R00", (Object)primaryReb0.getValue("RaftName"));
        Assert.assertEquals((Object)"Reb1", (Object)primaryReb0.getValue("RebName"));
        Assert.assertEquals((Object)"S00", (Object)primaryReb0.getValue("S00Value"));
        Assert.assertNull((Object)primaryReb0.getValue("S01Value"));
        MetaDataSet primaryReb1 = reb1FitsService.getPrimaryHeaderMetadata((ImageSet)reb1ImageSet);
        Assert.assertEquals((Object)"R00", (Object)primaryReb1.getValue("RaftName"));
        Assert.assertEquals((Object)"Reb1", (Object)primaryReb1.getValue("RebName"));
        Assert.assertNull((Object)primaryReb1.getValue("S00Value"));
        Assert.assertNull((Object)primaryReb1.getValue("S01Value"));
        commands.setHeaderKeywordForCCD("R00.Reb1.S10", "S01Value", (Serializable)((Object)"S01"), false);
        commands.setHeaderKeywordForCCD("R00.Reb0.S00", "S00Value", (Serializable)((Object)"S00"), true);
        s.shutdownAgent();
        publisher.shutdownAgent();
    }
}

