/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import java.awt.Dimension;
import java.awt.Point;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.ImageSensitiveArea;
import org.lsst.ccs.utilities.ccd.SegmentGeometryConstants;
import org.lsst.ccs.utilities.ccd.SegmentReadOutOrder;
import org.lsst.ccs.utilities.ccd.image.data.RawImageData;
import org.lsst.ccs.utilities.ccd.image.data.RawImageDataProvider;
import org.lsst.ccs.utilities.image.ImagePixelData;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public class Segment
extends Geometry
implements RawImageDataProvider,
ImageSensitiveArea {
    private final SegmentReadOutOrder readOutOrder;
    private ImagePixelData imagePixelData;
    private final int channel;

    Segment(SegmentGeometryConstants segmentGeometryConstants, SegmentReadOutOrder readOutOrder, int channel) {
        super("Seg", new Dimension(segmentGeometryConstants.getSegmentParallelActiveSize(), segmentGeometryConstants.getSegmentSerialActiveSize()));
        this.readOutOrder = readOutOrder;
        this.channel = channel;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getSegmentSerialActiveSize() {
        return this.getHeight();
    }

    public int getSegmentParallelActiveSize() {
        return this.getWidth();
    }

    public boolean isReadoutDown() {
        return this.readOutOrder.isReadoutDown();
    }

    public boolean isReadoutLeft() {
        return this.readOutOrder.isReadoutLeft();
    }

    protected void addGeometryToGrid(Geometry child, int p, int s) {
        throw new UnsupportedOperationException("Cannot add a geometry to a Segment.");
    }

    @Override
    public RawImageData getRawImageData(ReadOutParameters readOutParameters) {
        DataStreamer streamer = new DataStreamer(this, readOutParameters);
        ByteBuffer dest = this.createByteBuffer(readOutParameters.getTotalSerialSize() * readOutParameters.getTotalParallelSize());
        for (int row = 0; row < this.getSegmentParallelActiveSize(); ++row) {
            streamer.fillSerialPrescan(dest);
            streamer.fillDataRow(dest);
            streamer.fillSerialOverscan(dest);
        }
        streamer.fillParallelOverscan(dest);
        dest.flip();
        return new RawImageData(RawImageData.BitsPerPixel.BIT32, dest);
    }

    private ByteBuffer createByteBuffer(int size) {
        ByteBuffer dest = ByteBuffer.allocateDirect(size * 4);
        dest.order(ByteOrder.nativeOrder());
        return dest;
    }

    static Segment createCCDSegment(CCDType ccdType, SegmentReadOutOrder readoutOrder, int channel) {
        return new Segment(ccdType.getCCDGeometryConstants().getSegmentGeometryConstraint(), readoutOrder, channel);
    }

    @Override
    public void exposeToImage(ImagePixelData imagePixelData) {
        Point absoluteOrigin = this.getAbsolutePoint(new Point(0, 0));
        this.imagePixelData = new SegmentPixelData(absoluteOrigin, this.getWidth(), this.getHeight(), imagePixelData);
    }

    @Override
    public boolean hasPixelData() {
        return this.imagePixelData != null;
    }

    @Override
    public ImagePixelData getImagePixelData() {
        return this.imagePixelData;
    }

    private class SegmentPixelData
    implements ImagePixelData {
        private final int xGlobalCoordinate;
        private final int yGlobalCoordinate;
        private final int width;
        private final int height;
        private final ImagePixelData exposure;

        SegmentPixelData(Point origin, int width, int height, ImagePixelData exposure) {
            this.xGlobalCoordinate = origin.x;
            this.yGlobalCoordinate = origin.y;
            this.width = width;
            this.height = height;
            this.exposure = exposure;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getPixelData(int x, int y) {
            return this.exposure.getPixelData(x += this.xGlobalCoordinate, y += this.yGlobalCoordinate);
        }

        @Override
        public double getMaxValue() {
            return this.exposure.getMaxValue();
        }
    }

    private class DataStreamer {
        private final ByteBuffer serialPrescanBuffer;
        private final ByteBuffer serialOverscanBuffer;
        private final ByteBuffer parallelOverscanBuffer;
        private final ImagePixelData imagePixelData;
        private int currentImageColumn;
        private boolean increaseImageColumnCount;
        private boolean scanColumnFromTop;
        private final Segment s;
        private final ReadOutParameters readOutParameters;

        DataStreamer(Segment s, ReadOutParameters readOutParameters) {
            int i;
            this.readOutParameters = readOutParameters;
            this.serialPrescanBuffer = Segment.this.createByteBuffer(readOutParameters.getSerialPrescan());
            this.serialOverscanBuffer = Segment.this.createByteBuffer(readOutParameters.getOverCols());
            int parallelOverscanBufferSize = readOutParameters.getOverRows() * (readOutParameters.getReadCols() + readOutParameters.getReadCols2() + readOutParameters.getOverCols());
            this.parallelOverscanBuffer = Segment.this.createByteBuffer(readOutParameters.getOverRows() * parallelOverscanBufferSize);
            for (i = 0; i < readOutParameters.getSerialPrescan(); ++i) {
                this.serialPrescanBuffer.putInt(0);
            }
            for (i = 0; i < readOutParameters.getOverCols(); ++i) {
                this.serialOverscanBuffer.putInt(0);
            }
            for (i = 0; i < parallelOverscanBufferSize; ++i) {
                this.parallelOverscanBuffer.putInt(0);
            }
            this.imagePixelData = s.getImagePixelData();
            this.s = s;
            this.reset();
        }

        public final void reset() {
            SegmentReadOutOrder readout = this.s.readOutOrder;
            if (!readout.isReadoutLeft()) {
                this.currentImageColumn = this.imagePixelData.getWidth() - 1;
                this.increaseImageColumnCount = false;
            } else {
                this.currentImageColumn = 0;
                this.increaseImageColumnCount = true;
            }
            this.scanColumnFromTop = !readout.isReadoutDown();
        }

        void fillSerialPrescan(ByteBuffer data) {
            this.serialPrescanBuffer.flip();
            data.put(this.serialPrescanBuffer);
        }

        void fillSerialOverscan(ByteBuffer data) {
            this.serialOverscanBuffer.flip();
            data.put(this.serialOverscanBuffer);
        }

        void fillParallelOverscan(ByteBuffer data) {
            this.parallelOverscanBuffer.flip();
            data.put(this.parallelOverscanBuffer);
        }

        void fillDataRow(ByteBuffer data) {
            if (!this.scanColumnFromTop) {
                for (int i = this.imagePixelData.getHeight() - 1; i >= 0; --i) {
                    int value = this.imagePixelData.getPixelData(this.currentImageColumn, i);
                    data.putInt(value);
                }
            } else {
                for (int i = 0; i < this.imagePixelData.getHeight(); ++i) {
                    int value = this.imagePixelData.getPixelData(this.currentImageColumn, i);
                    data.putInt(value);
                }
            }
            this.currentImageColumn = this.increaseImageColumnCount ? this.currentImageColumn + 1 : this.currentImageColumn - 1;
        }
    }
}

