/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number.formatters;

import java.math.BigDecimal;
import org.python.icu.impl.number.Format;
import org.python.icu.impl.number.FormatQuantity;
import org.python.icu.impl.number.ModifierHolder;
import org.python.icu.impl.number.Properties;

public class BigDecimalMultiplier
extends Format.BeforeFormat {
    private final BigDecimal multiplier;

    public static boolean useMultiplier(IProperties properties) {
        return properties.getMultiplier() != IProperties.DEFAULT_MULTIPLIER;
    }

    public static BigDecimalMultiplier getInstance(IProperties properties) {
        if (properties.getMultiplier() == null) {
            throw new IllegalArgumentException("The multiplier must be present for MultiplierFormat");
        }
        return new BigDecimalMultiplier(properties);
    }

    private BigDecimalMultiplier(IProperties properties) {
        this.multiplier = properties.getMultiplier();
    }

    @Override
    public void before(FormatQuantity input, ModifierHolder mods) {
        input.multiplyBy(this.multiplier);
    }

    @Override
    public void export(Properties properties) {
        properties.setMultiplier(this.multiplier);
    }

    public static interface IProperties {
        public static final BigDecimal DEFAULT_MULTIPLIER = null;

        public BigDecimal getMultiplier();

        public IProperties setMultiplier(BigDecimal var1);
    }
}

