/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecificationsBuilder;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class FitsService
implements HasLifecycle,
StatusMessageListener,
FitsHeaderMetadataProvider {
    @ConfigurationParameter(isFinal=true)
    private List<String> headerFilesList = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true)
    private List<String> replacements = new CopyOnWriteArrayList<String>();
    private final List<FitsServiceKeyReplacement> keyReplacements = new ArrayList<FitsServiceKeyReplacement>();
    private Geometry geometry;
    private String uniqueId = "notSet";
    private static final Logger LOGGER = Logger.getLogger(FitsService.class.getName());
    private final FitsHeadersSpecificationsBuilder headerSpecsBuilder = new FitsHeadersSpecificationsBuilder();
    private final Map<String, Map<String, HeaderKeywordValue>> headerKeywordValuesMap = new HashMap<String, Map<String, HeaderKeywordValue>>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStatusAggregatorService aggregatorService;
    private final Map<ImageSet, Map<String, Object>> statusAggregatorDataMap = new ConcurrentHashMap<ImageSet, Map<String, Object>>();

    @ConfigurationParameterChanger(propertyName="headerFilesList")
    public void setHeaderFilesList(List<String> list) {
        LOGGER.info("Configuring Fits Header Service with " + list);
        this.headerFilesList.addAll(list);
    }

    public void setGeometry(Geometry geometry) {
        LOGGER.info("Configuring Fits Header for geometry " + geometry.getUniqueId());
        this.geometry = geometry;
        this.uniqueId = geometry.getUniqueId();
        this.fillHeaderKeywordMaps(geometry);
    }

    public void postInit() {
        for (String headerFile : this.headerFilesList) {
            String headerName;
            int index = headerFile.indexOf(":");
            String fileName = index >= 0 ? headerFile.substring(0, index) : headerFile;
            String string = headerName = index >= 0 ? headerFile.substring(index + 1) : null;
            if (headerName == null) {
                headerName = fileName.replace(".spec", "");
            }
            LOGGER.info("Loading spec file: " + fileName + " for extension " + headerName);
            this.headerSpecsBuilder.addSpecFile(fileName, headerName);
            if (this.headerKeywordValuesMap.containsKey(headerName)) continue;
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        if (!this.replacements.isEmpty()) {
            LOGGER.info("FitsService is configured to perform the following replacements:");
            for (String r : this.replacements) {
                FitsServiceKeyReplacement obj = new FitsServiceKeyReplacement(r);
                this.keyReplacements.add(obj);
                LOGGER.info(obj.toString());
            }
        }
    }

    public void start() {
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData d = (StatusSubsystemData)msg;
        if (d.getDataKey().equals("fitsHeaderKeywordData")) {
            FitsHeaderKeywordData fitsHeaderKeywordData = (FitsHeaderKeywordData)((KeyValueData)d.getObject()).getValue();
            String headerKeywordDataId = fitsHeaderKeywordData.getDataId();
            if (headerKeywordDataId != null && !headerKeywordDataId.isEmpty() && !headerKeywordDataId.equals(this.uniqueId)) {
                return;
            }
            for (FitsHeaderKeywordData.HeaderKeywordValue value : fitsHeaderKeywordData.getHeaderKeywordValues()) {
                this.setHeaderKeywordValue(value);
            }
        }
    }

    public Map<String, HeaderSpecification> getHeaderSpecificationMap() {
        return this.headerSpecsBuilder.getHeaderSpecifications();
    }

    protected void printHeaderSpecifications() {
        StringBuilder sb = new StringBuilder();
        Map config = this.headerSpecsBuilder.getHeaderSpecifications();
        for (String header : config.keySet()) {
            sb.append("***************************\n");
            sb.append("     Header: ").append(header).append("\n");
            sb.append("***************************\n");
            HeaderSpecification spec = (HeaderSpecification)config.get(header);
            for (HeaderSpecification.HeaderLine line : spec.getHeaders()) {
                sb.append("## ").append(line.getKeyword()).append(" ").append(line.getMetaName()).append(" ").append(line.getDataType()).append(" ").append(line.getComment()).append("\n");
            }
        }
        System.out.println("Header specifications\n" + sb.toString());
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue("primary", headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        this.setHeaderKeywordValue("primary", headerKeywordName, headerKeywordValue, sticky);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue) {
        this.setHeaderKeywordValue(headerName, headerKeywordName, headerKeywordValue, false);
    }

    public void setHeaderKeywordValue(String headerName, String headerKeywordName, Object headerKeywordValue, boolean sticky) {
        LOGGER.info("Setting for header: " + headerName + " (" + headerKeywordName + "," + headerKeywordValue + ") " + sticky);
        this.getHeaderKeywordMapForHeader(headerName).put(headerKeywordName, new HeaderKeywordValue(headerKeywordValue, sticky));
    }

    private void setHeaderKeywordValue(FitsHeaderKeywordData.HeaderKeywordValue value) {
        this.setHeaderKeywordValue(value.getHeaderName(), value.getHeaderKeywordName(), value.getHeaderKeywordValue(), value.isSticky());
    }

    private void fillHeaderKeywordMaps(Geometry geometry) {
        if (geometry instanceof Raft) {
            Raft raft = (Raft)geometry;
            for (Reb reb : raft.getChildrenList()) {
                this.fillHeaderKeywordMapsForReb(reb);
            }
        } else if (geometry instanceof Reb) {
            this.fillHeaderKeywordMapsForReb((Reb)geometry);
        } else {
            throw new RuntimeException("This class is currently designed to support a single Raft.");
        }
    }

    private void fillHeaderKeywordMapsForReb(Reb reb) {
        for (CCD ccd : reb.getChildrenList()) {
            if (this.headerKeywordValuesMap.containsKey(ccd.getUniqueId())) continue;
            this.headerKeywordValuesMap.put(ccd.getUniqueId(), new HashMap());
        }
    }

    private Map<String, HeaderKeywordValue> getHeaderKeywordMapForHeader(String headerName) {
        if (!this.headerKeywordValuesMap.containsKey(headerName)) {
            LOGGER.warning("The FitsService is not configured to store data for header " + headerName);
            this.headerKeywordValuesMap.put(headerName, new HashMap());
        }
        return this.headerKeywordValuesMap.get(headerName);
    }

    private Map<String, Object> buildMapOfHeaderKeywordValues(Map<String, HeaderKeywordValue> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String headerKeyword : map.keySet()) {
            result.put(headerKeyword, map.get(headerKeyword).getValue());
        }
        return result;
    }

    public void clearNonStickyHeaderKeywordValues() {
        for (Map<String, HeaderKeywordValue> map : this.headerKeywordValuesMap.values()) {
            this.clearNonStickyHeaderKeywordValuesFromMap(map);
        }
    }

    private void clearNonStickyHeaderKeywordValuesFromMap(Map<String, HeaderKeywordValue> map) {
        Iterator<Map.Entry<String, HeaderKeywordValue>> iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, HeaderKeywordValue> entry = iter.next();
            if (entry.getValue().isSticky()) continue;
            iter.remove();
        }
    }

    public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
        return this.buildMetaDataSetForExtension(extendedKeyword, imageSet);
    }

    public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
        return this.buildMetaDataSetForExtension(imageSet.getCCD().getUniqueId(), imageSet);
    }

    public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
        return this.buildMetaDataSetForExtension("primary", imageSet);
    }

    public void completedHeaderMetadata(ImageSet imageSet) {
        this.statusAggregatorDataMap.remove(imageSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaDataSet buildMetaDataSetForExtension(String extension, ImageSet imageSet) {
        MetaDataSet m = new MetaDataSet();
        Map<ImageSet, Map<String, Object>> map = this.statusAggregatorDataMap;
        synchronized (map) {
            if (!this.statusAggregatorDataMap.containsKey(imageSet)) {
                Map aggrMap = this.aggregatorService.getAllLast();
                HashMap toAdd = new HashMap();
                for (Map.Entry e : aggrMap.entrySet()) {
                    String key = (String)e.getKey();
                    for (FitsServiceKeyReplacement r : this.keyReplacements) {
                        key = r.manipulate(key);
                    }
                    if (key.equals(e.getKey())) continue;
                    if (toAdd.containsKey(key) || aggrMap.containsKey(key)) {
                        LOGGER.log(Level.WARNING, "Key {0} already exists in metadata set from Status Aggregator. This might lead to problems.", key);
                    }
                    toAdd.put(key, e.getValue());
                }
                aggrMap.putAll(toAdd);
                this.statusAggregatorDataMap.put(imageSet, aggrMap);
            }
            m.addMetaDataMap("StatusAggregator", this.statusAggregatorDataMap.get(imageSet));
        }
        m.addMetaDataMap(extension, this.buildMapOfHeaderKeywordValues(this.getHeaderKeywordMapForHeader(extension)));
        return m;
    }

    public static class FitsServiceKeyReplacement {
        private final String match;
        private final String replace;

        public FitsServiceKeyReplacement(String configStr) {
            int index = configStr.indexOf(":");
            this.match = configStr.substring(0, index);
            this.replace = configStr.substring(index + 1);
        }

        public String manipulate(String input) {
            return input.replaceAll(this.match, this.replace);
        }

        public String toString() {
            return this.match + ":" + this.replace;
        }
    }

    private class HeaderKeywordValue {
        private final Object value;
        private final boolean sticky;

        HeaderKeywordValue(Object value, boolean sticky) {
            this.value = value;
            this.sticky = sticky;
        }

        Object getValue() {
            return this.value;
        }

        boolean isSticky() {
            return this.sticky;
        }
    }
}

