/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.PrintStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.header.Standard;
import nom.tam.image.StandardImageTiler;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.PrimitiveTypeEnum;

public class ImageHDU
extends BasicHDU<ImageData> {
    public static ImageData encapsulate(Object o) throws FitsException {
        return new ImageData(o);
    }

    public static boolean isData(Object o) {
        if (o.getClass().isArray()) {
            PrimitiveTypeEnum type = PrimitiveTypeEnum.valueOf(ArrayFuncs.getBaseClass(o));
            return type != PrimitiveTypeEnum.BOOLEAN && type != PrimitiveTypeEnum.STRING && type != PrimitiveTypeEnum.UNKNOWN;
        }
        return false;
    }

    public static boolean isHeader(Header hdr) {
        String s;
        boolean found = hdr.getBooleanValue(Standard.SIMPLE);
        if (!found && (s = hdr.getStringValue(Standard.XTENSION)) != null && (s.trim().equals("IMAGE") || s.trim().equals("IUEIMAGE"))) {
            found = true;
        }
        if (!found) {
            return false;
        }
        return !hdr.getBooleanValue(Standard.GROUPS);
    }

    public static Data manufactureData(Header hdr) throws FitsException {
        return new ImageData(hdr);
    }

    public static Header manufactureHeader(Data d) throws FitsException {
        if (d == null) {
            return null;
        }
        Header h = new Header();
        d.fillHeader(h);
        return h;
    }

    public ImageHDU(Header h, ImageData d) throws FitsException {
        super(h, d);
    }

    @Override
    protected boolean canBePrimary() {
        return true;
    }

    public StandardImageTiler getTiler() {
        return ((ImageData)this.myData).getTiler();
    }

    @Override
    public void info(PrintStream stream) {
        if (ImageHDU.isHeader(this.myHeader)) {
            stream.println("  Image");
        } else {
            stream.println("  Image (bad header)");
        }
        stream.println("      Header Information:");
        stream.println("         BITPIX=" + this.myHeader.getIntValue(Standard.BITPIX, -1));
        int naxis = this.myHeader.getIntValue(Standard.NAXIS, -1);
        stream.println("         NAXIS=" + naxis);
        for (int i = 1; i <= naxis; ++i) {
            stream.println("         NAXIS" + i + "=" + this.myHeader.getIntValue(Standard.NAXISn.n(i), -1));
        }
        stream.println("      Data information:");
        try {
            if (((ImageData)this.myData).getData() == null) {
                stream.println("        No Data");
            } else {
                stream.println("         " + ArrayFuncs.arrayDescription(((ImageData)this.myData).getData()));
            }
        }
        catch (Exception e) {
            stream.println("      Unable to get data");
        }
    }

    @Override
    protected void setPrimaryHDU(boolean status) {
        try {
            super.setPrimaryHDU(status);
        }
        catch (FitsException e) {
            System.err.println("Impossible exception in ImageData");
        }
        if (status) {
            this.myHeader.setSimple(true);
        } else {
            this.myHeader.setXtension("IMAGE");
        }
    }
}

