/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nom.tam.fits.Data;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardBuilder;
import nom.tam.fits.HeaderCardCountingArrayDataInput;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.HeaderOrder;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.fits.header.extra.CXCExt;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.Cursor;
import nom.tam.util.HashedList;
import nom.tam.util.RandomAccess;

public class Header
implements FitsElement {
    private static final int MIN_NUMBER_OF_CARDS_FOR_VALID_HEADER = 4;
    private static final int MAX_CARDS_PER_HEADER = 36;
    private static final Logger LOG = Logger.getLogger(Header.class.getName());
    private final HashedList<String, HeaderCard> cards = new HashedList();
    private Cursor<String, HeaderCard> iter = this.cards.iterator(0);
    private long fileOffset = -1L;
    private List<HeaderCard> duplicates;
    private ArrayDataInput input;
    private int originalCardCount = 0;

    public static Header readHeader(ArrayDataInput dis) throws TruncatedFileException, IOException {
        Header myHeader = new Header();
        try {
            myHeader.read(dis);
        }
        catch (EOFException e) {
            if (e.getCause() instanceof TruncatedFileException) {
                throw e;
            }
            return null;
        }
        return myHeader;
    }

    @Deprecated
    public static void setLongStringsEnabled(boolean flag) {
        FitsFactory.setLongStringsEnabled(flag);
    }

    public Header() {
    }

    public Header(ArrayDataInput is) throws TruncatedFileException, IOException {
        this.read(is);
    }

    public Header(Data o) throws FitsException {
        o.fillHeader(this);
    }

    public Header(String[] newCards) {
        for (String newCard : newCards) {
            this.cards.add(HeaderCard.create(newCard));
        }
    }

    private void addDuplicate(HeaderCard dup) {
        if (!Standard.COMMENT.key().equals(dup.getKey()) && !Standard.HISTORY.key().equals(dup.getKey())) {
            System.err.println("Warning: multiple occurrences of key:" + dup.getKey());
            if (this.duplicates == null) {
                this.duplicates = new ArrayList<HeaderCard>();
            }
            this.duplicates.add(dup);
        }
    }

    public void addLine(HeaderCard fcard) {
        if (fcard != null) {
            this.iter.add(fcard);
        }
    }

    public void addValue(IFitsHeader key, boolean val) throws HeaderCardException {
        this.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, double val) throws HeaderCardException {
        this.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, long val) throws HeaderCardException {
        this.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, int val) throws HeaderCardException {
        this.addValue(key.key(), val, key.comment());
    }

    public void addValue(IFitsHeader key, String val) throws HeaderCardException {
        this.addValue(key.key(), val, key.comment());
    }

    public void addValue(String key, BigDecimal val, String comment) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(new HeaderCard(key, val, comment));
    }

    public void addValue(String key, BigInteger val, String comment) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(new HeaderCard(key, val, comment));
    }

    public void addValue(String key, boolean val, String comment) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(new HeaderCard(key, val, comment));
    }

    public void addValue(String key, double val, String comment) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(new HeaderCard(key, val, comment));
    }

    public void addValue(String key, long val, String comment) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(new HeaderCard(key, val, comment));
    }

    public void addValue(String key, String val, String comment) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(new HeaderCard(key, val, comment));
    }

    void afterExtend() {
        if (this.findCard(Standard.EXTEND) != null) {
            this.nextCard();
        }
    }

    public HeaderCardBuilder card(IFitsHeader key) {
        return new HeaderCardBuilder(this, key);
    }

    private void cardCheck(IFitsHeader key) throws FitsException {
        this.cardCheck(key.key());
    }

    private void cardCheck(String key) throws FitsException {
        if (!this.iter.hasNext()) {
            throw new FitsException("Header terminates before " + key);
        }
        HeaderCard card = (HeaderCard)this.iter.next();
        if (!card.getKey().equals(key)) {
            throw new FitsException("Key " + key + " not found where expected." + "Found " + card.getKey());
        }
    }

    void checkBeginning() throws FitsException {
        this.iter = this.iterator();
        if (!this.iter.hasNext()) {
            throw new FitsException("Empty Header");
        }
        HeaderCard card = (HeaderCard)this.iter.next();
        String key = card.getKey();
        if (!key.equals(Standard.SIMPLE.key()) && !key.equals(Standard.XTENSION.key())) {
            throw new FitsException("No SIMPLE or XTENSION at beginning of Header");
        }
        boolean isTable = false;
        boolean isExtension = false;
        if (key.equals(Standard.XTENSION.key())) {
            String value = card.getValue();
            if (value == null || value.isEmpty()) {
                throw new FitsException("Empty XTENSION keyword");
            }
            isExtension = true;
            if (value.equals("BINTABLE") || value.equals("A3DTABLE") || value.equals("TABLE")) {
                isTable = true;
            }
        }
        this.cardCheck(Standard.BITPIX);
        this.cardCheck(Standard.NAXIS);
        int nax = this.getIntValue(Standard.NAXIS);
        this.iter.next();
        int i = 1;
        while (i <= nax) {
            this.cardCheck(Standard.NAXISn.n(i++));
        }
        if (isExtension) {
            this.cardCheck(Standard.PCOUNT);
            this.cardCheck(Standard.GCOUNT);
            if (isTable) {
                this.cardCheck(Standard.TFIELDS);
            }
        }
    }

    void checkEnd() {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            HeaderCard card = (HeaderCard)this.iter.next();
            if (card.isKeyValuePair() || !card.getKey().equals(Standard.END.key())) continue;
            this.iter.remove();
        }
        try {
            this.iter.add(new HeaderCard(Standard.END.key(), (String)null, null));
        }
        catch (HeaderCardException e) {
            LOG.severe("can not happen");
        }
    }

    public final boolean containsKey(IFitsHeader key) {
        return this.cards.containsKey(key.key());
    }

    public final boolean containsKey(String key) {
        return this.cards.containsKey(key);
    }

    public void deleteKey(IFitsHeader key) {
        this.deleteKey(key.key());
    }

    public void deleteKey(String key) {
        if (this.containsKey(key)) {
            this.iter.setKey(key);
            if (this.iter.hasNext()) {
                this.iter.next();
                this.iter.remove();
            }
        }
    }

    public void dumpHeader(PrintStream ps) {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            ps.println(this.iter.next());
        }
    }

    public HeaderCard findCard(String key) {
        HeaderCard card = (HeaderCard)this.cards.get(key);
        if (card != null) {
            this.iter.setKey(key);
        }
        return card;
    }

    public HeaderCard findCard(IFitsHeader key) {
        return this.findCard(key.key());
    }

    public String findKey(String key) {
        HeaderCard card = this.findCard(key);
        if (card == null) {
            return null;
        }
        return card.toString();
    }

    public BigDecimal getBigDecimalValue(IFitsHeader key) {
        return this.getBigDecimalValue(key.key());
    }

    public BigDecimal getBigDecimalValue(String key) {
        return this.getBigDecimalValue(key, BigDecimal.ZERO);
    }

    public BigDecimal getBigDecimalValue(String key, BigDecimal dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(BigDecimal.class, dft);
    }

    public BigInteger getBigIntegerValue(IFitsHeader key, BigInteger dft) {
        return this.getBigIntegerValue(key.key(), dft);
    }

    public BigInteger getBigIntegerValue(String key) {
        return this.getBigIntegerValue(key, BigInteger.ZERO);
    }

    public BigInteger getBigIntegerValue(String key, BigInteger dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(BigInteger.class, dft);
    }

    public boolean getBooleanValue(IFitsHeader key) {
        return this.getBooleanValue(key.key());
    }

    public boolean getBooleanValue(String key) {
        return this.getBooleanValue(key, false);
    }

    public boolean getBooleanValue(String key, boolean dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Boolean.class, dft);
    }

    public boolean getBooleanValue(IFitsHeader key, boolean dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Boolean.class, dft);
    }

    @Deprecated
    public String getCard(int n) {
        if (n >= 0 && n < this.cards.size()) {
            return this.cards.get(n).toString();
        }
        return null;
    }

    public long getDataSize() {
        return FitsUtil.addPadding(this.trueDataSize());
    }

    public double getDoubleValue(IFitsHeader key) {
        return this.getDoubleValue(key.key());
    }

    public double getDoubleValue(IFitsHeader key, double dft) {
        return this.getDoubleValue(key.key(), dft);
    }

    public double getDoubleValue(String key) {
        return this.getDoubleValue(key, 0.0);
    }

    public double getDoubleValue(String key, double dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Double.class, dft);
    }

    public List<HeaderCard> getDuplicates() {
        return this.duplicates;
    }

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    public float getFloatValue(IFitsHeader key) {
        return this.getFloatValue(key.key());
    }

    public float getFloatValue(IFitsHeader key, float dft) {
        return (float)this.getDoubleValue(key, (double)dft);
    }

    public float getFloatValue(String key) {
        return (float)this.getDoubleValue(key);
    }

    public float getFloatValue(String key, float dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Float.class, Float.valueOf(dft)).floatValue();
    }

    public int getIntValue(IFitsHeader key) {
        return (int)this.getLongValue(key);
    }

    public int getIntValue(IFitsHeader key, int dft) {
        return (int)this.getLongValue(key, (long)dft);
    }

    public int getIntValue(String key) {
        return (int)this.getLongValue(key);
    }

    public int getIntValue(String key, int dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Integer.class, dft);
    }

    @Deprecated
    public String getKey(int n) {
        if (n >= 0 && n < this.cards.size()) {
            return this.cards.get(n).getKey();
        }
        return null;
    }

    public long getLongValue(IFitsHeader key) {
        return this.getLongValue(key.key());
    }

    public long getLongValue(IFitsHeader key, long dft) {
        return this.getLongValue(key.key(), dft);
    }

    public long getLongValue(String key) {
        return this.getLongValue(key, 0L);
    }

    public long getLongValue(String key, long dft) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null) {
            return dft;
        }
        return fcard.getValue(Long.class, dft);
    }

    public int getNumberOfCards() {
        return this.cards.size();
    }

    public int getNumberOfPhysicalCards() {
        int count = 0;
        for (HeaderCard card : this.cards) {
            count += card.cardSize();
        }
        return count;
    }

    public long getOriginalSize() {
        return FitsUtil.addPadding(this.originalCardCount * 80);
    }

    @Override
    public long getSize() {
        return this.headerSize();
    }

    public String getStringValue(IFitsHeader header) {
        return this.getStringValue(header.key());
    }

    public String getStringValue(String key) {
        HeaderCard fcard = this.findCard(key);
        if (fcard == null || !fcard.isStringValue()) {
            return null;
        }
        return fcard.getValue();
    }

    public boolean hadDuplicates() {
        return this.duplicates != null;
    }

    int headerSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        return FitsUtil.addPadding(this.getNumberOfPhysicalCards() * 80);
    }

    public void insertComment(String value) throws HeaderCardException {
        this.insertCommentStyle(Standard.COMMENT.key(), value);
    }

    public void insertCommentStyle(String header, String value) {
        try {
            this.iter.add(new HeaderCard(header, (String)null, value));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible Exception for comment style:" + header + ":" + value);
        }
    }

    public void insertHistory(String value) throws HeaderCardException {
        this.insertCommentStyle(Standard.HISTORY.key(), value);
    }

    boolean isValidHeader() {
        if (this.getNumberOfCards() < 4) {
            return false;
        }
        this.iter = this.iterator();
        String key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals(Standard.SIMPLE.key()) && !key.equals(Standard.XTENSION.key())) {
            return false;
        }
        key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals(Standard.BITPIX.key())) {
            return false;
        }
        key = ((HeaderCard)this.iter.next()).getKey();
        if (!key.equals(Standard.NAXIS.key())) {
            return false;
        }
        while (this.iter.hasNext()) {
            key = ((HeaderCard)this.iter.next()).getKey();
        }
        return key.equals(Standard.END.key());
    }

    public Cursor<String, HeaderCard> iterator() {
        return this.cards.iterator(0);
    }

    public Cursor<String, HeaderCard> iterator(int index) {
        return this.cards.iterator(index);
    }

    public Data makeData() throws FitsException {
        return FitsFactory.dataFactory(this);
    }

    public HeaderCard nextCard() {
        if (this.iter.hasNext()) {
            return (HeaderCard)this.iter.next();
        }
        return null;
    }

    void nullImage() {
        this.iter = this.iterator();
        try {
            this.addValue((IFitsHeader)Standard.SIMPLE, true);
            this.addValue((IFitsHeader)Standard.BITPIX, 8);
            this.addValue((IFitsHeader)Standard.NAXIS, 0);
            this.addValue((IFitsHeader)Standard.EXTEND, true);
        }
        catch (HeaderCardException e) {
            LOG.log(Level.SEVERE, "could not create null image, should not be possible", e);
        }
    }

    @Deprecated
    public void pointToData(Data o) throws FitsException {
        o.fillHeader(this);
    }

    Cursor<String, HeaderCard> positionAfterIndex(IFitsHeader prefix, int col) {
        String colnum = String.valueOf(col);
        this.iter.setKey(prefix.n(col).key());
        if (this.iter.hasNext()) {
            boolean toFar = false;
            while (this.iter.hasNext()) {
                String key = ((HeaderCard)this.iter.next()).getKey().trim();
                if (key != null && key.length() > colnum.length() && key.substring(key.length() - colnum.length()).equals(colnum)) continue;
                toFar = true;
                break;
            }
            if (toFar) {
                this.iter.prev();
            }
        }
        return this.iter;
    }

    @Override
    public void read(ArrayDataInput dis) throws TruncatedFileException, IOException {
        this.fileOffset = dis instanceof RandomAccess ? FitsUtil.findOffset(dis) : -1L;
        boolean firstCard = true;
        HeaderCardCountingArrayDataInput cardCountingArray = new HeaderCardCountingArrayDataInput(dis);
        try {
            String key;
            do {
                HeaderCard fcard = new HeaderCard(cardCountingArray);
                if (firstCard) {
                    key = fcard.getKey();
                    if (key == null || !key.equals(Standard.SIMPLE.key()) && !key.equals(Standard.XTENSION.key())) {
                        if (this.fileOffset > 0L && FitsFactory.getAllowTerminalJunk()) {
                            throw new EOFException("Not FITS format at " + this.fileOffset + ":" + key);
                        }
                        throw new IOException("Not FITS format at " + this.fileOffset + ":" + key);
                    }
                    firstCard = false;
                }
                if ((key = fcard.getKey()) != null && this.cards.containsKey(key)) {
                    this.addDuplicate((HeaderCard)this.cards.get(key));
                }
                if (CXCExt.LONGSTRN.key().equals(key)) {
                    FitsFactory.setLongStringsEnabled(true);
                }
                this.addLine(fcard);
            } while (!Standard.END.key().equals(key));
        }
        catch (EOFException e) {
            if (!firstCard) {
                throw new IOException("Invalid FITS Header:", new TruncatedFileException(e.getMessage()));
            }
            throw e;
        }
        catch (TruncatedFileException e) {
            if (firstCard && FitsFactory.getAllowTerminalJunk()) {
                EOFException eofException = new EOFException("First card truncated");
                eofException.initCause(e);
                throw eofException;
            }
            throw new IOException("Invalid FITS Header:", new TruncatedFileException(e.getMessage()));
        }
        catch (Exception e) {
            throw new IOException("Invalid FITS Header", e);
        }
        if (this.fileOffset >= 0L) {
            this.input = dis;
        }
        this.originalCardCount = cardCountingArray.getPhysicalCardsRead();
        try {
            dis.skipAllBytes(FitsUtil.padding(this.originalCardCount * 80));
        }
        catch (IOException e) {
            throw new TruncatedFileException(e.getMessage());
        }
    }

    @Deprecated
    public void removeCard(String key) throws HeaderCardException {
        this.deleteKey(key);
    }

    boolean replaceKey(IFitsHeader oldKey, IFitsHeader newKey) throws HeaderCardException {
        return this.replaceKey(oldKey.key(), newKey.key());
    }

    boolean replaceKey(String oldKey, String newKey) throws HeaderCardException {
        HeaderCard oldCard = this.findCard(oldKey);
        if (oldCard == null) {
            return false;
        }
        if (!this.cards.replaceKey(oldKey, newKey)) {
            throw new HeaderCardException("Duplicate key in replace");
        }
        oldCard.setKey(newKey);
        return true;
    }

    @Override
    public boolean reset() {
        try {
            FitsUtil.reposition(this.input, this.fileOffset);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void resetOriginalSize() {
        this.originalCardCount = this.getNumberOfPhysicalCards();
    }

    @Override
    public void rewrite() throws FitsException, IOException {
        ArrayDataOutput dos = (ArrayDataOutput)((Object)this.input);
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite Header.");
        }
        FitsUtil.reposition(dos, this.fileOffset);
        this.write(dos);
        dos.flush();
    }

    @Override
    public boolean rewriteable() {
        return this.fileOffset >= 0L && this.input instanceof ArrayDataOutput && (this.getNumberOfPhysicalCards() + 35) / 36 == (this.originalCardCount + 35) / 36;
    }

    public void setBitpix(int val) {
        this.iter = this.iterator();
        this.iter.next();
        try {
            this.iter.add(new HeaderCard(Standard.BITPIX.key(), val, Standard.BITPIX.comment()));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setBitpix " + e);
        }
    }

    public void setNaxes(int val) {
        this.iter.setKey(Standard.BITPIX.key());
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            this.iter.add(new HeaderCard(Standard.NAXIS.key(), val, Standard.NAXIS.comment()));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setNaxes " + e);
        }
    }

    public void setNaxis(int axis, int dim) {
        if (axis <= 0) {
            LOG.warning("setNaxis ignored because axis less than 0");
            return;
        }
        if (axis == 1) {
            this.iter.setKey(Standard.NAXIS.key());
        } else if (axis > 1) {
            this.iter.setKey(Standard.NAXISn.n(axis - 1).key());
        }
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            IFitsHeader naxisKey = Standard.NAXISn.n(axis);
            this.iter.add(new HeaderCard(naxisKey.key(), dim, naxisKey.comment()));
        }
        catch (HeaderCardException e) {
            LOG.log(Level.SEVERE, "Impossible exception at setNaxis", e);
        }
    }

    public void setSimple(boolean val) {
        this.deleteKey(Standard.SIMPLE);
        this.deleteKey(Standard.XTENSION);
        if (this.findCard(Standard.NAXIS) != null) {
            int nax = this.getIntValue(Standard.NAXIS);
            this.iter = this.iterator();
            if (this.findCard(Standard.NAXISn.n(nax)) != null) {
                this.iter.next();
                try {
                    this.deleteKey("EXTEND");
                    this.iter.add(new HeaderCard(Standard.EXTEND.key(), true, Standard.EXTEND.comment()));
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, "exception ignored in setSimple", e);
                }
            }
        }
        this.iter = this.iterator();
        try {
            this.iter.add(new HeaderCard(Standard.SIMPLE.key(), val, Standard.SIMPLE.comment()));
        }
        catch (HeaderCardException e) {
            LOG.log(Level.FINE, "Impossible exception at setSimple ", e);
        }
    }

    public void setXtension(String val) {
        this.deleteKey(Standard.SIMPLE);
        this.deleteKey(Standard.XTENSION);
        this.deleteKey(Standard.EXTEND);
        this.iter = this.iterator();
        try {
            this.iter.add(new HeaderCard(Standard.XTENSION.key(), val, Standard.XTENSION.comment()));
        }
        catch (HeaderCardException e) {
            System.err.println("Impossible exception at setXtension " + e);
        }
    }

    @Deprecated
    public int size() {
        return this.cards.size();
    }

    int trueDataSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        int naxis = this.getIntValue(Standard.NAXIS, 0);
        if (naxis == 0) {
            return 0;
        }
        this.getIntValue(Standard.BITPIX);
        int[] axes = new int[naxis];
        for (int axis = 1; axis <= naxis; ++axis) {
            axes[axis - 1] = this.getIntValue(Standard.NAXISn.n(axis), 0);
        }
        boolean isGroup = this.getBooleanValue(Standard.GROUPS, false);
        int pcount = this.getIntValue(Standard.PCOUNT, 0);
        int gcount = this.getIntValue(Standard.GCOUNT, 1);
        int startAxis = 0;
        if (isGroup && naxis > 1 && axes[0] == 0) {
            startAxis = 1;
        }
        int size = 1;
        for (int i = startAxis; i < naxis; ++i) {
            size *= axes[i];
        }
        size += pcount;
        size *= gcount;
        return size *= Math.abs(this.getIntValue(Standard.BITPIX, 0)) / 8;
    }

    public void updateLine(String key, HeaderCard card) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(card);
    }

    public void updateLine(IFitsHeader key, HeaderCard card) throws HeaderCardException {
        this.deleteKey(key);
        this.iter.add(card);
    }

    public void updateLines(Header newHdr) throws HeaderCardException {
        Cursor<String, HeaderCard> j = newHdr.iterator();
        while (j.hasNext()) {
            HeaderCard nextHCard = (HeaderCard)j.next();
            if (nextHCard.getKey().equals(Standard.COMMENT.key())) {
                this.insertComment(nextHCard.getComment());
                continue;
            }
            if (nextHCard.getKey().equals(Standard.HISTORY.key())) {
                this.insertHistory(nextHCard.getComment());
                continue;
            }
            this.updateLine(nextHCard.getKey(), nextHCard);
        }
    }

    @Override
    public void write(ArrayDataOutput dos) throws FitsException {
        this.fileOffset = FitsUtil.findOffset(dos);
        this.cards.sort(new HeaderOrder());
        this.checkBeginning();
        this.checkEnd();
        if (this.cards.size() <= 0) {
            return;
        }
        Cursor<String, HeaderCard> writeIterator = this.cards.iterator(0);
        try {
            while (writeIterator.hasNext()) {
                HeaderCard card = (HeaderCard)writeIterator.next();
                byte[] b = AsciiFuncs.getBytes(card.toString());
                dos.write(b);
            }
            FitsUtil.pad(dos, this.getNumberOfPhysicalCards() * 80, (byte)32);
            dos.flush();
        }
        catch (IOException e) {
            throw new FitsException("IO Error writing header: " + e);
        }
    }
}

