/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class ClasspathUtilities {
    private static final String resourceProtocolInJar = "jar:file:";

    public static void setFullSystemClasspathInSystemProperty(String property) {
        StringBuilder appPath = new StringBuilder();
        HashMap<String, String> jarFilesFullPathHash = new HashMap<String, String>();
        try {
            Enumeration<URL> urls = ClassLoader.getSystemClassLoader().getResources("META-INF");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    File file = new File(ClasspathUtilities.findFile(url));
                    jarFilesFullPathHash.put(file.getName(), file.getAbsolutePath());
                    if (file.isDirectory()) continue;
                    try {
                        JarFile jar = new JarFile(file);
                        Manifest manifest = jar.getManifest();
                        String manifestClassPath = null;
                        try {
                            manifestClassPath = manifest.getMainAttributes().getValue("Class-Path").trim();
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                        File parentDir = file.getParentFile();
                        if (manifestClassPath == null) continue;
                        StringTokenizer classPathTokens = new StringTokenizer(manifestClassPath, " ");
                        while (classPathTokens.hasMoreTokens()) {
                            String manifestClassPathJar = classPathTokens.nextToken();
                            File cpEntry = new File(parentDir, manifestClassPathJar);
                            if (!cpEntry.exists() || jarFilesFullPathHash.containsKey(manifestClassPathJar)) continue;
                            jarFilesFullPathHash.put(manifestClassPathJar, cpEntry.getAbsolutePath());
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                catch (URISyntaxException x) {
                    x.printStackTrace();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        String javaClassPath = System.getProperty("java.class.path");
        if (javaClassPath != null) {
            StringTokenizer st = new StringTokenizer(javaClassPath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String classPathEntry = st.nextToken();
                File cpEntry = new File(classPathEntry);
                if (!cpEntry.exists() || jarFilesFullPathHash.containsKey(cpEntry.getName())) continue;
                jarFilesFullPathHash.put(classPathEntry, cpEntry.getAbsolutePath());
            }
        }
        Iterator keysIter = jarFilesFullPathHash.keySet().iterator();
        while (keysIter.hasNext()) {
            String jarFullPath = (String)jarFilesFullPathHash.get(keysIter.next());
            appPath.append(jarFullPath);
            if (!keysIter.hasNext()) continue;
            appPath.append(File.pathSeparatorChar);
        }
        System.setProperty(property, appPath.toString());
    }

    private static String findFile(URL url) throws IllegalStateException, URISyntaxException {
        String uri = url.toURI().toString();
        if (uri.startsWith("file:")) {
            File f = new File(url.toURI());
            return f.getParent();
        }
        if (!uri.startsWith(resourceProtocolInJar)) {
            throw new IllegalStateException("This class has been loaded remotely");
        }
        int idx = uri.indexOf(33);
        if (idx == -1) {
            throw new IllegalStateException("You appear to have loaded this class from a local jar file, but I can't make sense of the URL!");
        }
        try {
            String fileName = URLDecoder.decode(uri.substring(resourceProtocolInJar.length(), idx), Charset.defaultCharset().name());
            return new File(fileName).getAbsolutePath();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("default charset doesn't exist. Your VM is borked.");
        }
    }
}

