/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.DummyLock;
import org.lsst.ccs.messaging.LockLevelService;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.logging.Logger;

public class AgentLockService
implements LockLevelService,
AgentPresenceListener,
ServiceLifecycle,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services.lockservice");
    private final List<AgentLevelListener> agentLevelListeners = new CopyOnWriteArrayList<AgentLevelListener>();
    private final List<AgentLockUpdateListener> agentLockUpdateListeners = new CopyOnWriteArrayList<AgentLockUpdateListener>();
    private final Map<String, Integer> agentLevels = new HashMap<String, Integer>();
    private final Map<String, AgentLock> heldLocks = new HashMap<String, AgentLock>();
    private final Object lockLevelUpdate = new Object();
    private final Semaphore levelListenersSemaphore = new Semaphore(1, true);
    private final Semaphore lockListenersSemaphore = new Semaphore(1, true);
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;

    @Override
    public String getAgentServiceName() {
        return "lockService";
    }

    @Override
    public void preInit() {
        this.agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            AgentLock lock = this.heldLocks.get(agentName);
            if (lock == null) {
                this.lockAgent(agentName);
            }
            this.setLevelInternal(agentName, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLevelForAgent(String agentName) {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            if (this.heldLocks.get(agentName) == null) {
                return 0;
            }
            return this.agentLevels.getOrDefault(agentName, 0);
        }
    }

    public AgentLock getLockForAgent(String agentName) {
        return this.getHeldLocks().get(agentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAgent(String agentName) throws UnauthorizedLockException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            if (this.heldLocks.get(agentName) != null) {
                return;
            }
            log.fine((Object)("acquiring lock for " + agentName));
            DummyLock lock = new DummyLock(agentName, this.agent.getName());
            this.setLockInternal(agentName, (AgentLock)lock);
            log.fine((Object)(this.agent.getName() + " acquired a lock for agent " + agentName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAgent(String agentName) throws IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            try {
                this.setLevelInternal(agentName, 0);
                this.setLockInternal(agentName, null);
            }
            catch (UnauthorizedLevelException | UnauthorizedLockException ex) {
                log.warning((Object)"Something went really wrong as we should not get these exceptions when unlocking.", (Throwable)ex);
            }
            log.fine((Object)(this.agent.getName() + " released a lock for agent " + agentName));
        }
    }

    public Map<String, AgentLock> getLocks() {
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, AgentLock> getHeldLocks() {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            return Collections.unmodifiableMap(this.heldLocks);
        }
    }

    public boolean validateLock(AgentLock lock) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentLevelListener(AgentLevelListener l) {
        HashMap<String, Integer> agentLevelsCopy = null;
        Iterator iterator = this.lockLevelUpdate;
        synchronized (iterator) {
            agentLevelsCopy = new HashMap<String, Integer>(this.agentLevels);
        }
        try {
            this.levelListenersSemaphore.acquireUninterruptibly();
            for (Map.Entry entry : agentLevelsCopy.entrySet()) {
                l.onAgentLevelChange((String)entry.getKey(), (Integer)entry.getValue());
            }
            this.agentLevelListeners.add(l);
        }
        finally {
            this.levelListenersSemaphore.release();
        }
    }

    public void removeAgentLevelListener(AgentLevelListener l) {
        this.agentLevelListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentLockUpdateListener(AgentLockUpdateListener slul) {
        HashMap<String, AgentLock> heldLocksCopy = null;
        Iterator iterator = this.lockLevelUpdate;
        synchronized (iterator) {
            heldLocksCopy = new HashMap<String, AgentLock>(this.heldLocks);
        }
        try {
            this.lockListenersSemaphore.acquireUninterruptibly();
            for (Map.Entry entry : heldLocksCopy.entrySet()) {
                slul.onAgentLockUpdate((String)entry.getKey(), (AgentLock)entry.getValue());
            }
            this.agentLockUpdateListeners.add(slul);
        }
        finally {
            this.lockListenersSemaphore.release();
        }
    }

    public void removeAgentLockUpdateListener(AgentLockUpdateListener l) {
        this.agentLockUpdateListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLockInternal(String agentName, AgentLock lock) throws UnauthorizedLockException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            this.heldLocks.put(agentName, lock);
        }
        this.notifyLockListeners(agentName, lock);
    }

    private void notifyLockListeners(String agentName, AgentLock lock) {
        this.lockListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLockUpdateListeners.forEach(l -> l.onAgentLockUpdate(agentName, lock));
            }
            finally {
                this.lockListenersSemaphore.release();
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLevelInternal(String agentName, int level) throws UnauthorizedLevelException, IOException {
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            log.fine((Object)(this.agent.getName() + " set a level for agent " + agentName + " to " + level));
            this.agentLevels.put(agentName, level);
        }
        this.notifyLevelListeners(agentName, level);
    }

    private void notifyLevelListeners(String agentName, int level) {
        this.levelListenersSemaphore.acquireUninterruptibly();
        Thread t = new Thread(() -> {
            try {
                this.agentLevelListeners.forEach(l -> l.onAgentLevelChange(agentName, level));
            }
            finally {
                this.levelListenersSemaphore.release();
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(AgentInfo ... agents) {
        for (AgentInfo ai : agents) {
            if (ai.getType().compareTo((Enum)AgentInfo.AgentType.WORKER) != 0) {
                return;
            }
            String name = ai.getName();
            AgentLock initialLock = null;
            int initialLevel = 0;
            Object object = this.lockLevelUpdate;
            synchronized (object) {
                initialLock = this.heldLocks.getOrDefault(name, null);
            }
            if (initialLock != null) {
                object = this.lockLevelUpdate;
                synchronized (object) {
                    initialLevel = this.agentLevels.getOrDefault(name, initialLock.getMaxLevel());
                }
            }
            try {
                this.setLevelInternal(name, initialLevel);
                this.setLockInternal(name, initialLock);
            }
            catch (IOException | UnauthorizedLevelException | UnauthorizedLockException ex) {
                log.warning((Object)"Problems trying to re-lock a connecting subsystem.", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLockableAgents() {
        ArrayList<String> result = new ArrayList<String>();
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            for (AgentInfo a : this.agent.getMessagingAccess().getAgentPresenceManager().listConnectedAgents()) {
                if (!a.getType().equals((Object)AgentInfo.AgentType.WORKER) || this.heldLocks.get(a.getName()) != null) continue;
                result.add(a.getName());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLockedAgents() {
        ArrayList<String> res = new ArrayList<String>();
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            for (Map.Entry<String, AgentLock> e : this.heldLocks.entrySet()) {
                if (e.getValue() == null) continue;
                res.add(e.getKey());
            }
        }
        return res;
    }

    public List<String> getAllWorkerAgents() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getLockableAgents());
        result.addAll(this.getLockedAgents());
        return result;
    }

    public static interface AgentLockUpdateListener {
        public void onAgentLockUpdate(String var1, AgentLock var2);
    }

    public static interface AgentLevelListener {
        public void onAgentLevelChange(String var1, int var2);
    }
}

